# HC Location Example: Mobile Unit Service Coverage Area - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC Location Example: Mobile Unit Service Coverage Area**

## Example Location: HC Location Example: Mobile Unit Service Coverage Area

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-09-01 14:45:30+0000

Profile: [HC Location](StructureDefinition-hc-location.md)

**identifier**: LSPN/876543

**name**: Sydney CBD Mobile Unit Service Area

**description**: Coverage area served by the Sydney CBD Mobile Healthcare Unit, encompassing the central business district and surrounding areas.

**type**: Virtual

**telecom**: ph: (02) 1234 5678(Work), [info@sydneycentralmc.com.au](mailto:info@sydneycentralmc.com.au)

**managingOrganization**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

**partOf**: [Location Mobile Healthcare Unit - Sydney CBD](Location-example-healthconnect-mobile-healthcare-unit-1.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "example-healthconnect-mobile-unit-coverage-area-1",
  "meta" : {
    "lastUpdated" : "2025-09-01T14:45:30Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "LSPN",
            "display" : "Location Specific Practice Number"
          }
        ],
        "text" : "LSPN"
      },
      "system" : "http://ns.electronichealth.net.au/id/location-specific-practice-number",
      "value" : "876543"
    }
  ],
  "name" : "Sydney CBD Mobile Unit Service Area",
  "description" : "Coverage area served by the Sydney CBD Mobile Healthcare Unit, encompassing the central business district and surrounding areas.",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/location-type",
          "code" : "VI",
          "display" : "Virtual"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(02) 1234 5678",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@sydneycentralmc.com.au",
      "use" : "work"
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/example-healthconnect-organization-1"
  },
  "partOf" : {
    "reference" : "Location/example-healthconnect-mobile-healthcare-unit-1"
  }
}

```
