# HC HealthcareService Example: Residential Aged Care - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC HealthcareService Example: Residential Aged Care**

## Example HealthcareService: HC HealthcareService Example: Residential Aged Care

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-09-02 18:00:00+0000

Profile: [HC HealthcareService](StructureDefinition-hc-healthcareservice.md)

**HC Active Period**: 2022-01-01 --> 2025-12-31

**HC Referral Information for Referrer**: 

**Referral required** from a GP or specialist.

Please include:

* Recent medical history
* Current medications

Referrals can be faxed to **(02) 1234 5679**.

**IAR Levels of Care**: Level 3 (moderate intensity interventions)

**HC Accept New Patient**: true

**providedBy**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

**type**: Geriatric evaluation and management service

**location**: [Location Sydney Central Medical Centre](Location-example-healthconnect-medical-centre-location-1.md)

**name**: Healthcare service with Residential Aged Care service type

**coverageArea**: [Location Sydney CBD Mobile Unit Service Area](Location-example-healthconnect-mobile-unit-coverage-area-1.md)

**serviceProvisionCode**: Fees apply, No fee

### Eligibilities

| | |
| :--- | :--- |
| - | **Code** |
| * | Older adult 65+ years |

**communication**: Italian, Chinese

**appointmentRequired**: true

> **availableTime****daysOfWeek**: Monday, Tuesday, Wednesday, Thursday, Friday**allDay**: false**availableStartTime**: 08:00:00**availableEndTime**: 17:30:00

**endpoint**: [Endpoint Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "example-healthconnect-healthcareservice-1",
  "meta" : {
    "lastUpdated" : "2025-09-02T18:00:00Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice"
    ]
  },
  "extension" : [
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-active-period",
      "valuePeriod" : {
        "start" : "2022-01-01",
        "end" : "2025-12-31"
      }
    },
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-referral-information-for-referrer",
      "valueMarkdown" : "**Referral required** from a GP or specialist.\n\nPlease include:\n- Recent medical history\n- Current medications\n\nReferrals can be faxed to **(02) 1234 5679**."
    },
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/iar-levels-of-care",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://ns.electronichealth.net.au/hc/CodeSystem/iar-levels-of-care",
            "code" : "3",
            "display" : "Level 3 (moderate intensity interventions)"
          }
        ]
      }
    },
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-accept-new-patient",
      "valueBoolean" : true
    }
  ],
  "providedBy" : {
    "reference" : "Organization/example-healthconnect-organization-1"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "1584801000168109",
          "display" : "Geriatric evaluation and management service"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/example-healthconnect-medical-centre-location-1"
    }
  ],
  "name" : "Healthcare service with Residential Aged Care service type",
  "coverageArea" : [
    {
      "reference" : "Location/example-healthconnect-mobile-unit-coverage-area-1"
    }
  ],
  "serviceProvisionCode" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/service-provision-conditions",
          "code" : "FAP",
          "display" : "Fees apply"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/service-provision-conditions",
          "code" : "NFE",
          "display" : "No fee"
        }
      ]
    }
  ],
  "eligibility" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "933451001000036104",
            "display" : "Older adult 65+ years"
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "coding" : [
        {
          "system" : "urn:ietf:bcp:47",
          "code" : "it",
          "display" : "Italian"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "urn:ietf:bcp:47",
          "code" : "zh",
          "display" : "Chinese"
        }
      ]
    }
  ],
  "appointmentRequired" : true,
  "availableTime" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
      "allDay" : false,
      "availableStartTime" : "08:00:00",
      "_availableStartTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/timezone",
            "valueCode" : "Australia/Sydney"
          }
        ]
      },
      "availableEndTime" : "17:30:00",
      "_availableEndTime" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/timezone",
            "valueCode" : "Australia/Sydney"
          }
        ]
      }
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/example-hc-endpoint-smd"
    }
  ]
}

```
