# Health Connect Provider Directory Requester - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **Health Connect Provider Directory Requester**

## CapabilityStatement: Health Connect Provider Directory Requester 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-provider-directory-requester | *Version*:0.2.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectProviderDirectoryRequester |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This[CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html)resource defines the expected capabilities of the[Health Connect Provider Directory Requester Actor](ActorDefinition-requester-actor-health-connect.md)when conforming to this implementation guide. The complete list of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Provider Directory Requester Actor are defined in this CapabilityStatement. The requirements of the Health Connect Provider Directory Requester actor may also be impacted by the rules of local jurisdictions or other contextual requirements. 

 [Raw OpenAPI-Swagger Definition file](health-connect-provider-directory-requester.openapi.json) | [Download](health-connect-provider-directory-requester.openapi.json) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "health-connect-provider-directory-requester",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-provider-directory-requester",
  "version" : "0.2.0-preview",
  "name" : "HealthConnectProviderDirectoryRequester",
  "title" : "Health Connect Provider Directory Requester",
  "status" : "draft",
  "date" : "2025-11-27",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This [CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html) resource defines the expected capabilities \nof the [Health Connect Provider Directory Requester Actor](ActorDefinition-requester-actor-health-connect.html) when conforming to this implementation guide. The complete \nlist of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Provider Directory Requester Actor are defined in this CapabilityStatement. \nThe requirements of the Health Connect Provider Directory Requester actor may also be impacted by the rules of local jurisdictions or other contextual requirements.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHOULD"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "client",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "OAuth",
                "display" : "OAuth"
              }
            ]
          }
        ],
        "description" : "All interactions SHOULD be secured using OAuth protocols. It SHOULD support authentication, authorisation, and audit logging in accordance with local policy and regulatory requirements."
      },
      "resource" : [
        {
          "type" : "Provenance",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "documentation" : "This resource is used to track the provenance of data retrieved, updated, or verified from external systems of record for HC resources.",
          "interaction" : [
            {
              "code" : "read",
              "documentation" : "Read HC Provenance records to understand data lineage"
            },
            {
              "code" : "search-type",
              "documentation" : "Search for HC Provenance records by target resource or activity"
            }
          ],
          "versioning" : "versioned",
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "target",
              "definition" : "http://hl7.org/fhir/SearchParameter/Provenance-target|4.0.1",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Organization",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section defines the supported interactions by a Requester Actor for the HC Organization profile of the Organization resource type.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchInclude" : ["Organization:partOf"],
          "searchRevInclude" : ["Location:organization", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-identifier|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-type|4.0.1",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Location",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "documentation" : "This section introduces the supported interactions by a Requester Actor for the HC Location profile.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchInclude" : ["Location:endpoint"],
          "searchRevInclude" : ["HealthcareService:location", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "locmailaddress",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-locmailaddress|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "locationamenities",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-amenities|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "address",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-address|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-type|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "locationphysicaltype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-physicaltype|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "near",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-near|4.0.1",
              "type" : "special"
            }
          ]
        },
        {
          "type" : "HealthcareService",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "documentation" : "This section introduces the supported interactions by a Requester Actor for the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.html) profile.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "searchInclude" : [
            "HealthcareService:location",
            "HealthcareService:providedBy",
            "HealthcareService:endpoint"
          ],
          "searchRevInclude" : ["PractitionerRole:healthcareService", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "languages",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/languages|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "hsbilling",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/healthcareservice-billing|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "allday",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/allday|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "daysofweek",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/daysofweek|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "starttime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/starttime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "endtime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endtime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "service-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/HealthcareService-service-type|4.0.1",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "documentation" : "This section defines the supported interactions for the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile of the PractitionerRole resource type. Each PractitionerRole resource conforming to the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile describes a practitioner in a role at a healthcare service.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "searchInclude" : [
            "PractitionerRole:practitioner",
            "PractitionerRole:healthcareService",
            "PractitionerRole:organization",
            "PractitionerRole:location",
            "PractitionerRole:endpoint"
          ],
          "searchRevInclude" : ["Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "languages",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/languages|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "allday",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/allday|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "daysofweek",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/daysofweek|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "starttime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/starttime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "endtime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endtime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "roletype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitionerrole-roletype|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier-r5",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-identifier-r5|0.2.0-preview",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section defines the supported interactions for the [HC Practitioner](StructureDefinition-hc-practitioner.html) profile of the Practitioner resource type.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "searchRevInclude" : ["PractitionerRole:practitioner", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-identifier|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "regprof",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-regprof|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "rsg",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-rsg|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "genderIdentity",
              "definition" : "http://hl7.org.au/fhir/SearchParameter/gender-identity|6.0.0",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "identifier-r5",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-identifier-r5|0.2.0-preview",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Endpoint",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHOULD"
              }
            ]
          },
          "documentation" : "This section defines the supported interactions for the [HC Endpoint](StructureDefinition-hc-endpoint.html) profile of the Endpoint resource type. Each Endpoint resource conforming to the [HC Endpoint](StructureDefinition-hc-endpoint.html) profile is a read-only proxy for a corresponding Endpoint resource published by the HC portal.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchRevInclude" : [
            "HealthcareService:endpoint",
            "Location:endpoint",
            "PractitionerRole:endpoint",
            "Provenance:target"
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "epurl",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-url|0.2.0-preview",
              "type" : "uri"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "payloadmimetype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-payloadmimetype|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "hcepi",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-hcepi|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "connection-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-connection-type|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "name" : "payload-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-payload-type|4.0.1",
              "type" : "token"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "search-system",
          "documentation" : "**Definition**:\r\n    \n This operation is a RESTful *search* interaction (whole system interaction), across multiple resource types (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)). \r\n    \n\r\n    \n **Behaviour**:\r\n    \n This operation is used by a client system operated by a Health Connect Provider Directory Requester to get resources that match the specified search parameters. .\r\n    \n\r\n    \n The following  search parameters are supported:\r\n    \n\r\n    \n * *_lastUpdated* is used to get the resources that have been added or changed since the requesting system last synchronised their local data store with Health Connect Provider Directory Requester.  This search parameter supports the ```gt``` and ```lt``` comparison prefixes.\r\n    \n * *_type* is used to filter the resources returned by their resource type. The available types are: \r\n    \n\r\n    \n   * ```HealthcareService``` (returns resources conforming to the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.html) profile)\r\n    \n   * ```PractitionerRole``` (returns resources conforming to the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile)\r\n    \n   * ```Organization``` (returns resources conforming to the [HC Organization](StructureDefinition-hc-organization.html) profile)\r\n    \n   * ```Location``` (returns resources conforming to the [HC Location](StructureDefinition-hc-location.html) profile)\r\n    \n   * ```Practitioner``` (returns resources conforming to the [HC Practitioner](StructureDefinition-hc-practitioner.html) profile)\r\n    \n   * ```Provenance``` (returns resources conforming to the [HC Provenance](StructureDefinition-hc-provenance.html) profile)\r\n    \n   \r\n    \n \r\n    \n All of the following query parameters are required in order to receive the complete set of resources that have been created, changed or published since *[last_synchronized]*:\r\n    \n\r\n    \n ``` _lastUpdated=[last_synchronized] ```\r\n    \n ```_type=HealthcareService,PractitionerRole,Practitioner,Organization,Location,Provenance ```\r\n    \n ```_include=Location:organization ```\r\n    \n ```_include=HealthcareService:organization ```\r\n    \n ```_include=HealthcareService:location ```\r\n    \n ```_include=PractitionerRole:organization ```\r\n    \n ```_include=PractitionerRole:location ```  \r\n    \n ```_include=PractitionerRole:service ```\r\n    \n ```_include=PractitionerRole:practitioner ``` \r\n    \n ```_include=Provenance:target ```   \r\n    \n ```_include:iterate=HealthcareService:organization  ```  \r\n    \n ```_include:iterate=HealthcareService:location ```\r\n    \n ```_include:iterate=PractitionerRole:organization ```\r\n    \n ```_include:iterate=PractitionerRole:location ```\r\n    \n ```_include:iterate=PractitionerRole:service ```\r\n    \n ```_include:iterate=PractitionerRole:practitioner ```\r\n    \n \r\n    \n As described above the resources returned in the Bundle exclude any *Identifiers* (e.g. HPI-Is) that cannot be disclosed to the subscriber.\r\n    \n \r\n    \n This operation supports 'paging' ([see FHIR specification](https://www.hl7.org/fhir/search.html#Paging)).  If there are too many resources to return in one ```Bundle```, the FHIR server adds a *next* link to the response ```Bundle```. The contents of the result ```Bundle``` therefore comprise all instances of the requested resource types whose *lastUpdated* timestamp is greater than the \\<lastSync\\> in the request query expression and less than or equal to \\<lastInBundle\\> where \\<lastInBundle\\> is the greatest *lastUpdated* value of all resources included in the result ```Bundle```. The Subscriber Agent FHIR server sets the *next* link to the filter expression that was used in the original request except that \\<lastSync\\> is replaced with \\<lastInBundle\\>. If the *next* link is not present in the Bundle, then there are no more service offerings available.    "
        }
      ],
      "searchParam" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "name" : "_lastUpdated",
          "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated|4.0.1",
          "type" : "date"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "name" : "_type",
          "type" : "token"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "name" : "_include",
          "type" : "special"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "name" : "_resultId",
          "type" : "special"
        }
      ]
    }
  ]
}

```
