# Search Parameters - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **Search Parameters**

## Search Parameters

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Custom Search Parameters

This page lists the custom SearchParameters that have been defined within this Implementation Guide.

| | |
| :--- | :--- |
| [All Day](SearchParameter-allday.md) | Search HealthcareServices or PractitionerRoles by whether they are available all day. |
| [End Time](SearchParameter-endtime.md) | Search HealthcareServices or PractitionerRoles by availability end time. |
| [Start Time](SearchParameter-starttime.md) | Search HealthcareServices or PractitionerRoles by availability start time. |
| [Days of Week](SearchParameter-daysofweek.md) | Search HealthcareServices or PractitionerRoles by days of week availability. Supports multiple days using OR logic. |
| [Endpoint Payload Mime Type](SearchParameter-endpoint-payloadmimetype.md) | Search for Endpoint resources by payloadMimeType. |
| [Endpoint URL](SearchParameter-endpoint-url.md) | Search for Endpoint resources by address (URL). |
| [HC Endpoint Identifier](SearchParameter-endpoint-hcepi.md) | Search an Endpoint record by its HC identifier. |
| [Healthcare Service Billing](SearchParameter-healthcareservice-billing.md) | Search for HealthcareService resources by billing information. |
| [Languages](SearchParameter-languages.md) | Search HealthcareServices or PractitionerRoles by supported languages/communication methods. Shared across HealthcareService and PractitionerRole. |
| [Location Amenities](SearchParameter-location-amenities.md) | Search for Location resources by amenities. |
| [Location Physical Type](SearchParameter-location-physicaltype.md) | Search for Location resources by physicalType field. |
| [Location Postal Address](SearchParameter-location-locmailaddress.md) | Search for Location resources by postal address components. |
| [Practitioner's Registered Profession](SearchParameter-practitioner-regprof.md) | Search a Practitioner record by their registered profession using string values. |
| [Practitioner's Role Type](SearchParameter-practitionerrole-roletype.md) | Search a PractitionerRole record by their role type. |
| [Practitioner's Recorded Sex or Gender](SearchParameter-practitioner-rsg.md) | Search a Practitioner record by their recorded sex or gender. |
| [Practitioner Identifier (R5)](SearchParameter-practitioner-identifier-r5.md) | Search a Practitioner record by any identifier, including HPI-I and Professional Registration Number (PRN), mimicks R5-style identifier searching. Supports both`Practitioner.identifier`and`Practitioner.qualification.identifier`. |

### Search Modifiers

The Health Connect Provider Directory supports specific search modifiers for string-type search parameters to tailor search functionality:

* **`:exact`** - Performs case-sensitive, exact matching without partial matching. Use this when you need precise lookups with string-type parameters.
* **`:contains`** - Searches for the value anywhere within the string, not just at the beginning. Use this for broader text searches.

**Note:** Token-type search parameters (such as `hcepi`) provide exact matching by default and do not require modifiers.

#### String-Type Parameters with Modifier Support

The following string-type search parameters can be used with the appropriate modifier:

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| `name (R4)` | Practitioner | string | Exact name match (case-sensitive) | **Recommended:**Search for practitioners by partial name matches |
| `languages` | HealthcareService, PractitionerRole | string | Exact language match (case-sensitive) | **Recommended:**Search for partial language matches |
| `regprof` | Practitioner | string | Exact profession match (case-sensitive) | **Recommended:**Search for partial profession matches |
| `roletype` | PractitionerRole | string | Exact role type match (case-sensitive) | **Recommended:**Search for partial role type matches |
| `locmailaddress` | Location | string | Not supported | Search postal address components |

### Prefix Operators for Time Availability Searches

The [Start Time](SearchParameter-starttime.md) and [End Time](SearchParameter-endtime.md) search parameters support numeric prefix operators, allowing you to search for times before, after, or at a specific value. These parameters use a four-digit numeric format (**HHMM**, e.g., `0830` for 8:30am, `1700` for 5:00pm).

You can use the following prefixes to control the comparison:

| | | | |
| :--- | :--- | :--- | :--- |
| `eq` | Equal | `eq0830` | Matches exactly 08:30am |
| `ne` | Not equal | `ne1700` | Matches any time except 5:00pm |
| `gt` | Greater than | `gt0900` | Matches times after 9:00am |
| `lt` | Less than | `lt1200` | Matches times before 12:00pm (noon) |
| `ge` | Greater than or equal | `ge0800` | Matches times at or after 8:00am |
| `le` | Less than or equal | `le1700` | Matches times at or before 5:00pm |

For example, to find HealthcareServices available after 9:00am, search with `starttime=gt0900`.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

