# Home - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect | *Version*:0.2.0-preview |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

# Health Connect FHIR ImplementationGuide

> This material is under active development and content may be added or updated on a regular basis.

ADHA review feedback

We welcome your feedback on this implementation guide.

To contribute directly to this implementation guide with code changes or documentation updates, please fork the repository and submit a pull request.

For technical FHIR-related comments, implementation feedback, or suggestions for profile improvements, you can create a GitHub issue.

For feedback concerning design considerations, business requirements, or broader implementation strategy, please [contact the Clinical Informatics team](mailto:informatics@digitalhealth.gov.au).

**Note:** The next release of this FHIR Implementation Guide (beyond Snapshot 2) will include updates to the URL scheme to ensure clarity about the scope of this IG in relation to future Health Connect FHIR Implementation Guides.

### Scope

This Implementation Guide (IG) defines how a Health Connect Provider Directory Requester Actor (client) interacts with a Health Connect Provider Directory Responder Actor (server), specifying the expected behaviors for each. The Requester Actor is a read-only FHIR client: it may perform search and read operations, but does not create, update, or delete resources in Health Connect. The capability statements in this IG set out the minimum operations and behaviors that conformant implementations must support. For the Responder Actor, requirements are expressed as SHALL statements, indicating mandatory support. For the Requester Actor, requirements are a mix of SHALL (mandatory) and SHOULD (recommended) statements, as detailed in the relevant [capability statements](capability-statements.md) and [conformance statement](conformance.md) sections of this guide. For further detail please appraise both the [capability statements](capability-statements.md) and [conformance statement](conformance.md).

### Introduction

Health Connect Australia is a national health information exchange program designed to enable the sharing of health information between healthcare participants quickly and securely. By integrating advanced digital infrastructure, standards, privacy protections and enabling real-time data sharing, Health Connect Australia will support multidisciplinary collaboration across care settings. As a key enabler of the [National Digital Health Strategy 2023–2028](https://www.digitalhealth.gov.au/national-digital-health-strategy) and the [National Healthcare Interoperability Plan 2023-2028](https://www.digitalhealth.gov.au/about-us/strategies-and-plans/national-healthcare-interoperability-plan), it ensures secure, connected digital solutions that improve access, efficiency and care quality-paving the way for a smarter, more integrated future in digital health. The program is being delivered in phases, beginning with foundational capabilities and expanding to support secure communication, record discovery, and value-added services for both providers and consumers.

The Directory and Authorisation Service Project is the first initiative under the Foundations phase. It enables healthcare providers to discover accurate, up-to-date information about other providers and the services they offer, while establishing a trust framework to support consistent and secure access to health information. By connecting provider data from multiple primary sources through a single access point and ensuring near real-time updates, the project lays the groundwork for broader interoperability and trusted information exchange across the national health ecosystem.

One of the key objectives of the Directory and Authorisation Service Project is to enable interoperability through contemporary standards-such as FHIR APIs-to ensure seamless integration across clinical and administrative systems. To support this, the project is establishing a centralised directory hosted on a FHIR repository, where provider and organisation data will be structured using HL7® FHIR® and terminology standards. To guide consistent implementation and promote national alignment, the project is developing a FHIR Implementation Guide that defines how provider information should be represented and exchanged. This guide will build on existing standards, including the HL7 Australia FHIR AU Core, and provide a clear reference for integrators and system vendors to support secure, scalable, and standards-compliant access to directory data.

### How to read this guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for the implementation guide.
* [Guidance](guidance.md): This page provides implementation guidance and best practices for using the Health Connect Provider Directory FHIR IG.
* [FHIR Artefacts](artifacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Artifacts Summary](artifacts.md): This page provides a comprehensive summary of all FHIR artifacts defined in this implementation guide including profiles, extensions, terminology, and other conformance resources.
* [Profiles and Extensions](profiles-and-extensions.md): This page lists the FHIR profiles and extensions that are defined in this guide.
* [Terminology](terminology.md): This page lists the FHIR terminology that are defined in this guide.
* [Capability Statements](capability-statements.md): This page defines the expected FHIR capabilities of Health Connect Provider Directory Requester and Health Connect Provider Directory Responder.
* [Search Parameters](artifacts.md#behavior-search-parameters): This page lists the FHIR search parameters that are defined in this guide.
* [Actor Definitions](actors.md): This page defines the Health Connect actors, Health Connect Provider Directory Requester and Health Connect Provider Directory Responder.
 
* [Conformance](conformance.md): This page describes the set of rules to claim conformance to this guide including capability statements and actor definitions.
* [Examples](examples.md): This page lists the sample instances of FHIR resources conforming to the FHIR profiles.
* [Disclaimers](disclaimers.md): This page lists the licensing, copyright, and disclaimers under which this guide is issued.
* [Downloads](downloads.md): This page provides links to downloadable artefacts including the Agency FHIR NPM package.
* [Change Log](changelog.md): This page documents the version history and changes made to this implementation guide across different releases.

### Document purpose and scope

The primary aim of this implementation guide is to support implementers integrating with the Directory services using [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4). It provides the technical specifications, FHIR profiles, and terminology definitions required for healthcare provider data exchange through Health Connect Provider Directory APIs.

This document describes specific system behaviours such as obligations, API HTTP response codes, and search parameters. Other system behavioural requirements such as the presentation of information and user experience are managed separately and must be met before systems can be assessed for conformance and granted access to Health Connect APIs.

Reference has been made to International and Australian Standards, and to Standards from HL7. The following standards are referred to in the text in such a way that some or all of its content constitutes requirements for the purposes of this specification:

* [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4)
* [Australian Base Profiles Implementation Guide [HL7AUBIG]](#HL7AUBIG)
* [Australian Core Profiles Implementation Guide [HL7AUCIG]](#HL7AUCIG)

Wherever possible, material in this specification is based on existing standards. All efforts have been made to minimise divergence from the HL7 Australia standards ([AU Core [HL7AUCIG]](#HL7AUCIG) and [AU Base [HL7AUBIG]](#HL7AUBIG)) to provide for system interoperability and compatibility with other profiles. Issues of an editorial nature in the source material (such as spelling or punctuation errors) are intentionally reproduced. For a list of known issues (see below).

### Intended audience

This implementation guide is aimed at software development teams, architects, and designers that integrate with the Health Connect Provider Directory system.

This implementation guide and related artefacts are technical in nature and the audience is expected to be familiar with the language of health data specifications and to have some familiarity with health information standards and specifications, such as FHIR.

### Relationships with other work

This implementation guide builds on other specifications, helping ensure a consistent approach to data sharing that should ease adoption. The specific guides used, and the portions relevant from each of them are as follows:

### Cross version analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (au.digitalhealth.r4.healthconnect.r4)](package.r4.tgz) and [R4B (au.digitalhealth.r4.healthconnect.r4b)](package.r4b.tgz) are available.

### Global profiles

*There are no Global profiles defined*

### Data model overview

The Health Connect Provider Directory uses FHIR resources to represent healthcare providers, their roles, organisational affiliations, service locations, and the healthcare services they provide. The diagram below illustrates the key relationships between these FHIR resources:

* Practitioner - Individual healthcare providers with their professional qualifications and identifiers
* Organization - Healthcare organisations and facilities that employ or affiliate with practitioners
* HealthcareService - Specific services offered by organisations at locations
* Location - Physical or virtual locations where healthcare services are delivered
* Endpoint - Technical endpoints for digital service integration and communication

This model supports complex healthcare delivery scenarios while maintaining FHIR R4 compliance and enabling efficient provider directory searches and integrations.

### Known issues

This table lists known issues with this specification at the time of publishing. We are working on solutions to these issues and encourage comments to help us develop these solutions.

* Reference: Example system URI
  * Description: An inherited example system (e.g.`http://www.acme.com/identifiers/patient`) erroneously infers patient context. Implementers must use their own namespace URIs. The affected identifier profile is Endpoint (HC-EPI) - this profile includes the erroneous example `system` in their documentation.

### References

| | |
| :--- | :--- |
| [HL7AUBIG] | HL7 Australia, FHIR R4 standard for AU Base Implementation Guide, v6.0.0 |
|   | [https://hl7.org.au/fhir/6.0.0/index.html](https://hl7.org.au/fhir/6.0.0/index.html) |

| | |
| :--- | :--- |
| [HL7FHIR4] | Health Level Seven, Inc., 30 October 2019, FHIR R4. |
|   | [http://hl7.org/fhir/R4/](http://hl7.org/fhir/R4/) |

| | |
| :--- | :--- |
| [HL7AUCIG] | HL7 Australia, FHIR R4 standard for AU Core Implementation Guide, v2.0.0-ballot - Ballot (Ballot) |
|   | [https://hl7.org.au/fhir/core/2.0.0-ballot/index.html](https://hl7.org.au/fhir/core/2.0.0-ballot/index.html) |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "au.digitalhealth.r4.healthconnect",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect",
  "version" : "0.2.0-preview",
  "name" : "HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide",
  "title" : "Health Connect Australia Provider Directory FHIR Implementation Guide",
  "status" : "draft",
  "experimental" : false,
  "date" : "2026-01-20T04:27:33+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This Implementation Guide defines an Health Connect Australia Provider Directory within Australian context.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "packageId" : "au.digitalhealth.r4.healthconnect",
  "license" : "CC-BY-4.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_au_core",
      "uri" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core",
      "packageId" : "hl7.fhir.au.core",
      "version" : "2.0.0-ballot"
    },
    {
      "id" : "hl7_fhir_au_base",
      "uri" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base",
      "packageId" : "hl7.fhir.au.base",
      "version" : "6.0.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Preview"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "default-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludexml"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludejson"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "tx"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "generate"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "init"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-all"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ns.electronichealth.net.au/hc/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Preview"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "default-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludexml"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludejson"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "tx"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "generate"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "init"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-all"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ns.electronichealth.net.au/hc/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/allday"
        },
        "name" : "All Day Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by whether they are available all day.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/daysofweek"
        },
        "name" : "Days of Week Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by days of week availability. Supports multiple days using OR logic.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endtime"
        },
        "name" : "End Time Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by end time. Query values must use a four-digit numeric 24 hr time format (HHMM, e.g., 0830 for 8:30am). The end time is converted to an integer to enable prefix-based time searches (e.g., gt, lt, ge, le).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endpoint-payloadmimetype"
        },
        "name" : "Endpoint Payload Mime Type Search Parameter",
        "description" : "Search for Endpoint resources by payloadMimeType.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endpoint-url"
        },
        "name" : "Endpoint URL Search Parameter",
        "description" : "Search for Endpoint resources by address (URL).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-accept-new-patient"
        },
        "name" : "HC Accept New Patient",
        "description" : "Indicates whether the healthcare service is accepting new patients. Patterned after PCA New Patient Availability extension.\n\nContext of Use: HealthcareService",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-active-period"
        },
        "name" : "HC Active Period",
        "description" : "The period during which the HealthcareService is considered active in the Health Connect Provider Directory Responder. Patterned after PCA Active Period.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-amenity"
        },
        "name" : "HC Amenity",
        "description" : "Physical features or amenities available within, or in close proximity of, a location. Uses the NCTS Facility Amenity ValueSet.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-endpoint-payload-type-vs"
        },
        "name" : "HC Australian Endpoint Payload Types",
        "description" : "The Australian Endpoint Payload Types value set enumerates well known endpoint payload types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-endpoint-payload-type-cs"
        },
        "name" : "HC Australian Endpoint Payload Types",
        "description" : "The Endpoint Payload Types code system defines concepts that identify well known endpoint payload types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-service-interfaces-vs"
        },
        "name" : "HC Australian Service Interfaces",
        "description" : "The Health Connect Australian Service Interfaces value set enumerates well known service interfaces that can be used for specifying a connection type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-service-interfaces-cs"
        },
        "name" : "HC Australian Service Interfaces",
        "description" : "The Australian Secure Message Service Interfaces code system defines concepts that identify service interfaces for secure message delivery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-endpoint"
        },
        "name" : "HC Endpoint",
        "description" : "This profile defines content for describing details of an endpoint.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Endpoint"
          }
        ],
        "reference" : {
          "reference" : "Endpoint/example-hc-endpoint-smd"
        },
        "name" : "HC Endpoint Example: SMD Target",
        "description" : "An example Endpoint with an SMD target identifier for secure messaging conforming to the HC Endpoint profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-endpoint-identifier"
        },
        "name" : "HC Endpoint Identifier (HC-EPI)",
        "description" : "This identifier profile defines a unique identifier allocated to a healthcare endpoint, in a Health Connect Provider Directory context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endpoint-hcepi"
        },
        "name" : "HC Endpoint Identifier Search Parameter",
        "description" : "Search an Endpoint record by its HC identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/HCGenderIdentityVs"
        },
        "name" : "HC Gender Identity ValueSet",
        "description" : "A value set of gender identities recognised by Health Connect.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-hpio"
        },
        "name" : "HC Healthcare Provider Identifier - Organisation (HC HPI-O)",
        "description" : "This identifier profile extends the AU HPI-O profile to include an organization classification extension to indicate whether the organization is a 'seed' or 'network' type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-hspo"
        },
        "name" : "HC Healthcare Support Service Provider - Organisation (HC HSP-O)",
        "description" : "This identifier profile defines a Healthcare Support Service Provider Organisation in an Australian context. An HSP-O is assigned under the HI Service to a service (in-home care support and personal care services) where healthcare is provided. A HSP-O can only be of 'seed' type. An Organization cannot be assigned both an HPI-O and an HSP-O; only one identifier is assigned by the HI Service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-healthcareservice"
        },
        "name" : "HC HealthcareService",
        "description" : "This profile of HealthcareService represents a particular type of health or health related service offered by a healthcare organisation at a particular location i.e. a practice, clinic, facility, or hospital. The authoritative source for healthcare services is the healthcare provider organisation that provides the service(s).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "HealthcareService"
          }
        ],
        "reference" : {
          "reference" : "HealthcareService/example-healthconnect-healthcareservice-1"
        },
        "name" : "HC HealthcareService Example: Residential Aged Care",
        "description" : "A Residential Aged Care HealthcareService example conforming to the HC HealthcareService profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-location"
        },
        "name" : "HC Location",
        "description" : "This profile defines a healthcare location (can also be referred as 'location') reflects the place, a site of care i.e. a practice, clinic, hospital, or facility at which healthcare services are provided by the healthcare organisation. The healthcare location can be a physical, mobile, or virtual location. In certain cases, a healthcare location can also represent a site of care within the hospital or building premises such as consulting room, operating room, outpatient room, unit, ward (e.g. maternity ward), department (e.g. emergency department) etc.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-medical-centre-location-1"
        },
        "name" : "HC Location Example: Medical Centre (Physical Building)",
        "description" : "A physical medical centre location example with wheelchair access, conforming to the HC Location profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-mobile-healthcare-unit-1"
        },
        "name" : "HC Location Example: Mobile Healthcare Unit",
        "description" : "A mobile healthcare unit location example with wheelchair access, conforming to the HC Location profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-mobile-unit-coverage-area-1"
        },
        "name" : "HC Location Example: Mobile Unit Service Coverage Area",
        "description" : "A virtual coverage area defining the geographical service boundary for the mobile healthcare unit.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-virtual-telehealth-service-1"
        },
        "name" : "HC Location Example: Virtual Telehealth Service",
        "description" : "A virtual telehealth service location example without physical address, conforming to the HC Location profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-organization"
        },
        "name" : "HC Organization",
        "description" : "This profile defines a Provider Directory entry for an organisation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-org-classification"
        },
        "name" : "HC Organization Classification",
        "description" : "Extension to record whether an organisation's HPIO is a 'seed' or 'network' type in the HI service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-org-classification-cs"
        },
        "name" : "HC Organization Classification CodeSystem",
        "description" : "Internal code system that describes whether an organisation is a 'seed' or 'network' type used by Health Connect.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-org-classification-vs"
        },
        "name" : "HC Organization Classification ValueSet",
        "description" : "The Health Connect ValueSet referencing the HC Organization Classification CodeSystem (seed, network).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/example-healthconnect-organization-1"
        },
        "name" : "HC Organization Example: Aged Care Facility",
        "description" : "An Aged Care Facility example conforming to the HC Organization profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/example-healthconnect-organization-2"
        },
        "name" : "HC Organization Example: Home Care Support Service",
        "description" : "A Home Care Support Service example conforming to the HC Organization profile with HSP-O identifier.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/pca-hsi"
        },
        "name" : "HC PCA Healthcare Service Identifier (PCA-HSI)",
        "description" : "Identifier for a healthcare service as allocated by PCA.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-pbprn"
        },
        "name" : "HC Peak Body Professional Registration Number (HC-PBPRN)",
        "description" : "This identifier profile defines a professional registration number allocated to a healthcare practitioner, in a Health Connect Provider Directory context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-practitioner"
        },
        "name" : "HC Practitioner",
        "description" : "This profile defines Healthcare Provider Individual details who is delivering health related services.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/example-healthconnect-practitioner-1"
        },
        "name" : "HC Practitioner Example: Alex Smith",
        "description" : "An example Practitioner (Alex Smith) conforming to the HC Practitioner profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/external-hc-practitioner-record"
        },
        "name" : "HC Practitioner Example: External Record (PRN)",
        "description" : "An external practitioner record example (PRN identifier) conforming to the HC Practitioner profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-practitioner-role-communication"
        },
        "name" : "HC Practitioner Role Communication",
        "description" : "Health Connect Practitioner Role Communication. This extension captures communication preferences and capabilities for a practitioner in a given role.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-practitionerrole"
        },
        "name" : "HC PractitionerRole",
        "description" : "This profile defines a practitioner in role for an organisation at a location providing a healthcare service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/example-healthconnect-practitionerrole-1"
        },
        "name" : "HC PractitionerRole Example: Medicare Provider",
        "description" : "An example PractitionerRole (Medicare) that conforms to the HC PractitionerRole profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-preferred-name"
        },
        "name" : "HC Preferred Name",
        "description" : "This extension applies to PractitionerRole, and represents a name by which a practitioner chooses to be known in the context of the delivery of a specific healthcare service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-preferred-postal-address"
        },
        "name" : "HC Preferred Postal Address",
        "description" : "Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-provenance"
        },
        "name" : "HC Provenance",
        "description" : "This profile of Provenance is used to record an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/provenance-practitioner-name-update"
        },
        "name" : "HC Provenance Example: Practitioner Name Amendment",
        "description" : "Demonstrates provenance tracking for a practitioner's name amendment, conforming to the HC Provenance profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/provenance-practitioner-phone-update"
        },
        "name" : "HC Provenance Example: Practitioner Phone Amendment",
        "description" : "Demonstrates provenance tracking for a practitioner's phone number amendment, conforming to the HC Provenance profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance|0.2.0-preview"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-referral-information-for-referrer"
        },
        "name" : "HC Referral Information for Referrer",
        "description" : "Referral instructions and information for healthcare service providers that may wish to refer patients / clients to the healthcare service. Modelled after PCA but for Health Connect context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-service-coverage-area"
        },
        "name" : "HC Service Coverage Area",
        "description" : "This profile of Location represents an Australian geographic coverage area i.e. postcodes where this service is provided.\nFor a healthcare service, that is provided through a physical location but have eligibility restrictions applicable in terms of only residents for certain postcodes/suburbs can receive this service, then the details of coverage area and eligibility should be provided here.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-service-provision-code-vs"
        },
        "name" : "HC Service Provision Code",
        "description" : "The HC Service Provision Code value set includes values that may be used to identify the service provision condition of a healthcare service in HC.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-service-provision-code-cs"
        },
        "name" : "HC Service Provision Code",
        "description" : "The HC Service Provision Code code system defines a concept (in addition to those defined in [Service Provision Conditions Australian Concepts](https://hl7.org.au/fhir/4.1.0/CodeSystem-service-provision-conditions.html) that may be used to identify the service provision condition of a healthcare service in HC.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-smd-target-identifier"
        },
        "name" : "HC SMD Target Identifier (HC-SMDTI)",
        "description" : "This identifier profile defines a SMD target identifier allocated to a healthcare practitioner, in a Health Connect Provider Directory context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/health-connect-provider-directory-requester"
        },
        "name" : "Health Connect Provider Directory Requester",
        "description" : "This [CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html) resource defines the expected capabilities \nof the [Health Connect Provider Directory Requester Actor](ActorDefinition-requester-actor-health-connect.html) when conforming to this implementation guide. The complete \nlist of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Provider Directory Requester Actor are defined in this CapabilityStatement. \nThe requirements of the Health Connect Provider Directory Requester actor may also be impacted by the rules of local jurisdictions or other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/requester-actor-health-connect"
        },
        "name" : "Health Connect Provider Directory Requester Actor",
        "description" : "The Health Connect Provider Directory Requester actor represents a system that is requesting **Health Connect Provider Directory details** for a particular provider or resource from the\nHealth Connect Provider Directory system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/health-connect-provider-directory-responder"
        },
        "name" : "Health Connect Provider Directory Responder",
        "description" : "This CapabilityStatement resource defines the expected capabilities of the [Health Connect Provider Directory Responder Actor](ActorDefinition-responder-actor-health-connect.html) when conforming to this implementation guide. The listed FHIR profiles, RESTful operations, and search parameters describe only those capabilities exposed for responding to Requester Actor requests. The Health Connect Provider Directory Responder supports additional internal and publishing operations that are not shown here; these are out of scope for this IG and are documented separately for publishing systems. The requirements of the Health Connect Provider Directory Responder may also be impacted by the rules of local jurisdictions or other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/responder-actor-health-connect"
        },
        "name" : "Health Connect Provider Directory Responder Actor",
        "description" : "The Health Connect Provider Directory Responder actor represents the system that provides **Health Connect Provider Directory details**. It accepts requests for Directory information about practitioners or services and returns the requested information, or an error message if the request cannot be fulfilled.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/healthcareservice-billing"
        },
        "name" : "HealthcareService Billing Search Parameter",
        "description" : "Search for HealthcareService resources by billing information.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/iar-levels-of-care"
        },
        "name" : "IAR Levels of Care",
        "description" : "Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service.\n\nContext of Use: HealthcareService\n\nCodes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/iar-levels-of-care"
        },
        "name" : "IAR Levels of Care CodeSystem",
        "description" : "The Health Connect IAR Levels of care code system defines concepts for the levels of care that the service provides, as defined by the National Initial Assessment and Referral (IAR) for Mental Healthcare Guidance (IAR Guidance).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/iar-levels-of-care-vs"
        },
        "name" : "IAR Levels of Care ValueSet",
        "description" : "All codes from the IAR Levels of Care CodeSystem are for use in the context of the iar-levels-of-care extension.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/languages"
        },
        "name" : "Languages Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by supported languages/communication methods. Shared across HealthcareService and PractitionerRole.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/location-amenities"
        },
        "name" : "Location Amenities Search Parameter",
        "description" : "Search for Location resources by amenities.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/location-physicaltype"
        },
        "name" : "Location Physical Type Search Parameter",
        "description" : "Search for Location resources by physicalType field.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/location-locmailaddress"
        },
        "name" : "Location Postal Address Search Parameter",
        "description" : "Search for Location resources by postal address components.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-identifier-r5"
        },
        "name" : "Practitioner identifier (R5 mimic)",
        "description" : "Enables R5-style identifier searching across both Practitioner.identifier and Practitioner.qualification.identifier paths. This allows searching for practitioners by any identifier type including HPI-I, Ahpra and other peak body registration numbers. Works with `system|value` OR `system` OR `value`.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-rsg"
        },
        "name" : "Practitioner's Recorded Sex or Gender Search Parameter",
        "description" : "Search a Practitioner record by their recorded sex or gender. This search parameter operates on the 'value' element of the individual-recordedSexOrGender extension (typically an administrative gender code). However, to fully understand the meaning and context of the recorded sex or gender, the complete extension structure returned in results should be examined, including metadata elements such as 'type' (category of what's recorded), 'source', 'sourceDocument', 'effectivePeriod', and other contextual information.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-regprof"
        },
        "name" : "Practitioner's Registered Profession Search Parameter",
        "description" : "Search a Practitioner record by their registered profession using string values.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitionerrole-roletype"
        },
        "name" : "Practitioner's Role Type Search Parameter",
        "description" : "Search a PractitionerRole record by their role type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/starttime"
        },
        "name" : "Start Time Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by start time. Query values must use a four-digit numeric 24 hr time format (HHMM, e.g., 0830 for 8:30am). The start time is converted to an integer to enable prefix-based time searches (e.g., gt, lt, ge, le).",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "guidance.html"
            }
          ],
          "nameUrl" : "guidance.html",
          "title" : "Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "FHIR Artefacts",
          "generation" : "html",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "profiles-and-extensions.html"
                }
              ],
              "nameUrl" : "profiles-and-extensions.html",
              "title" : "Profiles and Extensions",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "terminology.html"
                }
              ],
              "nameUrl" : "terminology.html",
              "title" : "Terminology",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "capability-statements.html"
                }
              ],
              "nameUrl" : "capability-statements.html",
              "title" : "Capability Statements",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "search-parameters.html"
                }
              ],
              "nameUrl" : "search-parameters.html",
              "title" : "Search Parameters",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "actors.html"
                }
              ],
              "nameUrl" : "actors.html",
              "title" : "Actor Definitions",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "conformance.html"
            }
          ],
          "nameUrl" : "conformance.html",
          "title" : "Conformance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "disclaimers.html"
            }
          ],
          "nameUrl" : "disclaimers.html",
          "title" : "Disclaimers",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changelog.html"
            }
          ],
          "nameUrl" : "changelog.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "input/pagecontent"
      },
      {
        "code" : "path-pages",
        "value" : "input/intro-notes"
      },
      {
        "code" : "path-pages",
        "value" : "fsh-generated/includes"
      },
      {
        "code" : "path-pages",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
