# Conformance - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Conformance**

## Conformance

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page records the conformance expectations for the Health Connect Provider Directory Implementation Guide as they apply to the [Health Connect Provider Directory Requester Actor](CapabilityStatement-health-connect-provider-directory-requester.md) (the client that performs searches and reads). It describes the minimum set of profiles, interactions and search parameters a searching system SHALL support to interact with the [Health Connect Provider Directory Responder Actor](CapabilityStatement-health-connect-provider-directory-responder.md).

### FHIR Conformance

Implementations SHALL at minimum be able to discover and read resources that conform to the HC profiles listed below. The searching system SHALL implement the REST interactions and search behaviours described in this document.

#### Profiles and interactions

In order to be conformant as a Health Connect Provider Directory Requester Actor the client searching system SHALL be able to, at a minimum interact with the following target profiles:

* [HC Organization](StructureDefinition-hc-organization.md) — organisation-level discovery and reads
* [HC Practitioner](StructureDefinition-hc-practitioner.md) — individual practitioner discovery and reads

For the profiles above, Health Connect Provider Directory Requester Actors SHOULD support discovery and retrieval operations (for example `search` and `read`). See the FHIR HTTP operations documentation ([FHIR HTTP operations](https://hl7.org/fhir/R4/http.html)) and the AU Core general requirements ([AU Core general requirements](https://hl7.org.au/fhir/core/2.0.0-ballot/general-requirements.html)) for full details. Health Connect Provider Directory Requester Actors SHOULD consult the target Server's `CapabilityStatement` to determine the exact set of supported interactions.

#### Search parameters and Terminology

Where a SearchParameter is of type token, the Health Connect Provider Directory Requester Actor SHOULD supply `system|code` or `system|value` using the code systems and value sets referenced by the IG. If a system is not available, then a value alone may be supplied. However, implementers must have in place mechanisms that clearly identify or mark matching values belonging to different systems. The published IG and the target server's `CapabilityStatement` should be consulted for the authoritative list of recommended SearchParameters and the expected token ValueSets. Although some value sets may be `preferred` rather than `required`, Requesters are strongly recommended to adopt those value sets where appropriate to maximise interoperability and minimise integration effort. The exception here, being the [ValueSet: hl7VS-degreeLicenseCertificate](https://hl7.org.au/fhir/6.0.0/ValueSet-au-v2-0360-extended.html) which is applied to `Practitioner.qualification.code`. This value set is not optimal for the intended use case but is used in lieu of an established alternative.

There are no SearchParameters within this IG that are marked with SHALL support and all are marked as SHOULD support. Implementers may implement SearchParameters as they see fit in accordance with their own use cases to interact with the Health Connect Provider Directory system.

#### Error handling

Health Connect Provider Directory Requesters SHALL correctly handle OperationOutcome responses and non-2xx HTTP responses returned by servers.

#### Conformance Testing

Conformance tests SHOULD verify that Requester implementations can:

* Perform `search` and `read` interactions against Organization and Practitioner profiles
* Handle multiple-result searches and pagination
* Respect server-declared search parameters and handle unsupported parameters gracefully
* Properly process OperationOutcome responses and error conditions

This document is intentionally narrow in scope for the Requester actor.

#### Missing data

It is an expectation that [Health Connect Provider Directory Requester Actor](CapabilityStatement-health-connect-provider-directory-requester.md) implementers SHALL be able to handle cases where missing data exists. Where mandatory elements are missing, this will be indicated by the established convention in FHIR, i.e. supplying the extension [`DataAbsentReason`](https://hl7.org/fhir/R4/extension-data-absent-reason.html).

#### Suppressed data

This IG does not define data-suppression; alternative mechanisms have been enacted to control access or redaction where appropriate.

### Software Conformance Profile

A risk-based Provider Directory conformance profile will be developed for connecting systems to mitigate the identified risks and describe desired software behaviours. The software developer must ensure their system behaves in accordance with the desired behaviours outlined in the conformance profile and associated artefacts.

#### Software Conformance Assessment

The conformance assessment approach and the associated test specification will be developed for connecting systems. The software developer must demonstrate conformance to the relevant Conformance Profile in addition to meeting the FHIR conformance requirements in section above.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

