# FHIR Artefacts - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **FHIR Artefacts**

## FHIR Artefacts

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [Health Connect Provider Directory Requester Actor](ActorDefinition-requester-actor-health-connect.md) | The Health Connect Provider Directory Requester actor represents a system that is requesting**Health Connect Provider Directory details**for a particular provider or resource from the Health Connect Provider Directory system. |
| [Health Connect Provider Directory Responder Actor](ActorDefinition-responder-actor-health-connect.md) | The Health Connect Provider Directory Responder actor represents the system that provides**Health Connect Provider Directory details**. It accepts requests for Directory information about practitioners or services and returns the requested information, or an error message if the request cannot be fulfilled. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Health Connect Provider Directory Requester](CapabilityStatement-health-connect-provider-directory-requester.md) | This[CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html)resource defines the expected capabilities of the[Health Connect Provider Directory Requester Actor](ActorDefinition-requester-actor-health-connect.md)when conforming to this implementation guide. The complete list of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Provider Directory Requester Actor are defined in this CapabilityStatement. The requirements of the Health Connect Provider Directory Requester actor may also be impacted by the rules of local jurisdictions or other contextual requirements. |
| [Health Connect Provider Directory Responder](CapabilityStatement-health-connect-provider-directory-responder.md) | This CapabilityStatement resource defines the expected capabilities of the[Health Connect Provider Directory Responder Actor](ActorDefinition-responder-actor-health-connect.md)when conforming to this implementation guide. The listed FHIR profiles, RESTful operations, and search parameters describe only those capabilities exposed for responding to Requester Actor requests. The Health Connect Provider Directory Responder supports additional internal and publishing operations that are not shown here; these are out of scope for this IG and are documented separately for publishing systems. The requirements of the Health Connect Provider Directory Responder may also be impacted by the rules of local jurisdictions or other contextual requirements. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [All Day Search Parameter](SearchParameter-allday.md) | Search HealthcareServices or PractitionerRoles by whether they are available all day. |
| [Days of Week Search Parameter](SearchParameter-daysofweek.md) | Search HealthcareServices or PractitionerRoles by days of week availability. Supports multiple days using OR logic. |
| [End Time Search Parameter](SearchParameter-endtime.md) | Search HealthcareServices or PractitionerRoles by end time. Query values must use a four-digit numeric 24 hr time format (HHMM, e.g., 0830 for 8:30am). The end time is converted to an integer to enable prefix-based time searches (e.g., gt, lt, ge, le). |
| [Endpoint Payload Mime Type Search Parameter](SearchParameter-endpoint-payloadmimetype.md) | Search for Endpoint resources by payloadMimeType. |
| [Endpoint URL Search Parameter](SearchParameter-endpoint-url.md) | Search for Endpoint resources by address (URL). |
| [HC Endpoint Identifier Search Parameter](SearchParameter-endpoint-hcepi.md) | Search an Endpoint record by its HC identifier. |
| [HealthcareService Billing Search Parameter](SearchParameter-healthcareservice-billing.md) | Search for HealthcareService resources by billing information. |
| [Languages Search Parameter](SearchParameter-languages.md) | Search HealthcareServices or PractitionerRoles by supported languages/communication methods. Shared across HealthcareService and PractitionerRole. |
| [Location Amenities Search Parameter](SearchParameter-location-amenities.md) | Search for Location resources by amenities. |
| [Location Physical Type Search Parameter](SearchParameter-location-physicaltype.md) | Search for Location resources by physicalType field. |
| [Location Postal Address Search Parameter](SearchParameter-location-locmailaddress.md) | Search for Location resources by postal address components. |
| [Practitioner identifier (R5 mimic)](SearchParameter-practitioner-identifier-r5.md) | Enables R5-style identifier searching across both Practitioner.identifier and Practitioner.qualification.identifier paths. This allows searching for practitioners by any identifier type including HPI-I, Ahpra and other peak body registration numbers. Works with`system|value`OR`system`OR`value`. |
| [Practitioner's Recorded Sex or Gender Search Parameter](SearchParameter-practitioner-rsg.md) | Search a Practitioner record by their recorded sex or gender. This search parameter operates on the 'value' element of the individual-recordedSexOrGender extension (typically an administrative gender code). However, to fully understand the meaning and context of the recorded sex or gender, the complete extension structure returned in results should be examined, including metadata elements such as 'type' (category of what's recorded), 'source', 'sourceDocument', 'effectivePeriod', and other contextual information. |
| [Practitioner's Registered Profession Search Parameter](SearchParameter-practitioner-regprof.md) | Search a Practitioner record by their registered profession using string values. |
| [Practitioner's Role Type Search Parameter](SearchParameter-practitionerrole-roletype.md) | Search a PractitionerRole record by their role type. |
| [Start Time Search Parameter](SearchParameter-starttime.md) | Search HealthcareServices or PractitionerRoles by start time. Query values must use a four-digit numeric 24 hr time format (HHMM, e.g., 0830 for 8:30am). The start time is converted to an integer to enable prefix-based time searches (e.g., gt, lt, ge, le). |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Endpoint](StructureDefinition-hc-endpoint.md) | This profile defines content for describing details of an endpoint. |
| [HC HealthcareService](StructureDefinition-hc-healthcareservice.md) | This profile of HealthcareService represents a particular type of health or health related service offered by a healthcare organisation at a particular location i.e. a practice, clinic, facility, or hospital. The authoritative source for healthcare services is the healthcare provider organisation that provides the service(s). |
| [HC Location](StructureDefinition-hc-location.md) | This profile defines a healthcare location (can also be referred as 'location') reflects the place, a site of care i.e. a practice, clinic, hospital, or facility at which healthcare services are provided by the healthcare organisation. The healthcare location can be a physical, mobile, or virtual location. In certain cases, a healthcare location can also represent a site of care within the hospital or building premises such as consulting room, operating room, outpatient room, unit, ward (e.g. maternity ward), department (e.g. emergency department) etc. |
| [HC Organization](StructureDefinition-hc-organization.md) | This profile defines a Provider Directory entry for an organisation. |
| [HC Practitioner](StructureDefinition-hc-practitioner.md) | This profile defines Healthcare Provider Individual details who is delivering health related services. |
| [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md) | This profile defines a practitioner in role for an organisation at a location providing a healthcare service. |
| [HC Provenance](StructureDefinition-hc-provenance.md) | This profile of Provenance is used to record an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record. |
| [HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md) | This profile of Location represents an Australian geographic coverage area i.e. postcodes where this service is provided. For a healthcare service, that is provided through a physical location but have eligibility restrictions applicable in terms of only residents for certain postcodes/suburbs can receive this service, then the details of coverage area and eligibility should be provided here. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Endpoint Identifier (HC-EPI)](StructureDefinition-hc-endpoint-identifier.md) | This identifier profile defines a unique identifier allocated to a healthcare endpoint, in a Health Connect Provider Directory context. |
| [HC Healthcare Provider Identifier - Organisation (HC HPI-O)](StructureDefinition-hc-hpio.md) | This identifier profile extends the AU HPI-O profile to include an organization classification extension to indicate whether the organization is a 'seed' or 'network' type. |
| [HC Healthcare Support Service Provider - Organisation (HC HSP-O)](StructureDefinition-hc-hspo.md) | This identifier profile defines a Healthcare Support Service Provider Organisation in an Australian context. An HSP-O is assigned under the HI Service to a service (in-home care support and personal care services) where healthcare is provided. A HSP-O can only be of 'seed' type. An Organization cannot be assigned both an HPI-O and an HSP-O; only one identifier is assigned by the HI Service. |
| [HC PCA Healthcare Service Identifier (PCA-HSI)](StructureDefinition-pca-hsi.md) | Identifier for a healthcare service as allocated by PCA. |
| [HC Peak Body Professional Registration Number (HC-PBPRN)](StructureDefinition-hc-pbprn.md) | This identifier profile defines a professional registration number allocated to a healthcare practitioner, in a Health Connect Provider Directory context. |
| [HC SMD Target Identifier (HC-SMDTI)](StructureDefinition-hc-smd-target-identifier.md) | This identifier profile defines a SMD target identifier allocated to a healthcare practitioner, in a Health Connect Provider Directory context. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Accept New Patient](StructureDefinition-hc-accept-new-patient.md) | Indicates whether the healthcare service is accepting new patients. Patterned after PCA New Patient Availability extension.Context of Use: HealthcareService |
| [HC Active Period](StructureDefinition-hc-active-period.md) | The period during which the HealthcareService is considered active in the Health Connect Provider Directory Responder. Patterned after PCA Active Period. |
| [HC Amenity](StructureDefinition-hc-amenity.md) | Physical features or amenities available within, or in close proximity of, a location. Uses the NCTS Facility Amenity ValueSet. |
| [HC Organization Classification](StructureDefinition-hc-org-classification.md) | Extension to record whether an organisation's HPIO is a 'seed' or 'network' type in the HI service. |
| [HC Practitioner Role Communication](StructureDefinition-hc-practitioner-role-communication.md) | Health Connect Practitioner Role Communication. This extension captures communication preferences and capabilities for a practitioner in a given role. |
| [HC Preferred Name](StructureDefinition-hc-preferred-name.md) | This extension applies to PractitionerRole, and represents a name by which a practitioner chooses to be known in the context of the delivery of a specific healthcare service. |
| [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md) | Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address. |
| [HC Referral Information for Referrer](StructureDefinition-hc-referral-information-for-referrer.md) | Referral instructions and information for healthcare service providers that may wish to refer patients / clients to the healthcare service. Modelled after PCA but for Health Connect context. |
| [IAR Levels of Care](StructureDefinition-iar-levels-of-care.md) | Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service.Context of Use: HealthcareServiceCodes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Australian Endpoint Payload Types](ValueSet-hc-endpoint-payload-type-vs.md) | The Australian Endpoint Payload Types value set enumerates well known endpoint payload types. |
| [HC Australian Service Interfaces](ValueSet-hc-service-interfaces-vs.md) | The Health Connect Australian Service Interfaces value set enumerates well known service interfaces that can be used for specifying a connection type. |
| [HC Gender Identity ValueSet](ValueSet-HCGenderIdentityVs.md) | A value set of gender identities recognised by Health Connect. |
| [HC Organization Classification ValueSet](ValueSet-hc-org-classification-vs.md) | The Health Connect ValueSet referencing the HC Organization Classification CodeSystem (seed, network). |
| [HC Service Provision Code](ValueSet-hc-service-provision-code-vs.md) | The HC Service Provision Code value set includes values that may be used to identify the service provision condition of a healthcare service in HC. |
| [IAR Levels of Care ValueSet](ValueSet-iar-levels-of-care-vs.md) | All codes from the IAR Levels of Care CodeSystem are for use in the context of the iar-levels-of-care extension. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md) | The Endpoint Payload Types code system defines concepts that identify well known endpoint payload types. |
| [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md) | The Australian Secure Message Service Interfaces code system defines concepts that identify service interfaces for secure message delivery. |
| [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md) | Internal code system that describes whether an organisation is a 'seed' or 'network' type used by Health Connect. |
| [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md) | The HC Service Provision Code code system defines a concept (in addition to those defined in[Service Provision Conditions Australian Concepts](https://hl7.org.au/fhir/4.1.0/CodeSystem-service-provision-conditions.html)that may be used to identify the service provision condition of a healthcare service in HC. |
| [IAR Levels of Care CodeSystem](CodeSystem-iar-levels-of-care.md) | The Health Connect IAR Levels of care code system defines concepts for the levels of care that the service provides, as defined by the National Initial Assessment and Referral (IAR) for Mental Healthcare Guidance (IAR Guidance). |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [HC Endpoint Example: SMD Target](Endpoint-example-hc-endpoint-smd.md) | An example Endpoint with an SMD target identifier for secure messaging conforming to the HC Endpoint profile. |
| [HC HealthcareService Example: Residential Aged Care](HealthcareService-example-healthconnect-healthcareservice-1.md) | A Residential Aged Care HealthcareService example conforming to the HC HealthcareService profile. |
| [HC Location Example: Medical Centre (Physical Building)](Location-example-healthconnect-medical-centre-location-1.md) | A physical medical centre location example with wheelchair access, conforming to the HC Location profile. |
| [HC Location Example: Mobile Healthcare Unit](Location-example-healthconnect-mobile-healthcare-unit-1.md) | A mobile healthcare unit location example with wheelchair access, conforming to the HC Location profile. |
| [HC Location Example: Mobile Unit Service Coverage Area](Location-example-healthconnect-mobile-unit-coverage-area-1.md) | A virtual coverage area defining the geographical service boundary for the mobile healthcare unit. |
| [HC Location Example: Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md) | A virtual telehealth service location example without physical address, conforming to the HC Location profile. |
| [HC Organization Example: Aged Care Facility](Organization-example-healthconnect-organization-1.md) | An Aged Care Facility example conforming to the HC Organization profile. |
| [HC Organization Example: Home Care Support Service](Organization-example-healthconnect-organization-2.md) | A Home Care Support Service example conforming to the HC Organization profile with HSP-O identifier. |
| [HC Practitioner Example: Alex Smith](Practitioner-example-healthconnect-practitioner-1.md) | An example Practitioner (Alex Smith) conforming to the HC Practitioner profile. |
| [HC Practitioner Example: External Record (PRN)](Practitioner-external-hc-practitioner-record.md) | An external practitioner record example (PRN identifier) conforming to the HC Practitioner profile. |
| [HC PractitionerRole Example: Medicare Provider](PractitionerRole-example-healthconnect-practitionerrole-1.md) | An example PractitionerRole (Medicare) that conforms to the HC PractitionerRole profile. |
| [HC Provenance Example: Practitioner Name Amendment](Provenance-provenance-practitioner-name-update.md) | Demonstrates provenance tracking for a practitioner's name amendment, conforming to the HC Provenance profile. |
| [HC Provenance Example: Practitioner Phone Amendment](Provenance-provenance-practitioner-phone-update.md) | Demonstrates provenance tracking for a practitioner's phone number amendment, conforming to the HC Provenance profile. |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

