No data is entered directly into Health Connect; all Directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### Extensions
Extensions introduced in this profile:
* Location: [HC Amenity](StructureDefinition-hc-amenity.html)
* Location: [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.html)

### Usage notes
* The [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.html) extension is used to carry a separate address that is different to the registered address for the location. 

Publishing guidance:

A HC Location resource may also have additional identifiers specific to other business partners, and their identifier systems may or may not match other identifier slices defined in [AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html).

#### Type
The usage notes of the AU Base Location profile provide guidance for Locations that may form part of defining a mobile or remotely delivered service. The HC Location profile formalises this guidance as mandatory requirements (via invariants). The requirements are summarised below:

A HC Location for a mobile service **shall** have:
* type=’MOBL’ plus at least one of the following codes: 'PTRES', 'SCHOOL', 'WORK', 'COMM' or 'AMB', to further qualify where the mobile service is offered. 

A HC Location for a virtually delivered service **shall** have:

* type=’VI’

##### PhysicalType
When a Location is to be represented as a physical type, the `physicalType` element is used to carry an applicable code from the [Location Type (Physical) - AU Extended ValueSet](https://hl7.org.au/fhir/6.0.0/ValueSet-au-location-physical-type-extended.html). 

The `physicalType` element can be used to express more specific details about the physical nature of a Location (for example: ward, building, dwelling). 

#### Organization reference
The *managingOrganization* element must contain a relative reference to an existing [HC Organization](StructureDefinition-hc-organization.html).

#### Invariants

##### Invariant: preferred-postal-address
Description: If the preferred postal address extension is present on an address then that address must be of type 'postal'.

Implementation note: The profile enforces this rule so that the `hc-preferred-postal-address` extension is only used to carry postal/mailing addresses (for example PO Boxes). Publishing systems SHOULD only set the extension on addresses whose `type` is `postal`.

##### Invariant: inv-01-address-requirement
Description: If a location's `type` is `VI` or `MOBL` then an address does not need to be present. For all other location types an `address` MUST be present.

Implementation note: This invariant ensures that physical locations provide a postal/physical address, while virtual or mobile services (for example telehealth, mobile clinics, ambulance services) may omit a fixed address.

##### Invariant: inv-02-type-mobl-requires-modifier
Description: If a location's `type` includes the `MOBL` code then it is recommended that an additional modifier coding is provided to describe the mobile service (either `PTRES`, `SCHOOL`, `WORK`, `COMM`, `AMB`) but not `VI`.

Implementation note: This rule is a *warning* - it does not block publishing but encourages publishers to provide additional context about where the mobile service operates. Implementers should supply a secondary `type.coding` entry when describing mobile services to improve discoverability.

##### Invariant: inv-03-type-vi-should-not-have-modifier
Description: If a location's `type` includes the `VI` code then no additional modifier codings should be present.

Implementation note: This rule is a *warning* - virtual locations should be clearly identified as virtual-only and not include additional modifiers that suggest physical or mobile subtypes. If a virtual service also has a physical component, model those as separate Location resources.

##### Invariant: inv-04-type-or-physicaltype-present
Description: A Location resource MUST include either a `type` or a `physicalType` element.

Implementation note: This rule is enforced as an error - every Location must be classified either by `type` (logical role such as `MOBL`, `VI`, etc.) or by `physicalType` (when the Location represents a specific physical characteristic). Implementers MUST populate at least one of these elements when creating Location resources.

