# HC Endpoint - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC Endpoint**

## Resource Profile: HC Endpoint 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint | *Version*:0.2.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCEndpoint |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This profile defines content for describing details of an endpoint. 

No data is entered directly into Health Connect; all Directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

#### Extensions

Extensions introduced in this profile:

* Endpoint: [AU Receiving Facility](http://hl7.org.au/fhir/StructureDefinition/au-receivingfacility)
* Endpoint: [AU Receiving Application](http://hl7.org.au/fhir/StructureDefinition/au-receivingapplication)
* Endpoint: [Encryption Certificate PEM X509](http://hl7.org.au/fhir/StructureDefinition/encryption-certificate-pem-x509)

### Usage notes

The following guidance expands on operational and implementation expectations for this Endpoint profile.

* Purpose: An `Endpoint` in Health Connect describes how to communicate with a service (address, protocol, payloads and contact details). Directory consumers use this information to establish connections, and operational tooling uses it to monitor and validate connectivity.

#### Implementation requirements vs. processing

Implementers SHALL process all elements marked as Must Support (MS) in this profile to be conformant. However, certain elements that are mandatory do not need to be processed by Health Connect Provider Directory Requester Actors:

* **Endpoint.status**: This element is not MUST SUPPORT but is mandatory therefore it MAY be ignored by implementing systems. A value will be provided but MAY be ignored.

#### Initial endpoint scope and future expansion

Health Connect initially expects published `Endpoint` resources to describe Secure Messaging endpoints (SMD-capable targets and related secure messaging transports). Requesters and search clients should expect SMD-specific metadata and prioritise handling SMD attributes (SMD Target Identifier, encryption certificate, and routing identifiers). Over time, clients may be able to handle additional protocol metadata (for example, FHIR REST endpoint details) as publishers begin to expose FHIR and other transport types.

#### Identifiers and stable handles

The Endpoint profile uses two stable identifier slices for Directory management and routing:

* [HC Endpoint Identifier (HC-EPI)](StructureDefinition-hc-endpoint-identifier.md) - a externally-assigned endpoint identifier. Publishers SHOULD set this identifier on creation and thereafter treat it as immutable. The identifier SHALL be globally unique within HealthConnect and SHALL NOT be re‑assigned. Client systems SHOULD prefer this identifier for reconciliation and updates rather than attempting to infer identity from other attributes.
* [HC SMD Target Identifier](StructureDefinition-hc-smd-target-identifier.md) - a slice used only when the endpoint (or associated practitioner/service) supports Secure Messaging Delivery (SMD). When present the SMD identifier SHALL be globally unique and SHALL be treated as an immutable routing handle for secure point‑to‑point or hub‑mediated messaging. Publishers SHOULD only populate this slice for endpoints that actually support SMD.

### Reciprocal relationships

In FHIR, linkage to resources is owned by the referencing resources (`HealthcareService.endpoint`, `PractitionerRole.endpoint`, `Location.endpoint`). The Endpoint resource itself has no back‑reference slots to those resources. Consequently:

* Reciprocity cannot be enforced within the Endpoint profile (there is no standard element on Endpoint to list referencing HealthcareService / Location / PractitionerRole resources).
* Directory governance MUST ensure that when a referencing resource adds or removes an Endpoint, any operational expectations (availability, deprecation, auditing) are handled in process.

**Usages:**

* Refer to this Profile: [HC HealthcareService](StructureDefinition-hc-healthcareservice.md), [HC Location](StructureDefinition-hc-location.md), [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md) and [HC Provenance](StructureDefinition-hc-provenance.md)
* Examples for this Profile: [Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* CapabilityStatements using this Profile: [Health Connect Provider Directory Requester](CapabilityStatement-health-connect-provider-directory-requester.md) and [Health Connect Provider Directory Responder](CapabilityStatement-health-connect-provider-directory-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-endpoint)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-endpoint.csv), [Excel](StructureDefinition-hc-endpoint.xlsx), [Schematron](StructureDefinition-hc-endpoint.sch) 

### Notes:

### Search parameters

This IG defines and introduces several search parameters in addition to those inherited from R4, that make it easier to find and filter `HC Endpoint` resources in Health Connect implementations.

#### Search parameters defined in this IG

The following search parameters are **defined by this IG** and **SHOULD** be supported:

* [`hcepi`](SearchParameter-endpoint-hcepi.md) (Endpoint.identifier where type = Resource Identifier)
* Find endpoint records by the HC identifier assigned in Health Connect. Uses token matching for exact value matching.
* Example: `GET /Endpoint?hcepi=EP001234567890`
* [`payloadmimetype`](SearchParameter-endpoint-payloadmimetype.md) (Endpoint.payloadMimeType)
* Search for endpoints that advertise support for a specific MIME type for payloads.
* Typical values present in this IG's example data are: 
* `application/pdf`
* `application/fhir+xml`
* `application/fhir+json`
 
* Example: `GET /Endpoint?payloadmimetype=application%2Ffhir%2Bjson`
* [`epurl`](SearchParameter-endpoint-url.md) (alias used in this IG for Endpoint.address)
* Convenience alias used in this IG's documentation to search by endpoint address.
* Example: `GET /Endpoint?epurl=https://smd.sydneyhospital.org.au/secure-messaging/endpoint`

#### Search parameters from R4

The following search parameters are **inherited from FHIR R4** and have been deemed useful for implementation within this IG. They **SHOULD** be supported:

* [`name (R4)`](https://hl7.org/fhir/R4/SearchParameter-registry.html#name) (Endpoint.name)
* Search for endpoints by name (partial matches may be supported).
* Example: `GET /Endpoint?name=My%20GP%20Service`
* [`connection-type (R4)`](https://hl7.org/fhir/R4/SearchParameter-registry.html#connection-type) (Endpoint.connectionType)
* Search for endpoints by connection type (for example, `hl7-fhir-rest` or other interface codes).
* Example: `GET /Endpoint?connection-type=http://terminology.hl7.org.au/CodeSystem/endpoint-connection-type|secure-messaging`
* [`payload-type (R4)`](https://hl7.org/fhir/R4/SearchParameter-registry.html#payload-type) (Endpoint.payloadType)
* Search for endpoints by payload type (CodeableConcept). Use [HC Endpoint payload type ValueSet codes](CodeSystem-hc-endpoint-payload-type-cs.md) where applicable.
* Example: `GET /Endpoint?payload-type=http://ns.electronichealth.net.au/hc/CodeSystem/hc-endpoint-payload-type-cs|some-payload`

**Note:** Support for _id is mandatory for a responder and optional for a requester. Where the expectation for a search parameter differs between actors, the table below will reflect the stronger conformance requirement.

* Parameter(s): _id
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): hcepi
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): name (R4)
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): connection-type (R4)
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): payload-type (R4)
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): epurl
  * Conformance: **SHOULD**
  * Type(s): `uri`
  * Requirements (when used alone or in combination): 
* Parameter(s): payloadmimetype
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): name+connection-type
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): name+payload-type
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): connection-type+payloadmimetype
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 

### Search reverse include parameters

This implementation supports the following `_revinclude` parameters when searching for Endpoint resources:

* `_revinclude=HealthcareService:endpoint` - Include HealthcareService resources that reference this Endpoint
* `_revinclude=Location:endpoint` - Include Location resources that reference this Endpoint
* `_revinclude=PractitionerRole:endpoint` - Include PractitionerRole resources that reference this Endpoint
* `_revinclude=Provenance:target` - Include Provenance resources that track changes to this Endpoint

#### Example usage

```
GET /Endpoint/303?_revinclude=HealthcareService:endpoint&_revinclude=Location:endpoint

```

This query returns the Endpoint resource along with all HealthcareServices and Locations that use this Endpoint.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-endpoint",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint",
  "version" : "0.2.0-preview",
  "name" : "HCEndpoint",
  "title" : "HC Endpoint",
  "status" : "draft",
  "date" : "2026-01-20T04:27:33+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile defines content for describing details of an endpoint.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Endpoint",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Endpoint|4.0.1",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Endpoint",
        "path" : "Endpoint",
        "short" : "Health Connect Endpoint",
        "definition" : "Endpoint defined for use in Health Connect."
      },
      {
        "id" : "Endpoint.extension",
        "path" : "Endpoint.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Endpoint.extension:receivingFacility",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.extension",
        "sliceName" : "receivingFacility",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-receivingfacility|6.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.extension:receivingApplication",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.extension",
        "sliceName" : "receivingApplication",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-receivingapplication|6.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.extension:dataEnciphermentCertificate",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.extension",
        "sliceName" : "dataEnciphermentCertificate",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/encryption-certificate-pem-x509|6.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            },
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "Unique identifier of the endpoint record",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.identifier:HCSMDTargetIdentifier",
        "path" : "Endpoint.identifier",
        "sliceName" : "HCSMDTargetIdentifier",
        "short" : "SMD Target Identifier",
        "definition" : "Secure Messaging Delivery target identifier for this endpoint",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-smd-target-identifier|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.identifier:HCEndpointIdentifier",
        "path" : "Endpoint.identifier",
        "sliceName" : "HCEndpointIdentifier",
        "short" : "HC Endpoint Identifier attributed from source system",
        "definition" : "Unique identifier for the healthcare endpoint attributed from source system. Not a displayable field but can be used for system reference or internal business logic.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint-identifier|0.2.0-preview"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.connectionType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.connectionType",
        "short" : "To specify the service interface types",
        "definition" : "Protocol/Profile/Standard the endpoint supports.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-service-interfaces-vs|0.2.0-preview"
        }
      },
      {
        "id" : "Endpoint.name",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.name",
        "short" : "To enable consistent and correct identification of the endpoint",
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.payloadType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.payloadType",
        "short" : "Endpoint payload type",
        "definition" : "REndpoint payload types that need to be transmitted over secure messaging, e.g. Discharge Summary, e-Referral, referral response message, acknowledgment etc.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-endpoint-payload-type-vs|0.2.0-preview"
        }
      },
      {
        "id" : "Endpoint.payloadMimeType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.payloadMimeType",
        "mustSupport" : true
      },
      {
        "id" : "Endpoint.address",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHOULD:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://ns.electronichealth.net.au/hc/ActorDefinition/requester-actor-health-connect|0.2.0-preview"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Endpoint.address",
        "short" : "URL address of the endpoint",
        "mustSupport" : true
      }
    ]
  }
}

```
