# HC Practitioner Example: Alex Smith - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC Practitioner Example: Alex Smith**

## Example Practitioner: HC Practitioner Example: Alex Smith

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-08-25 14:30:00+1000

Profile: [HC Practitioner](StructureDefinition-hc-practitioner.md)

> **Person Recorded Sex Or Gender**
* value: Female

> **Individual Gender Identity**
* value: Identifies as female gender

**identifier**: National provider identifier/8003619900015717

**name**: Alex Smith (Official), Alex Smith 

**telecom**: [+61412345678](tel:+61412345678), [alex.smith@example.com](mailto:alex.smith@example.com)

### Qualifications

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Identifier** | **Code** | **Issuer** |
| * | Australian Health Practitioner Regulation Agency Registration Number/MED0000932945 | Medical Practitioner | Ahpra |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "example-healthconnect-practitioner-1",
  "meta" : {
    "lastUpdated" : "2025-08-25T14:30:00+10:00",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/administrative-gender",
                "code" : "female",
                "display" : "Female"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "446141000124107",
                "display" : "Identifies as female gender"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NPI"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpii/1.0",
      "value" : "8003619900015717"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Smith",
      "given" : ["Alex"],
      "prefix" : ["Dr"]
    },
    {
      "use" : "usual",
      "family" : "Smith",
      "given" : ["Alex"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+61412345678",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "alex.smith@example.com",
      "use" : "home"
    }
  ],
  "qualification" : [
    {
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
                "code" : "AHPRA"
              }
            ]
          },
          "system" : "http://hl7.org.au/id/ahpra-registration-number",
          "value" : "MED0000932945"
        }
      ],
      "code" : {
        "text" : "Medical Practitioner"
      },
      "issuer" : {
        "display" : "Ahpra"
      }
    }
  ]
}

```
