# HC Location Example: Mobile Healthcare Unit - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **HC Location Example: Mobile Healthcare Unit**

## Example Location: HC Location Example: Mobile Healthcare Unit

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-09-01 14:45:30+0000

Profile: [HC Location](StructureDefinition-hc-location.md)

**HC Preferred Postal Address**: PO Box 123, SYDNEY NSW 2000(work)

**HC Amenity**: Wheelchair Access

**identifier**: NATA Site Number/162899, LSPN/123333

**name**: Mobile Healthcare Unit - Sydney CBD

**alias**: CBD Mobile Unit

**type**: Mobile Unit, Community Location

**telecom**: ph: (02) 1234 5678(Work), [info@sydneycentralmc.com.au](mailto:info@sydneycentralmc.com.au), [https://www.sydneycentralmc.com.au](https://www.sydneycentralmc.com.au), fax: +61 2 9999 8888(Work)

**address**: Shop 8, 151 Castlereagh Street, SYDNEY NSW 2000

### Positions

| | | |
| :--- | :--- | :--- |
| - | **Longitude** | **Latitude** |
| * | 151.2093 | -33.8688 |

**managingOrganization**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "example-healthconnect-mobile-healthcare-unit-1",
  "meta" : {
    "lastUpdated" : "2025-09-01T14:45:30Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
    ]
  },
  "extension" : [
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-postal-address",
      "valueAddress" : {
        "use" : "work",
        "type" : "postal",
        "text" : "PO Box 123, SYDNEY NSW 2000",
        "line" : ["PO Box 123"],
        "city" : "SYDNEY",
        "state" : "NSW",
        "postalCode" : "2000",
        "country" : "AU"
      }
    },
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-amenity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/facility-amenity-1",
            "code" : "wheelchairAccess",
            "display" : "Wheelchair Access"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NATAS",
            "display" : "NATA Site Number"
          }
        ],
        "text" : "NATA Site Number"
      },
      "system" : "http://hl7.org.au/id/nata-site",
      "value" : "162899"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "LSPN",
            "display" : "Location Specific Practice Number"
          }
        ],
        "text" : "LSPN"
      },
      "system" : "http://ns.electronichealth.net.au/id/location-specific-practice-number",
      "value" : "123333"
    }
  ],
  "name" : "Mobile Healthcare Unit - Sydney CBD",
  "alias" : ["CBD Mobile Unit"],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "MOBL",
          "display" : "Mobile Unit"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "COMM",
          "display" : "Community Location"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(02) 1234 5678",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@sydneycentralmc.com.au",
      "use" : "work"
    },
    {
      "system" : "url",
      "value" : "https://www.sydneycentralmc.com.au",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "+61 2 9999 8888",
      "use" : "work"
    }
  ],
  "address" : {
    "extension" : [
      {
        "url" : "http://hl7.org.au/fhir/StructureDefinition/address-identifier",
        "valueIdentifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
                "code" : "GNAF",
                "display" : "Geocoded National Address File Identifier"
              }
            ],
            "text" : "G-NAF"
          },
          "system" : "http://hl7.org.au/id/gnafidentifier",
          "value" : "GANSW718473771"
        }
      }
    ],
    "type" : "physical",
    "text" : "Shop 8, 151 Castlereagh Street, SYDNEY NSW 2000",
    "line" : ["Shop 8", "147-153 Castlereagh Street"],
    "city" : "SYDNEY",
    "state" : "NSW",
    "postalCode" : "2000",
    "country" : "AU"
  },
  "position" : {
    "longitude" : 151.2093,
    "latitude" : -33.8688
  },
  "managingOrganization" : {
    "reference" : "Organization/example-healthconnect-organization-1"
  }
}

```
