# Health Connect Provider Directory Responder - Health Connect Australia Provider Directory FHIR Implementation Guide v0.2.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.2.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](artifacts.md)
* **Health Connect Provider Directory Responder**

## CapabilityStatement: Health Connect Provider Directory Responder 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-provider-directory-responder | *Version*:0.2.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectProviderDirectoryResponder |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This CapabilityStatement resource defines the expected capabilities of the[Health Connect Provider Directory Responder Actor](ActorDefinition-responder-actor-health-connect.md)when conforming to this implementation guide. The listed FHIR profiles, RESTful operations, and search parameters describe only those capabilities exposed for responding to Requester Actor requests. The Health Connect Provider Directory Responder supports additional internal and publishing operations that are not shown here; these are out of scope for this IG and are documented separately for publishing systems. The requirements of the Health Connect Provider Directory Responder may also be impacted by the rules of local jurisdictions or other contextual requirements. 

 [Raw OpenAPI-Swagger Definition file](health-connect-provider-directory-responder.openapi.json) | [Download](health-connect-provider-directory-responder.openapi.json) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](https://www.digitalhealth.gov.au/). Package au.digitalhealth.r4.healthconnect#0.2.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2026-01-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "health-connect-provider-directory-responder",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-provider-directory-responder",
  "version" : "0.2.0-preview",
  "name" : "HealthConnectProviderDirectoryResponder",
  "title" : "Health Connect Provider Directory Responder",
  "status" : "draft",
  "date" : "2025-11-27",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.digitalhealth.gov.au/"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement resource defines the expected capabilities of the [Health Connect Provider Directory Responder Actor](ActorDefinition-responder-actor-health-connect.html) when conforming to this implementation guide. The listed FHIR profiles, RESTful operations, and search parameters describe only those capabilities exposed for responding to Requester Actor requests. The Health Connect Provider Directory Responder supports additional internal and publishing operations that are not shown here; these are out of scope for this IG and are documented separately for publishing systems. The requirements of the Health Connect Provider Directory Responder may also be impacted by the rules of local jurisdictions or other contextual requirements.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "kind" : "instance",
  "implementation" : {
    "description" : "Health Connect Provider Directory Responder FHIR Server",
    "url" : "http://ns.electronichealth.net.au/hc"
  },
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "server",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "OAuth",
                "display" : "OAuth"
              }
            ]
          }
        ],
        "description" : "All interactions SHALL be secured using OAuth protocols. It SHALL support authentication, authorisation, and audit logging in accordance with local policy and regulatory requirements."
      },
      "resource" : [
        {
          "type" : "Provenance",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "HC Provenance resources track the lineage of data retrieved, updated, or verified from external systems of record.",
          "interaction" : [
            {
              "code" : "read",
              "documentation" : "Read HC Provenance records"
            },
            {
              "code" : "search-type",
              "documentation" : "Search HC Provenance records by various parameters"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchInclude" : ["Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "target",
              "definition" : "http://hl7.org/fhir/SearchParameter/Provenance-target|4.0.1",
              "type" : "reference"
            }
          ]
        },
        {
          "type" : "Organization",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section defines the supported interactions for the [HC Organization](StructureDefinition-hc-organization.html) profile of the Organization resource type.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchInclude" : ["Organization:partOf"],
          "searchRevInclude" : ["Location:organization", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-identifier|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-type|4.0.1",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Location",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section describes the supported interactions for the [HC Location](StructureDefinition-hc-location.html) profile. Each Location resource conforming to this profile identifies a physical or virtual place associated with healthcare services in the Health Connect Provider Directory, enabling clients to discover, filter, and reference service delivery sites.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchInclude" : ["Location:managingOrganization", "Location:endpoint"],
          "searchRevInclude" : ["HealthcareService:location", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "locmailaddress",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-locmailaddress|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "locationamenities",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-amenities|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "address",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-address|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-type|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "locationphysicaltype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-physicaltype|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "near",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-near|4.0.1",
              "type" : "special"
            }
          ]
        },
        {
          "type" : "HealthcareService",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section describes the supported interactions for the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.html) profile. Each HealthcareService resource conforming to this profile identifies a healthcare service in the Health Connect Provider Directory, enabling clients to discover, filter, and reference healthcare services that are provided.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchInclude" : [
            "HealthcareService:location",
            "HealthcareService:providedBy",
            "HealthcareService:endpoint"
          ],
          "searchRevInclude" : ["PractitionerRole:healthcareService", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "languages",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/languages|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "hsbilling",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/healthcareservice-billing|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "allday",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/allday|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "daysofweek",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/daysofweek|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "starttime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/starttime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "endtime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endtime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "service-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/HealthcareService-service-type|4.0.1",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section defines the supported interactions for the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile of the PractitionerRole resource type. Each PractitionerRole resource conforming to the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile describes a practitioner in a role at a healthcare service.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchInclude" : [
            "PractitionerRole:practitioner",
            "PractitionerRole:healthcareService",
            "PractitionerRole:organization",
            "PractitionerRole:location",
            "PractitionerRole:endpoint"
          ],
          "searchRevInclude" : ["Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "languages",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/languages|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "allday",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/allday|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "daysofweek",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/daysofweek|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "starttime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/starttime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "endtime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endtime|0.2.0-preview",
              "type" : "number"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "roletype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitionerrole-roletype|0.2.0-preview",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section describes the supported interactions for the [HC Practitioner](StructureDefinition-hc-practitioner.html) profile. Each Practitioner resource conforming to this profile represents an individual healthcare provider registered in the Health Connect Provider Directory, enabling clients to search, identify, and reference practitioners and their associated roles and service locations.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchRevInclude" : ["PractitionerRole:practitioner", "Provenance:target"],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-identifier|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "regprof",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-regprof|0.2.0-preview",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "rsg",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-rsg|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "genderIdentity",
              "definition" : "http://hl7.org.au/fhir/SearchParameter/gender-identity|6.0.0",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "identifier-r5",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-identifier-r5|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-name|4.0.1",
              "type" : "string"
            }
          ]
        },
        {
          "type" : "Endpoint",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint|0.2.0-preview",
          "_profile" : {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                "valueCode" : "SHALL"
              }
            ]
          },
          "documentation" : "This section describes the supported interactions for the [HC Endpoint](StructureDefinition-hc-endpoint.html) profile. Each Endpoint resource conforming to this profile provides connection details for electronic services available through the Health Connect Provider Directory, allowing clients to discover and interact with service endpoints in a standardised way.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "searchRevInclude" : [
            "HealthcareService:endpoint",
            "Location:endpoint",
            "PractitionerRole:endpoint",
            "Provenance:target"
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "epurl",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-url|0.2.0-preview",
              "type" : "uri"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "payloadmimetype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-payloadmimetype|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "hcepi",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-hcepi|0.2.0-preview",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-name|4.0.1",
              "type" : "string"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "connection-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-connection-type|4.0.1",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "payload-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-payload-type|4.0.1",
              "type" : "token"
            }
          ]
        }
      ]
    }
  ]
}

```
