# Resource responder-actor-health-connect



## Resource Content

```json
{
  "resourceType" : "Basic",
  "id" : "responder-actor-health-connect",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.url",
      "valueUri" : "http://ns.electronichealth.net.au/hc/ActorDefinition/responder-actor-health-connect"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.version",
      "valueString" : "0.2.0-preview"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.name",
      "valueString" : "ResponderActorHealthConnect"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.title",
      "valueString" : "Health Connect Provider Directory Responder Actor"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.date",
      "valueDateTime" : "2026-01-20T04:27:33+00:00"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.publisher",
      "valueString" : "Australian Digital Health Agency"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "Australian Digital Health Agency",
        "telecom" : [
          {
            "system" : "url",
            "value" : "https://www.digitalhealth.gov.au/"
          },
          {
            "system" : "email",
            "value" : "help@digitalhealth.gov.au"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.contact",
      "valueContactDetail" : {
        "name" : "Australian Digital Health Agency",
        "telecom" : [
          {
            "system" : "email",
            "value" : "mailto:help@digitalhealth.gov.au",
            "use" : "work"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.description",
      "valueMarkdown" : "The Health Connect Provider Directory Responder actor represents the system that provides **Health Connect Provider Directory details**. It accepts requests for Directory information about practitioners or services and returns the requested information, or an error message if the request cannot be fulfilled."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.useContext",
      "valueUsageContext" : {
        "code" : {
          "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
          "code" : "jurisdiction"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:iso:std:iso:3166",
              "code" : "AU",
              "display" : "Australia"
            }
          ]
        }
      }
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.jurisdiction"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.copyright",
      "valueMarkdown" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.type",
      "valueCode" : "system"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.documentation",
      "valueMarkdown" : "- **SHALL** implement the [mandatory](conformance.html) requirements for the elements defined as such in this implementation guide.\n- **SHALL** implement the required REST API interactions and search parameters as defined in the Health Connect Provider Directory Responder Capability Statement."
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ActorDefinition.capabilities",
      "valueCanonical" : "http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-provider-directory-responder|0.2.0-preview"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/fhir-types",
        "code" : "ActorDefinition"
      }
    ]
  }
}

```
