<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile AUCorePractitionerRole
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:PractitionerRole</sch:title>
    <sch:rule context="f:PractitionerRole">
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-name|0.2.0-preview']) &lt;= 1">extension with URL = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-name|0.2.0-preview': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:period) &gt;= 1">period: minimum cardinality of 'period' is 1</sch:assert>
      <sch:assert test="count(f:organization) &gt;= 1">organization: minimum cardinality of 'organization' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:location) &gt;= 1">location: minimum cardinality of 'location' is 1</sch:assert>
      <sch:assert test="count(f:location) &lt;= 1">location: maximum cardinality of 'location' is 1</sch:assert>
      <sch:assert test="count(f:healthcareService) &gt;= 1">healthcareService: minimum cardinality of 'healthcareService' is 1</sch:assert>
      <sch:assert test="count(f:healthcareService) &lt;= 1">healthcareService: maximum cardinality of 'healthcareService' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:PractitionerRole/f:availableTime/f:availableStartTime</sch:title>
    <sch:rule context="f:PractitionerRole/f:availableTime/f:availableStartTime">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:PractitionerRole/f:availableTime/f:availableEndTime</sch:title>
    <sch:rule context="f:PractitionerRole/f:availableTime/f:availableEndTime">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
