<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile AUCoreHealthcareService
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:HealthcareService</sch:title>
    <sch:rule context="f:HealthcareService">
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-accept-new-patient|0.2.0-preview']) &lt;= 1">extension with URL = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-accept-new-patient|0.2.0-preview': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-referral-information-for-referrer|0.2.0-preview']) &lt;= 1">extension with URL = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-referral-information-for-referrer|0.2.0-preview': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-active-period|0.2.0-preview']) &gt;= 1">extension with URL = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-active-period|0.2.0-preview': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-active-period|0.2.0-preview']) &lt;= 1">extension with URL = 'http://ns.electronichealth.net.au/hc/StructureDefinition/hc-active-period|0.2.0-preview': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:providedBy) &gt;= 1">providedBy: minimum cardinality of 'providedBy' is 1</sch:assert>
      <sch:assert test="count(f:type) &gt;= 1">type: minimum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:location) &gt;= 1">location: minimum cardinality of 'location' is 1</sch:assert>
      <sch:assert test="count(f:location) &lt;= 1">location: maximum cardinality of 'location' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:type</sch:title>
    <sch:rule context="f:HealthcareService/f:type">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:coding) &gt;= 1">coding: minimum cardinality of 'coding' is 1</sch:assert>
      <sch:assert test="count(f:text) &lt;= 1">text: maximum cardinality of 'text' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:type/f:coding</sch:title>
    <sch:rule context="f:HealthcareService/f:type/f:coding">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:system) &lt;= 1">system: maximum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:version) &lt;= 1">version: maximum cardinality of 'version' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:display) &gt;= 1">display: minimum cardinality of 'display' is 1</sch:assert>
      <sch:assert test="count(f:display) &lt;= 1">display: maximum cardinality of 'display' is 1</sch:assert>
      <sch:assert test="count(f:userSelected) &lt;= 1">userSelected: maximum cardinality of 'userSelected' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:availableTime/f:availableStartTime</sch:title>
    <sch:rule context="f:HealthcareService/f:availableTime/f:availableStartTime">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:availableTime/f:availableEndTime</sch:title>
    <sch:rule context="f:HealthcareService/f:availableTime/f:availableEndTime">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/timezone|5.2.0': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
