# Profiles and Extensions - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Profiles and Extensions**

## Profiles and Extensions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Profiles

The following profiles and have been defined for this implementation guide.

#### Endpoint

* [HC Endpoint](StructureDefinition-hc-endpoint.md)

#### HealthcareService

* [HC HealthcareService](StructureDefinition-hc-healthcareservice.md)

#### Identifier

* [HC Endpoint Identifier (HC-EPI)](StructureDefinition-hc-endpoint-identifier.md)
* [HC HPI-O](StructureDefinition-hc-hpio.md)
* [HC HSP-O](StructureDefinition-hc-hspo.md)
* [HC Professional Registration Number (HC-PRN)](StructureDefinition-hc-prn.md)
* [HC SMD Target Identifier (HC-SMDTI)](StructureDefinition-hc-smd-target-identifier.md)
* [HC PCA Healthcare Service Identifier (PCA-HSI)](StructureDefinition-pca-hsi.md)

#### Location

* [HC Location](StructureDefinition-hc-location.md)
* [HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md)

#### Organization

* [HC Organization](StructureDefinition-hc-organization.md)

#### Practitioner

* [HC Practitioner](StructureDefinition-hc-practitioner.md)

#### PractitionerRole

* [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)

#### Provenance

* [HC Provenance](StructureDefinition-hc-provenance.md)

### Extensions

The following [extensions](http://hl7.org/fhir/R4/extensibility.html) have been defined as part of this guide. A [registry of standard extensions](http://hl7.org/fhir/R4/extensibility-registry.html) can be found in the FHIR specification and additional extensions may be registered on the HL7® FHIR® registry at [http://hl7.org/fhir/registry](http://hl7.org/fhir/registry).

* [HC Accept New Patient](StructureDefinition-hc-accept-new-patient.md)
* [HC Amenity](StructureDefinition-hc-amenity.md)
* [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md)
* [HC Active Period](StructureDefinition-hc-active-period.md)
* [HC IAR Levels of Care](StructureDefinition-hc-iar-levels-of-care.md)
* [HC Organization Classification](StructureDefinition-hc-org-classification.md)
* [HC Practitioner Role Communication](StructureDefinition-hc-practitioner-role-communication.md)
* [HC Preferred Name](StructureDefinition-hc-preferred-name.md)
* [HC Referral Information for Referrer](StructureDefinition-hc-referral-information-for-referrer.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

