# au.digitalhealth.r4.healthconnect#0.1.0-preview: Health Connect Australia Provider Directory FHIR Implementation Guide

## Pages

* [Home](index.md)
* [Disclaimers](disclaimers.md)
* [](ActorDefinition-reader-actor-health-connect.change.history.md)
* [Terminology](terminology.md)
* [Health Connect Reader Actor - XML Representation](ActorDefinition-reader-actor-health-connect.xml.md)
* [Artefacts Summary](artefacts.md)
* [Health Connect Reader Actor](ActorDefinition-reader-actor-health-connect.md)
* [Health Connect Reader Actor - TTL Representation](ActorDefinition-reader-actor-health-connect.ttl.md)
* [Health Connect Reader Actor - Testing](ActorDefinition-reader-actor-health-connect-testing.md)
* [Capability Statements](capability-statements.md)
* [Downloads](downloads.md)
* [Examples](examples.md)
* [Profiles and Extensions](profiles-and-extensions.md)
* [Actor Definitions](actors.md)
* [Guidance](guidance.md)
* [Artifacts Summary](artifacts.md)
* [Conformance Overview](conformance.md)
* [Health Connect Reader Actor - JSON Representation](ActorDefinition-reader-actor-health-connect.json.md)

## Resources

### CodeSystems

* [HC Amenity CodeSystem](CodeSystem-HCAmenity-cs.md)
* [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md)
* [HC IAR Levels of Care CodeSystem](CodeSystem-hc-iar-levels-of-care.md)
* [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md)
* [HC Service Eligibility CodeSystem](CodeSystem-hc-service-eligibility-cs.md)
* [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md)
* [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md)

### ValueSets

* [HC Amenity ValueSet](ValueSet-HCAmenityVs.md)
* [HC Gender Identity ValueSet](ValueSet-HCGenderIdentityVs.md)
* [HC Australian Endpoint Payload Types](ValueSet-hc-endpoint-payload-type-vs.md)
* [HC IAR Levels of Care ValueSet](ValueSet-hc-iar-levels-of-care-vs.md)
* [HC Organization Classification ValueSet](ValueSet-hc-org-classification-vs.md)
* [HC Service Delivery Location Role Type ValueSet](ValueSet-hc-service-delivery-location-role-type.md)
* [HC Service Eligibility ValueSet](ValueSet-hc-service-eligibility-vs.md)
* [HC Australian Service Interfaces](ValueSet-hc-service-interfaces-vs.md)
* [HC Service Provision Code](ValueSet-hc-service-provision-code-vs.md)

### Complex-type Profiles

* [HC Endpoint Identifier (HC-EPI)](StructureDefinition-hc-endpoint-identifier.md)
* [HC HPI-O](StructureDefinition-hc-hpio.md)
* [HC HSP-O](StructureDefinition-hc-hspo.md)
* [HC Professional Registration Number (HC-PRN)](StructureDefinition-hc-prn.md)
* [HC SMD Target Identifier (HC-SMDTI)](StructureDefinition-hc-smd-target-identifier.md)
* [HC PCA Healthcare Service Identifier (PCA-HSI)](StructureDefinition-pca-hsi.md)

### Resource Profiles

* [HC Endpoint](StructureDefinition-hc-endpoint.md)
* [HC HealthcareService](StructureDefinition-hc-healthcareservice.md)
* [HC Location](StructureDefinition-hc-location.md)
* [HC Organization](StructureDefinition-hc-organization.md)
* [HC Practitioner](StructureDefinition-hc-practitioner.md)
* [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)
* [HC Provenance](StructureDefinition-hc-provenance.md)
* [HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md)

### Extensions

* [HC Accept New Patient](StructureDefinition-hc-accept-new-patient.md)
* [HC Active Period](StructureDefinition-hc-active-period.md)
* [HC Amenity](StructureDefinition-hc-amenity.md)
* [HC IAR Levels of Care](StructureDefinition-hc-iar-levels-of-care.md)
* [HC Organization Classification](StructureDefinition-hc-org-classification.md)
* [HC Practitioner Role Communication](StructureDefinition-hc-practitioner-role-communication.md)
* [HC Preferred Name](StructureDefinition-hc-preferred-name.md)
* [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md)
* [HC Referral Information for Referrer](StructureDefinition-hc-referral-information-for-referrer.md)

### Basics

* [reader-actor-health-connect](Basic-reader-actor-health-connect.md)

### CapabilityStatements

* [Health Connect Reader](CapabilityStatement-health-connect-reader.md)

### ImplementationGuides

* [Health Connect Australia Provider Directory FHIR Implementation Guide](index.md)

### SearchParameters

* [SearchParameterProfessionalRegistrationNumber](SearchParameter-ProfessionalRegistrationNumber.md)
* [SearchParameterAvailabilityAllDay](SearchParameter-availability-allday.md)
* [SearchParameterAvailabilityDaysOfWeek](SearchParameter-availability-daysofweek.md)
* [SearchParameterAvailabilityEndTime](SearchParameter-availability-endtime.md)
* [SearchParameterAvailabilityStartTime](SearchParameter-availability-starttime.md)
* [SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md)
* [SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md)
* [SearchParameterEndpointUrl](SearchParameter-endpoint-url.md)
* [SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md)
* [SearchParameterLanguages](SearchParameter-languages.md)
* [SearchParameterLocationAmenities](SearchParameter-location-amenities.md)
* [SearchParameterLocationPostalAddress](SearchParameter-location-postalAddress.md)
* [SearchParameterPractitionerOfficialName](SearchParameter-practitioner-officialname.md)
* [SearchParameterPractitionerPreferredname](SearchParameter-practitioner-preferredname.md)
* [SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md)
* [SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md)
* [SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)

### Examples

* [Sydney General Hospital SMD Endpoint (Endpoint)](Endpoint-example-hc-endpoint-smd.md)
* [Healthcare service with Residential Aged Care service type (HealthcareService)](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [example-healthconnect-Location-service-coverage-area (Location)](Location-example-healthconnect-Location-service-coverage-area.md)
* [Physical location with wheelchair access (Location)](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)
* [Virtual Telehealth Service (Location)](Location-example-healthconnect-virtual-telehealth-service-1.md)
* [Example Aged Care Facility (Organization)](Organization-example-healthconnect-organization-1.md)
* [example-healthconnect-practitioner-1 (Practitioner)](Practitioner-example-healthconnect-practitioner-1.md)
* [external-hc-practitioner-record (Practitioner)](Practitioner-external-hc-practitioner-record.md)
* [example-healthconnect-practitionerrole-1 (PractitionerRole)](PractitionerRole-example-healthconnect-practitionerrole-1.md)
* [provenance-practitioner-name-update (Provenance)](Provenance-provenance-practitioner-name-update.md)
* [provenance-practitioner-phone-update (Provenance)](Provenance-provenance-practitioner-phone-update.md)
