# Examples - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following examples are published with this guide and all are available as a downloadable as zip file [here](downloads.md#examples).

Examples that conform to the profile or extension and demonstrate one or more usage scenarios supported by this implementation guide.

> Most examples will include the profile in the meta.profile property. Resources from production systems may not include this property, and are not required to. They are included so that example resources will validate against the intended profiles, and highlight to the reader the example is demonstrating a specific profile.

### Endpoint

* [Health Connect Endpoint - SMD Target Example](Endpoint-example-hc-endpoint-smd.md)

### HealthcareService

* [Health Connect - HealthcareService example](HealthcareService-example-healthconnect-healthcareservice-1.md)

### Location

* [Health Connect - Example Location Service Coverage Area](Location-example-healthconnect-Location-service-coverage-area.md)

* [Health Connect - Example Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)

* [Health Connect - Example Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)

### Organization

* [Health Connect - Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

### Practitioner

* [Health Connect - Helen Mayo](Practitioner-example-healthconnect-practitioner-1.md)

* [Health Connect - External HC Practitioner Record](Practitioner-external-hc-practitioner-record.md)

### PractitionerRole

* [Health Connect - PractitionerRole example](PractitionerRole-example-healthconnect-practitionerrole-1.md)

### Provenance

* [Health Connect Provenance - Track Practitioner Name Amendment](Provenance-provenance-practitioner-name-update.md)

* [Health Connect Provenance - Track Practitioner Phone Amendment](Provenance-provenance-practitioner-phone-update.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

