# HC Preferred Postal Address - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Preferred Postal Address**

## Extension: HC Preferred Postal Address 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-postal-address | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCPreferredPostalAddress |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [HC Location](StructureDefinition-hc-location.md)
* Examples for this Extension: [Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-preferred-postal-address)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-preferred-postal-address.csv), [Excel](StructureDefinition-hc-preferred-postal-address.xlsx), [Schematron](StructureDefinition-hc-preferred-postal-address.sch) 

#### Constraints

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-preferred-postal-address",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-postal-address",
  "version" : "0.1.0-preview",
  "name" : "HCPreferredPostalAddress",
  "title" : "HC Preferred Postal Address",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-20T03:48:09+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Location"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HC Preferred Postal Address",
        "definition" : "Carries a preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address. This extension is used in the context of HC-Location profile. Allows organisations to nominate a secure mailing address for official correspondence."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-postal-address"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Preferred postal/mailing address",
        "definition" : "A chosen or preferred postal or mailing address, used for correspondence and separate from the registered physical address.",
        "min" : 1,
        "type" : [
          {
            "code" : "Address"
          }
        ]
      }
    ]
  }
}

```
