# Health Connect - Example Aged Care Facility - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect - Example Aged Care Facility**

## Example Organization: Health Connect - Example Aged Care Facility

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-08-30 09:15:00+0000

Profile: [HC Organization](StructureDefinition-hc-organization.md)

**identifier**: National Organisation Identifier/8003626566707032, ABN/41824753556, ACN/123456789

**active**: true

**name**: Example Aged Care Facility

**alias**: Ye old Example Aged Care

**telecom**: ph: (03) 5550 4075(Work), ph: (03) 5550 4076(Work), [reception@example.com.au](mailto:reception@example.com.au), [admin@example.com.au](mailto:admin@example.com.au), [https://www.mocklocation.com.au](https://www.mocklocation.com.au), fax: +61 2 6666 7777(Work)

**address**: 

* 175 Liverpool Street Sydney NSW 2000 AU 
* PO Box 12345 Sydney NSW 1230 AU 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "example-healthconnect-organization-1",
  "meta" : {
    "lastUpdated" : "2025-08-30T09:15:00Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization"
    ]
  },
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-org-classification",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://ns.electronichealth.net.au/hc/CodeSystem/hc-org-classification-cs",
                "code" : "network",
                "display" : "Network"
              }
            ]
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003626566707032"
    },
    {
      "type" : {
        "text" : "ABN"
      },
      "system" : "http://hl7.org.au/id/abn",
      "value" : "41824753556"
    },
    {
      "type" : {
        "text" : "ACN"
      },
      "system" : "http://hl7.org.au/id/acn",
      "value" : "123456789"
    }
  ],
  "active" : true,
  "name" : "Example Aged Care Facility",
  "alias" : ["Ye old Example Aged Care"],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 5550 4075",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(03) 5550 4076",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "reception@example.com.au",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "admin@example.com.au",
      "use" : "work"
    },
    {
      "system" : "url",
      "value" : "https://www.mocklocation.com.au",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "+61 2 6666 7777",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "type" : "physical",
      "line" : ["175 Liverpool Street"],
      "city" : "Sydney",
      "state" : "NSW",
      "postalCode" : "2000",
      "country" : "AU"
    },
    {
      "type" : "postal",
      "line" : ["PO Box 12345"],
      "city" : "Sydney",
      "state" : "NSW",
      "postalCode" : "1230",
      "country" : "AU"
    }
  ]
}

```
