# HC Australian Endpoint Payload Types - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Australian Endpoint Payload Types**

## CodeSystem: HC Australian Endpoint Payload Types (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/CodeSystem/hc-endpoint-payload-type-cs | *Version*:0.1.0-preview |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:AustralianEndpointPayloadTypesCodeSystem |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
The Endpoint Payload Types code system defines concepts that identify well known endpoint payload types. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "hc-endpoint-payload-type-cs",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/CodeSystem/hc-endpoint-payload-type-cs",
  "version" : "0.1.0-preview",
  "name" : "AustralianEndpointPayloadTypesCodeSystem",
  "title" : "HC Australian Endpoint Payload Types",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-11-20T03:48:09+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The Endpoint Payload Types code system defines concepts that identify well known endpoint payload types.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "caseSensitive" : true,
  "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-endpoint-payload-type-vs",
  "compositional" : false,
  "versionNeeded" : true,
  "content" : "complete",
  "count" : 13,
  "concept" : [
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-REF-SIMPLIFIED-201706",
      "display" : "HL7 V2.4 REF message (Level 2)",
      "definition" : "Simplified profile on HL7 V2.4 REF message Level 2 profile (HL7AUSD-STD-OO-ADRM-2018.1 Australian Diagnostics and Referral Messaging - Localisation of HL7 Version 2.4)"
    },
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-REF-SIMPLIFIED-201706-L1",
      "display" : "HL7 V2.4 REF message (Level 1)",
      "definition" : "Simplified profile on HL7 V2.4 REF message Level 1 profile (HL7AUSD-STD-OO-ADRM-2018.1 Australian Diagnostics and Referral Messaging - Localisation of HL7 Version 2.4)"
    },
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-REF-SIMPLIFIED-201706/RRI",
      "display" : "HL7 V2.4 RRI message",
      "definition" : "Profile of referral response for the simplified profile for HL7 v2.4 REF message"
    },
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-ORU-201701",
      "display" : "HL7 V2.4 ORU message",
      "definition" : "Profile on HL7 V2.4 ORU report message (HL7AUSD-STD-OO-ADRM-2018.1) Australian Diagnostics and Referral Messaging - Localisation of HL7 Version 2.4)"
    },
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-ORM-201701",
      "display" : "HL7 V2.4 ORM message",
      "definition" : "Profile on HL7 V2.4 ORM order message (HL7AUSD-STD-OO-ADRM-2018.1) Australian Diagnostics and Referral Messaging - Localisation of HL7 Version 2.4)"
    },
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-ORR-201701",
      "display" : "HL7 V2.4 ORR message",
      "definition" : "Profile on HL7 V2.4 ORR order response message (HL7AUSD-STD-OO-ADRM-2018.1) Australian Diagnostics and Referral Messaging - Localisation of HL7 Version 2.4)"
    },
    {
      "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-ACK-201701",
      "display" : "HL7 V2.4 ACK message",
      "definition" : "Profile on HL7 V2.4 ACK general acknowledgement message (HL7AUSD-STD-OO-ADRM-2018.1) Australian Diagnostics and Referral Messaging - Localisation of HL7 Version 2.4)"
    },
    {
      "code" : "http://ns.electronichealth.net.au/ack/sc/deliver/hl7Ack/2012",
      "display" : "HL7 V2.3.1 Acknowledgement",
      "definition" : "Profile for ACK"
    },
    {
      "code" : "http://ns.electronichealth.net.au/ds/sc/deliver/hl7Mdm/2012",
      "display" : "HL7 V2.3.1 MDM Discharge Summary",
      "definition" : "Discharge Summary CDA contained in MDM message"
    },
    {
      "code" : "http://ns.electronichealth.net.au/er/sc/deliver/hl7Mdm/2012",
      "display" : "HL7 V2.3.1 MDM eReferral",
      "definition" : "eReferral CDA contained in MDM message"
    },
    {
      "code" : "http://ns.electronichealth.net.au/es/sc/deliver/hl7Mdm/2012",
      "display" : "HL7 V2.3.1 MDM Event Summary",
      "definition" : "Event Summary CDA contained in MDM message"
    },
    {
      "code" : "http://ns.electronichealth.net.au/shs/sc/deliver/hl7Mdm/2012",
      "display" : "HL7 V2.3.1 MDM Shared Health Summary",
      "definition" : "Shared Health Summary CDA contained in MDM message"
    },
    {
      "code" : "http://ns.electronichealth.net.au/sl/sc/deliver/hl7Mdm/2012",
      "display" : "HL7 V2.3.1 MDM Specialist Letter",
      "definition" : "Specialist Letter CDA contained in MDM message"
    }
  ]
}

```
