# HC SMD Target Identifier (HC-SMDTI) - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC SMD Target Identifier (HC-SMDTI)**

## Data Type Profile: HC SMD Target Identifier (HC-SMDTI) 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-smd-target-identifier | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCSMDTargetIdentifier |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This identifier profile defines a SMD target identifier allocated to a healthcare practitioner, in a Health Connect provider directory context. 

**Usages:**

* Use this DataType Profile: [HC Endpoint](StructureDefinition-hc-endpoint.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-smd-target-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-smd-target-identifier.csv), [Excel](StructureDefinition-hc-smd-target-identifier.xlsx), [Schematron](StructureDefinition-hc-smd-target-identifier.sch) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-smd-target-identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-smd-target-identifier",
  "version" : "0.1.0-preview",
  "name" : "HCSMDTargetIdentifier",
  "title" : "HC SMD Target Identifier (HC-SMDTI)",
  "status" : "draft",
  "date" : "2025-11-20T03:48:09+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This identifier profile defines a SMD target identifier allocated to a healthcare practitioner, in a Health Connect provider directory context.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier",
        "short" : "SMD Target Identifier",
        "definition" : "SMD Target Identifier that the practitioner has with Professional association / Peak body association (for non-AHPRA registered practitioners), as recorded against the HPI-I record."
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "short" : "Secure Messaging Delivery Target Identifier",
        "definition" : "Target identifier suitable for Secure Message Delivery interface metadata content; also allows lookup for responses.",
        "min" : 1,
        "fixedUri" : "http://ns.electronichealth.net.au/smd/target"
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "short" : "SMD Target Identifier Value",
        "definition" : "Assigning SMD target identifier value.",
        "min" : 1,
        "example" : [
          {
            "label" : "SMD Target ID",
            "valueString" : "1234567890"
          }
        ]
      },
      {
        "id" : "Identifier.assigner",
        "path" : "Identifier.assigner",
        "short" : "Organization that issued the smdTarget identifier (may be just text)",
        "definition" : "Organization that issued the smdTarget identifier (may be just text)."
      }
    ]
  }
}

```
