# HC Practitioner - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Practitioner**

## Resource Profile: HC Practitioner 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCPractitioner |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This profile defines Healthcare Provider Individual details who is delivering health related services. 

No data is entered directly into Health Connect; all directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

**Note:** All elements defined within this profile are expected to be supported by implementing systems unless explicitly stated otherwise. The following sections provide additional guidance and exceptions for specific elements.

### Usage notes

The following guidance maps key information requirements for HC Practitioner records to fields in the profile. Where a requirement references the HI Service as the authoritative source, publishers SHOULD prefer and validate values—such as practitioner identifiers, and names.

#### Identifiers

**Required Identifier:**

* **HPI-I** - Healthcare Provider Identifier - Individual (mandatory)

#### Professional Registration and Profession

Professional registration should be carried in the `qualification` element. The registration number of the Practitioner should be populated in `qualification.identifier`; the practitioner's profession should be sent as free text in `qualification.code.text`.

* `qualification.identifier`: Registration number issued by the regulatory body (either issued by Ahpra or a non-Ahpra peak body). Follow the applicable identifier profile for format and issuer information.
* `qualification.code.text`: The practitioner's profession linked to the registration number as a human-readable string. Because there is no single, authoritative ValueSet that covers all professions reliably, send the profession in `code.text`.
* `qualification.code.coding` (optional): Only use coded values when you have an authoritative, stable code system for that profession. When `coding` is included, also populate `code.text` with the same label.

Notes:

* For Ahpra-registered practitioners include the Ahpra registration number in `qualification.identifier`. If you can map the profession to a reliable Ahpra code you may include `qualification.code.coding`, but still provide `qualification.code.text`.
* For non-Ahpra registrations include the issuing organisation in `qualification.issuer.display` or, when attaching issuer details to the identifier itself, use `qualification.identifier.assigner.display` or `qualification.identifier.system` as appropriate.

This profile requires profession to be present as human-readable text in `qualification.code.text` when the profession is known; coded professions are optional.

#### Personal contact details

Practitioners may optionally provide personal contact details for inclusion in the Provider Directory. This includes `personalPhoneNumber` and `personalEmailAddress`. Publishing systems MUST only include and display these personal contact details if the practitioner has explicitly opted in to being listed; treat these fields as sensitive and do not expose them publicly unless the practitioner has consented.

### Data Integrity and Validation

This profile includes invariants to ensure data consistency and proper professional credentialing.

#### Professional Registration Invariants

**`hc-practitioner-registration-required`(error):** Ensures at least one professional registration is present in qualifications:

* At least one qualification with Ahpra registration identifier OR
* At least one qualification with professional registration (PRN) identifier

**Implementation Validation:**

* Each qualification will include both an identifier and appropriate profession code

**Usages:**

* Refer to this Profile: [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md) and [HC Provenance](StructureDefinition-hc-provenance.md)
* Examples for this Profile: [Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md) and [Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md)
* CapabilityStatements using this Profile: [Health Connect Reader](CapabilityStatement-health-connect-reader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-practitioner.csv), [Excel](StructureDefinition-hc-practitioner.xlsx), [Schematron](StructureDefinition-hc-practitioner.sch) 

### Notes:

### Search parameters for HC Practitioner

This IG provides a small set of convenience SearchParameters to make it easier to find HC Practitioner resources; it also expects implementers to support common Practitioner parameters from AU Core & AU Base.

#### Search parameters defined within AU Core and AU Base

How search queries can be performed using the HPI-I are described in [AU Core documentation](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html#notes). How search queries can be performed using gender-identity is described in [AU Base documentation](https://build.fhir.org/ig/hl7au/au-fhir-base/SearchParameter-gender-identity.html). The AU Core guidance favours the standard FHIR `identifier` search parameter using the system|value (token) form.

* `identifier` - Search practitioners by HPI-I or Ahpra registration number. Examples:
* `GET /Practitioner?identifier=http://ns.electronichealth.net.au/id/hi/hpii/1.0|8003619900015717` (HPI-I)
* `GET /Practitioner?identifier=http://hl7.org.au/id/ahpra-registration-number|MED0000932945` (Ahpra)
* `gender-identity` (Practitioner.extension('http://hl7.org/fhir/StructureDefinition/individual-genderIdentity').extension('value').value)
* Search by a practitioner's recorded gender identity extension value.
* Example: `GET /Practitioner?genderIdentity=http://snomed.info/sct|446151000124109`

#### Search parameters defined in this IG

The following search parameters are **defined by this IG** and **SHALL** be supported:

* `practitionername` (Practitioner.name where name.use = official)
* Search by the practitioner's official/legal name.
* Example: `GET /Practitioner?practitionername=Fryer`
* `practitioneralias` (Practitioner.name where name.use = usual)
* Search by the practitioner's preferred or commonly used name.
* Example: `GET /Practitioner?practitioneralias=Helen`
* `prn` (Practitioner.qualification.identifier where type.coding.code = 'PRN')
* Find practitioners by a Professional Registration Number (PRN).
* Example (value-only): `GET /Practitioner?prn=PRN-123456`
* `rsg` (Practitioner.extension(recordedSexorGender).valueCodeableConcept)
* Search by a practitioner's recorded sex or gender.
* Example: `GET /Practitioner?rsg=http://hl7.org/fhir/administrative-gender|male`
* `regprof` (Practitioner.qualification.code.text)
* Search by a practitioner's registered profession using string values.
* Example: `GET /Practitioner?regprof=Psychologist`

**Note:** Support for _id is mandatory for a responder and optional for a requester. Where the expectation for a search parameter differs between actors, the table below will reflect the stronger conformance requirement.

* Parameter(s): _id
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): identifier
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide both the code values. The responder**SHALL**support.The requester**SHOULD**support search using HPI-I or Ahpra number as defined in the profile. The responder**SHOULD**support search using the using HPI-I or Ahphra number as defined in the profile.
* Parameter(s): practitionername
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): practitioneralias
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): prn
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): Search by Professional Registration Number. Shared SearchParameter for availability across Practitioner and PractitionerRole
* Parameter(s): ahpraregistrationnumber
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): Search by Ahpra registration number. Shared SearchParameter for availability across Practitioner and PractitionerRole
* Parameter(s): regprof
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): Search by registered profession using string values in `qualification.code.text`.
* Parameter(s): identifier+rsg
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): identifier+gender-identity
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): practitionername+rsg
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): practitionername+gender-identity
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): practitioneralias+rsg
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): practitioneralias+gender-identity
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): prn+rsg
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): prn+gender-identity
  * Conformance: **SHOULD**
  * Type(s): `token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): regprof+rsg
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): Search by Ahpra profession and recorded sex/gender
* Parameter(s): regprof+gender-identity
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): Search by Ahpra profession and gender identity

### Search reverse include parameters

This implementation supports the following `_revinclude` parameters when searching for Practitioner resources:

* `_revinclude=PractitionerRole:practitioner` - Include PractitionerRole resources that reference this Practitioner
* `_revinclude=Provenance:target` - Include Provenance resources that track changes to this Practitioner

#### Example usage

```
GET /Practitioner/202?_revinclude=PractitionerRole:practitioner

```

This query returns the Practitioner resource along with all their associated roles and positions.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner",
  "version" : "0.1.0-preview",
  "name" : "HCPractitioner",
  "title" : "HC Practitioner",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-20T03:48:09+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile defines Healthcare Provider Individual details who is delivering health related services.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner",
        "short" : "Healthcare Provider Individual",
        "definition" : "The practitioner is an individual who provides healthcare or healthcare related services and is\nregistered by a registration authority as a member of a health profession and/or is a member of a\nhealthcare professional association that relates to healthcare, and who has been assigned a\nhealthcare identifier (HPI-I).",
        "constraint" : [
          {
            "key" : "hc-practitioner-registration-required",
            "severity" : "error",
            "human" : "At least one professional registration must be present in qualifications (Ahpra or other professional registration)",
            "expression" : "qualification.identifier.where(type.coding.code = 'AHPRA').exists() or qualification.identifier.where(type.coding.code = 'PRN').exists()",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner"
          }
        ]
      },
      {
        "id" : "Practitioner.extension",
        "path" : "Practitioner.extension",
        "min" : 1
      },
      {
        "id" : "Practitioner.extension:genderIdentity",
        "path" : "Practitioner.extension",
        "sliceName" : "genderIdentity",
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/HCGenderIdentityVs"
        }
      },
      {
        "id" : "Practitioner.extension:recordedSexOrGender",
        "path" : "Practitioner.extension",
        "sliceName" : "recordedSexOrGender",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.identifier",
        "path" : "Practitioner.identifier",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier:hpii",
        "path" : "Practitioner.identifier",
        "sliceName" : "hpii",
        "short" : "HPI-I identifier",
        "min" : 1
      },
      {
        "id" : "Practitioner.name",
        "path" : "Practitioner.name",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "use"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.name:officialName",
        "path" : "Practitioner.name",
        "sliceName" : "officialName",
        "short" : "Legal Registered Name",
        "definition" : "The registered name of the Practitioner with the Ahpra board / Professional association / Peak body profession, as obtained from the HI service.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name:officialName.use",
        "path" : "Practitioner.name.use",
        "min" : 1,
        "fixedCode" : "official"
      },
      {
        "id" : "Practitioner.name:officialName.family",
        "path" : "Practitioner.name.family",
        "short" : "Practitioner's family name"
      },
      {
        "id" : "Practitioner.name:officialName.given",
        "path" : "Practitioner.name.given",
        "short" : "Practitioner's given name",
        "max" : "1"
      },
      {
        "id" : "Practitioner.name:officialName.prefix",
        "path" : "Practitioner.name.prefix",
        "short" : "Title",
        "max" : "1"
      },
      {
        "id" : "Practitioner.name:preferredName",
        "path" : "Practitioner.name",
        "sliceName" : "preferredName",
        "short" : "Additional preferred name or alias of a practitioner",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.name:preferredName.use",
        "path" : "Practitioner.name.use",
        "min" : 1,
        "fixedCode" : "usual"
      },
      {
        "id" : "Practitioner.name:preferredName.family",
        "path" : "Practitioner.name.family",
        "short" : "Practitioner's family name"
      },
      {
        "id" : "Practitioner.telecom",
        "path" : "Practitioner.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            },
            {
              "type" : "value",
              "path" : "use"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Practitioner.telecom:personalPhoneNumber",
        "path" : "Practitioner.telecom",
        "sliceName" : "personalPhoneNumber",
        "short" : "Personal phone number",
        "definition" : "Personal phone number for the practitioner",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom:personalPhoneNumber.system",
        "path" : "Practitioner.telecom.system",
        "min" : 1,
        "fixedCode" : "phone"
      },
      {
        "id" : "Practitioner.telecom:personalPhoneNumber.value",
        "path" : "Practitioner.telecom.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.telecom:personalPhoneNumber.use",
        "path" : "Practitioner.telecom.use",
        "min" : 1,
        "fixedCode" : "home"
      },
      {
        "id" : "Practitioner.telecom:personalEmailAddress",
        "path" : "Practitioner.telecom",
        "sliceName" : "personalEmailAddress",
        "short" : "Personal Email address",
        "definition" : "Personal Email address for the practitioner",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.telecom:personalEmailAddress.system",
        "path" : "Practitioner.telecom.system",
        "min" : 1,
        "fixedCode" : "email"
      },
      {
        "id" : "Practitioner.telecom:personalEmailAddress.value",
        "path" : "Practitioner.telecom.value",
        "min" : 1
      },
      {
        "id" : "Practitioner.telecom:personalEmailAddress.use",
        "path" : "Practitioner.telecom.use",
        "min" : 1,
        "fixedCode" : "home"
      },
      {
        "id" : "Practitioner.qualification",
        "path" : "Practitioner.qualification",
        "short" : "Certifications, licenses, or training pertaining to the provision of care",
        "definition" : "The official certifications, training, and licenses that authorize or otherwise pertain to the provision of care by the practitioner.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier",
        "path" : "Practitioner.qualification.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "short" : "An identifier for this qualification",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier:ahpraregistrationnumber",
        "path" : "Practitioner.qualification.identifier",
        "sliceName" : "ahpraregistrationnumber",
        "short" : "Ahpra registration number",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-ahpraregistrationnumber"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.identifier:professionalRegistration",
        "path" : "Practitioner.qualification.identifier",
        "sliceName" : "professionalRegistration",
        "short" : "Professional registration number for non-Ahpra practitioners",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-prn"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Practitioner.qualification.code",
        "path" : "Practitioner.qualification.code",
        "short" : "Profession of the Practitioner.",
        "definition" : "Profession is to be sent via code.text",
        "mustSupport" : true
      }
    ]
  }
}

```
