# HC Endpoint Identifier (HC-EPI) - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Endpoint Identifier (HC-EPI)**

## Data Type Profile: HC Endpoint Identifier (HC-EPI) 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint-identifier | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCEndpointIdentifier |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This identifier profile defines a unique identifier allocated to a healthcare endpoint, in a Health Connect provider directory context. 

### HC Endpoint Identifier (HC-EPI)

The `HC-EPI` is the primary external identifier used to identify an `Endpoint` across Health Connect. Publishers SHOULD provide an authoritative external identifier when creating or updating an `Endpoint`. The `HC-EPI` is **mandatory** for `Endpoint` resources published in the Health Connect directory and is used as a primary reconciliation key for cross-system matching.

* `identifier.type`: fixed to `RI` (resource identifier).
* `identifier.value`: the external identifier value supplied by the publisher or assigning organisation.
* `identifier.system`: populate with a stable URI to support authoritative reconciliation.

Guidance:

* The combination of system and value MUST be globally unique within Health Connect and SHOULD be stable over the lifecycle of the endpoint.
* Use `identifier.system` to record a canonical URI when organisations have a stable namespace for their identifiers.

**Usages:**

* Use this DataType Profile: [HC Endpoint](StructureDefinition-hc-endpoint.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-endpoint-identifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-endpoint-identifier.csv), [Excel](StructureDefinition-hc-endpoint-identifier.xlsx), [Schematron](StructureDefinition-hc-endpoint-identifier.sch) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-endpoint-identifier",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint-identifier",
  "version" : "0.1.0-preview",
  "name" : "HCEndpointIdentifier",
  "title" : "HC Endpoint Identifier (HC-EPI)",
  "status" : "draft",
  "date" : "2025-11-20T03:48:09+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This identifier profile defines a unique identifier allocated to a healthcare endpoint, in a Health Connect provider directory context.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier",
        "short" : "HC Endpoint Identifier system.",
        "definition" : "Assigning system of the HC Endpoint Identifier."
      },
      {
        "id" : "Identifier.type",
        "path" : "Identifier.type",
        "short" : "Coded identifier type for end point identifier",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "RI"
            }
          ]
        }
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "short" : "HC Endpoint Identifier value.",
        "definition" : "Value of the HC Endpoint Identifier assigned by a publishing system.",
        "min" : 1,
        "example" : [
          {
            "label" : "HC Endpoint ID",
            "valueString" : "1234567890"
          }
        ]
      }
    ]
  }
}

```
