# Health Connect - PractitionerRole example - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect - PractitionerRole example**

## Example PractitionerRole: Health Connect - PractitionerRole example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-09-03 01:23:45+0000

Profile: [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)

**HC Practitioner Role Communication**: Italian

**HC Preferred Name**: Dr. Alex Smith 

**identifier**: Medicare Provider Number/2426621B, Australian Health Practitioner Regulation Agency Registration Number/MED0000932945

**period**: 2023-01-01 --> (ongoing)

**practitioner**: [Practitioner Helen Mayo (official)](Practitioner-example-healthconnect-practitioner-1.md)

**organization**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

**code**: Medical pathologist

**location**: [Location Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)

**healthcareService**: [HealthcareService Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)

**telecom**: ph: 0255507777(Work)

> **availableTime****daysOfWeek**: Monday**allDay**: false**availableStartTime**: 10:00:00**availableEndTime**: 17:00:00

> **availableTime****daysOfWeek**: Tuesday**allDay**: false**availableStartTime**: 09:00:00**availableEndTime**: 17:00:00

> **availableTime****daysOfWeek**: Wednesday**allDay**: false**availableStartTime**: 07:00:00**availableEndTime**: 13:00:00

> **availableTime****daysOfWeek**: Thursday**allDay**: false**availableStartTime**: 09:00:00**availableEndTime**: 17:00:00

> **availableTime****daysOfWeek**: Friday**allDay**: false**availableStartTime**: 10:00:00**availableEndTime**: 16:00:00

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "example-healthconnect-practitionerrole-1",
  "meta" : {
    "lastUpdated" : "2025-09-03T01:23:45Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole"
    ]
  },
  "extension" : [
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner-role-communication",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "it",
            "display" : "Italian"
          }
        ]
      }
    },
    {
      "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-name",
      "valueHumanName" : {
        "use" : "usual",
        "family" : "Smith",
        "given" : ["Dr. Alex"],
        "prefix" : ["Dr"]
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "UPIN",
            "display" : "Medicare Provider Number"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
      "value" : "2426621B"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "AHPRA"
          }
        ]
      },
      "system" : "http://hl7.org.au/id/ahpra-registration-number",
      "value" : "MED0000932945"
    }
  ],
  "period" : {
    "start" : "2023-01-01"
  },
  "practitioner" : {
    "reference" : "Practitioner/example-healthconnect-practitioner-1"
  },
  "organization" : {
    "reference" : "Organization/example-healthconnect-organization-1"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "61207006",
          "display" : "Medical pathologist"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/example-healthconnect-Physical-location-with-wheelchair-access-1"
    }
  ],
  "healthcareService" : [
    {
      "reference" : "HealthcareService/example-healthconnect-healthcareservice-1"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0255507777",
      "use" : "work"
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["mon"],
      "allDay" : false,
      "availableStartTime" : "10:00:00",
      "availableEndTime" : "17:00:00"
    },
    {
      "daysOfWeek" : ["tue"],
      "allDay" : false,
      "availableStartTime" : "09:00:00",
      "availableEndTime" : "17:00:00"
    },
    {
      "daysOfWeek" : ["wed"],
      "allDay" : false,
      "availableStartTime" : "07:00:00",
      "availableEndTime" : "13:00:00"
    },
    {
      "daysOfWeek" : ["thu"],
      "allDay" : false,
      "availableStartTime" : "09:00:00",
      "availableEndTime" : "17:00:00"
    },
    {
      "daysOfWeek" : ["fri"],
      "allDay" : false,
      "availableStartTime" : "10:00:00",
      "availableEndTime" : "16:00:00"
    }
  ]
}

```
