# HC Service Eligibility CodeSystem - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Service Eligibility CodeSystem**

## CodeSystem: HC Service Eligibility CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/CodeSystem/hc-service-eligibility-cs | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCServiceEligibilityCodeSystem |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: This code system is a clone of the PCA Service Eligibility CodeSystem. Copyright © Australian Digital Health Agency. | |

 
Health Connect code system for service eligibility, modeled after PCA's eligibility code system. Codes represent eligibility requirements for healthcare services. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "hc-service-eligibility-cs",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/CodeSystem/hc-service-eligibility-cs",
  "version" : "0.1.0-preview",
  "name" : "HCServiceEligibilityCodeSystem",
  "title" : "HC Service Eligibility CodeSystem",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-20T03:48:09+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Health Connect code system for service eligibility, modeled after PCA's eligibility code system. Codes represent eligibility requirements for healthcare services.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "This code system is a clone of the PCA Service Eligibility CodeSystem. Copyright © Australian Digital Health Agency.",
  "caseSensitive" : true,
  "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-service-eligibility-vs",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "count" : 26,
  "concept" : [
    {
      "code" : "newBorn0to3",
      "display" : "Neonate/newborn 0-3 months",
      "definition" : "Neonate/newborn 0-3 months"
    },
    {
      "code" : "infant3to6",
      "display" : "Infant 3-6 months",
      "definition" : "Infant 3-6 months"
    },
    {
      "code" : "infant6to12",
      "display" : "Infant 6-12 months",
      "definition" : "Infant 6-12 months"
    },
    {
      "code" : "toddlerPreschool1to4",
      "display" : "Toddler to preschool 1-4 years",
      "definition" : "Toddler to preschool 1-4 years"
    },
    {
      "code" : "childYouth5to17",
      "display" : "Children and young people 5-17 years",
      "definition" : "Children and young people 5-17 years"
    },
    {
      "code" : "adult18to64",
      "display" : "Adult 18-64 years",
      "definition" : "Adult 18-64 years"
    },
    {
      "code" : "adult65Plus",
      "display" : "Older Adult 65+ years",
      "definition" : "Older Adult 65+ years"
    },
    {
      "code" : "carer-youngCarerUnder25",
      "display" : "Carer - Young Carer (Under 25)",
      "definition" : "Carer - Young Carer (Under 25)"
    },
    {
      "code" : "carer-adultCarer",
      "display" : "Carer - Adult Carer",
      "definition" : "Carer - Adult Carer"
    },
    {
      "code" : "coverage-restrictedResidents",
      "display" : "Coverage - Restricted To Residents In Coverage Area",
      "definition" : "Coverage - Restricted To Residents In Coverage Area"
    },
    {
      "code" : "disabled-intellectually",
      "display" : "Disabled - Intellectually",
      "definition" : "Disabled - Intellectually"
    },
    {
      "code" : "disabled-disabledPhysically",
      "display" : "Disabled - Physically",
      "definition" : "Disabled - Physically"
    },
    {
      "code" : "gender-men",
      "display" : "Gender - Men",
      "definition" : "Gender - Men"
    },
    {
      "code" : "gender-women",
      "display" : "Gender - Women",
      "definition" : "Gender - Women"
    },
    {
      "code" : "other-aboriginalPeoples",
      "display" : "Aboriginal Peoples",
      "definition" : "Aboriginal Peoples"
    },
    {
      "code" : "other-torresStraitIslanderPeoples",
      "display" : "Torres Strait Islander Peoples",
      "definition" : "Torres Strait Islander Peoples"
    },
    {
      "code" : "other-cald",
      "display" : "CALD (Culturally and Linguistically Diverse)",
      "definition" : "CALD (Culturally and Linguistically Diverse)"
    },
    {
      "code" : "other-lgbti",
      "display" : "LGBTI (Lesbian, Gay, Bisexual, Transgender and Intersex)",
      "definition" : "LGBTI (Lesbian, Gay, Bisexual, Transgender and Intersex)"
    },
    {
      "code" : "other-families",
      "display" : "Families",
      "definition" : "Families"
    },
    {
      "code" : "other-parents",
      "display" : "Parents",
      "definition" : "Parents"
    },
    {
      "code" : "other-veterans",
      "display" : "Veterans",
      "definition" : "Veterans"
    },
    {
      "code" : "other-existingPatientsOnly",
      "display" : "Existing Patients Only",
      "definition" : "Existing Patients Only"
    },
    {
      "code" : "other-requiresReferral",
      "display" : "Requires Referral",
      "definition" : "Requires Referral"
    },
    {
      "code" : "other-mentalHealth",
      "display" : "People with Mental Health Issues",
      "definition" : "People with Mental Health Issues"
    },
    {
      "code" : "other-chronicTerminalIllness",
      "display" : "People with Chronic/Terminal Illness",
      "definition" : "People with Chronic/Terminal Illness"
    },
    {
      "code" : "other-drugAlcohol",
      "display" : "People with Drug and/or Alcohol Issues",
      "definition" : "People with Drug and/or Alcohol Issues"
    }
  ]
}

```
