# Health Connect Reader - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect Reader**

## CapabilityStatement: Health Connect Reader 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-reader | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectReader |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This[CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html)resource defines the expected capabilities of the[Health Connect Reader actor](ActorDefinition-reader-actor-health-connect.md)when conforming to this implementation guide. The complete list of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Reader actor are defined in this CapabilityStatement. The requirements of the HealthConnect Reader actor may also be impacted by the rules of local jurisdictions or other contextual requirements. 

 [Raw OpenAPI-Swagger Definition file](health-connect-reader.openapi.json) | [Download](health-connect-reader.openapi.json) 

## Health Connect Reader

* Implementation Guide Version: 0.1.0-preview 
* FHIR Version: 4.0.1 
* Supported Formats: **SHALL** support `json`, **SHALL** support `xml`
* Published on: 2025-08-12 
* Published by: Australian Digital Health Agency 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: client

**Security**

Enable CORS: no

Security services supported:
`OAuth`

> 

All interactions SHALL be secured using OAuth protocols. It SHALL support authentication, authorisation, and audit logging in accordance with local policy and regulatory requirements.


**Summary of System-wide Interactions**

* Supports the `search-system`interaction described as follows:

**Definition**:

This operation is a RESTful **search** interaction (whole system interaction), across multiple resource types (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)).

**Behaviour**:

This operation is used by a client system operated by a Health Connect reader to get resources that match the specified search parameters. .

The following search parameters are supported:

* **_lastUpdated** is used to get the resources that have been added or changed since the requesting system last synchronised their local data store with Health Connect Reader. This search parameter supports the `gt` and `lt` comparison prefixes.
* **_type** is used to filter the resources returned by their resource type. The available types are:

All of the following query parameters are required in order to receive the complete set of resources that have been created, changed or published to all the subscriber organisation's partner services since **[last_synchronized]**:

`_lastUpdated=[last_synchronized]`

`_type=HealthcareService,PractitionerRole,Practitioner,Organization,Location,Provenance`

`_include=Location:organization`

`_include=HealthcareService:organization`

`_include=HealthcareService:location`

`_include=PractitionerRole:organization`

`_include=PractitionerRole:location`

`_include=PractitionerRole:service`

`_include=PractitionerRole:practitioner`

`_include=Provenance:target`

`_include:iterate=HealthcareService:organization`

`_include:iterate=HealthcareService:location`

`_include:iterate=PractitionerRole:organization`

`_include:iterate=PractitionerRole:location`

`_include:iterate=PractitionerRole:service`

`_include:iterate=PractitionerRole:practitioner`

As described above the resources returned in the Bundle exclude any **Identifiers** (e.g. HPI-Is) that cannot be disclosed to the subscriber.

This operation supports 'paging' ([see FHIR specification](https://www.hl7.org/fhir/search.html#Paging)). If there are too many resources to return in one `Bundle`, the FHIR server adds a **next** link to the response `Bundle`. The contents of the result `Bundle` therefore comprise all instances of the requested resource types whose **lastUpdated** timestamp is greater than the <lastSync> in the request query expression and less than or equal to <lastInBundle> where <lastInBundle> is the greatest **lastUpdated** value of all resources included in the result `Bundle`. The Subscriber Agent FHIR server sets the **next** link to the filter expression that was used in the original request except that <lastSync> is replaced with <lastInBundle>. If the **next** link is not present in the Bundle, then there are no more service offerings available.


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Provenance](#Provenance1-1) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance](StructureDefinition-hc-provenance.md) | y | y |  |  |  |  |  |  |
| [Organization](#Organization1-2) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization](StructureDefinition-hc-organization.md) | y | y |  |  | identifier, name, type | `Organization:partOf` | `Location:organization`,`Provenance:target` |  |
| [Location](#Location1-3) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location](StructureDefinition-hc-location.md) | y | y |  |  | postaladdress, locationamenities, name, address, type | `Location:endpoint` | `HealthcareService:location`,`Provenance:target` |  |
| [HealthcareService](#HealthcareService1-4) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice](StructureDefinition-hc-healthcareservice.md) | y | y |  |  | languages, hsbilling, availability-allday, availability-daysofweek, availability-starttime, availability-endtime, service-type | `HealthcareService:location`,`HealthcareService:providedBy`,`HealthcareService:endpoint` | `PractitionerRole:healthcareService`,`Provenance:target` |  |
| [PractitionerRole](#PractitionerRole1-5) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole](StructureDefinition-hc-practitionerrole.md) | y | y |  |  | languages, availability-allday, availability-daysofweek, availability-starttime, availability-endtime, identifier, roletype, prn | `PractitionerRole:practitioner`,`PractitionerRole:healthcareService`,`PractitionerRole:organization`,`PractitionerRole:location`,`PractitionerRole:endpoint` | `Provenance:target` |  |
| [Practitioner](#Practitioner1-6) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner](StructureDefinition-hc-practitioner.md) |  | y |  |  | identifier, regprof, rsg, gender-identity, practitionername, practitionerpreferredname, prn |  | `PractitionerRole:practitioner`,`Provenance:target` |  |
| [Endpoint](#Endpoint1-7) | [http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint](StructureDefinition-hc-endpoint.md) | y | y |  |  | epurl, payloadmimetype, hcepi, name, connection-type, payload-type |  | `HealthcareService:endpoint`,`Location:endpoint`,`PractitionerRole:endpoint`,`Provenance:target` |  |

-------

#### Resource Conformance: supported Provenance

Base System Profile

[HC Provenance](StructureDefinition-hc-provenance.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports 
`read`

Read HC Provenance records to understand data lineage

`search-type`

Search for HC Provenance records by target resource or activity


Documentation
> 

This resource is used to track the provenance of data retrieved, updated, or verified from external systems of record for HC resources.


#### Resource Conformance: supported Organization

Base System Profile

[HC Organization](StructureDefinition-hc-organization.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`.

Documentation
> 

This section defines the supported interactions for the [HC Organization](StructureDefinition-hc-organization.md) profile of the Organization resource type.


Search Parameters


 

#### Resource Conformance: supported Location

Base System Profile

[HC Location](StructureDefinition-hc-location.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`.

Documentation
> 

This section defines the supported interactions for the [HC Location](StructureDefinition-hc-location.md) profile of the Location resource type. A Location resource conforming to the [HC Location](StructureDefinition-hc-location.md) profile represents a location at which healthcare services are offered by a Health Connect Reader.


Search Parameters


 

#### Resource Conformance: supported HealthcareService

Base System Profile

[HC HealthcareService](StructureDefinition-hc-healthcareservice.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`.

Documentation
> 

This section defines the supported interactions for the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.md) profile. A HealthcareService resource conforming to the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.md) profile describes a healthcare service offered at a location by a Health Connect Reader.


Search Parameters


 

#### Resource Conformance: supported PractitionerRole

Base System Profile

[HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`.

Documentation
> 

This section defines the supported interactions for the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.md) profile of the PractitionerRole resource type. Each PractitionerRole resource conforming to the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.md) profile describes a practitioner in a role at a healthcare service.


Search Parameters


 

#### Resource Conformance: supported Practitioner

Base System Profile

[HC Practitioner](StructureDefinition-hc-practitioner.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `search-type`.

Documentation
> 

This section defines the supported interactions for the [HC Practitioner](StructureDefinition-hc-practitioner.md) profile of the Practitioner resource type.


Search Parameters


 

#### Resource Conformance: supported Endpoint

Base System Profile

[HC Endpoint](StructureDefinition-hc-endpoint.md)

Profile Conformance

**SHALL**

Reference Policy

Interaction summary

* Supports `read`, `search-type`.

Documentation
> 

This section defines the supported interactions for the [HC Endpoint](StructureDefinition-hc-endpoint.md) profile of the Endpoint resource type. Each Endpoint resource conforming the [HC Endpoint](StructureDefinition-hc-endpoint.md) profile is a read-only proxy for a corresponding Endpoint resource managed by the HC portal.


Search Parameters


 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "health-connect-reader",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/CapabilityStatement/health-connect-reader",
  "version" : "0.1.0-preview",
  "name" : "HealthConnectReader",
  "title" : "Health Connect Reader",
  "status" : "draft",
  "date" : "2025-08-12",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This [CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html) resource defines the expected capabilities \nof the [Health Connect Reader actor](ActorDefinition-reader-actor-health-connect.html) when conforming to this implementation guide. The complete \nlist of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Reader actor are defined in this CapabilityStatement. \nThe requirements of the HealthConnect Reader actor may also be impacted by the rules of local jurisdictions or other contextual requirements.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "client",
      "security" : {
        "service" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/restful-security-service",
                "code" : "OAuth",
                "display" : "OAuth"
              }
            ]
          }
        ],
        "description" : "All interactions SHALL be secured using OAuth protocols. It SHALL support authentication, authorisation, and audit logging in accordance with local policy and regulatory requirements."
      },
      "resource" : [
        {
          "type" : "Provenance",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance",
          "documentation" : "This resource is used to track the provenance of data retrieved, updated, or verified from external systems of record for HC resources.",
          "interaction" : [
            {
              "code" : "read",
              "documentation" : "Read HC Provenance records to understand data lineage"
            },
            {
              "code" : "search-type",
              "documentation" : "Search for HC Provenance records by target resource or activity"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported"
        },
        {
          "type" : "Organization",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization",
          "documentation" : "This section defines the supported interactions for the [HC Organization](StructureDefinition-hc-organization.html) profile of the Organization resource type.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchInclude" : ["Organization:partOf"],
          "searchRevInclude" : ["Location:organization", "Provenance:target"],
          "searchParam" : [
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-identifier",
              "type" : "token"
            },
            {
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-name",
              "type" : "string"
            },
            {
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-type",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Location",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location",
          "documentation" : "This section defines the supported interactions for the [HC Location](StructureDefinition-hc-location.html) profile of the Location resource type. A Location resource conforming to the [HC Location](StructureDefinition-hc-location.html) profile represents a location at which healthcare services are offered by a Health Connect Reader.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchInclude" : ["Location:endpoint"],
          "searchRevInclude" : ["HealthcareService:location", "Provenance:target"],
          "searchParam" : [
            {
              "name" : "postaladdress",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-postalAddress",
              "type" : "string"
            },
            {
              "name" : "locationamenities",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/location-amenities",
              "type" : "token"
            },
            {
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-name",
              "type" : "string"
            },
            {
              "name" : "address",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-address",
              "type" : "string"
            },
            {
              "name" : "type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Location-type",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "HealthcareService",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice",
          "documentation" : "This section defines the supported interactions for the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.html) profile. A HealthcareService resource conforming to the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.html) profile describes a healthcare service offered at a location by a Health Connect Reader.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchInclude" : [
            "HealthcareService:location",
            "HealthcareService:providedBy",
            "HealthcareService:endpoint"
          ],
          "searchRevInclude" : ["PractitionerRole:healthcareService", "Provenance:target"],
          "searchParam" : [
            {
              "name" : "languages",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/languages",
              "type" : "string"
            },
            {
              "name" : "hsbilling",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/healthcareservice-billing",
              "type" : "token"
            },
            {
              "name" : "availability-allday",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-allday",
              "type" : "token"
            },
            {
              "name" : "availability-daysofweek",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-daysofweek",
              "type" : "token"
            },
            {
              "name" : "availability-starttime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-starttime",
              "type" : "string"
            },
            {
              "name" : "availability-endtime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-endtime",
              "type" : "string"
            },
            {
              "name" : "service-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/HealthcareService-service-type",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "PractitionerRole",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole",
          "documentation" : "This section defines the supported interactions for the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile of the PractitionerRole resource type. Each PractitionerRole resource conforming to the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile describes a practitioner in a role at a healthcare service.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchInclude" : [
            "PractitionerRole:practitioner",
            "PractitionerRole:healthcareService",
            "PractitionerRole:organization",
            "PractitionerRole:location",
            "PractitionerRole:endpoint"
          ],
          "searchRevInclude" : ["Provenance:target"],
          "searchParam" : [
            {
              "name" : "languages",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/languages",
              "type" : "string"
            },
            {
              "name" : "availability-allday",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-allday",
              "type" : "token"
            },
            {
              "name" : "availability-daysofweek",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-daysofweek",
              "type" : "token"
            },
            {
              "name" : "availability-starttime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-starttime",
              "type" : "string"
            },
            {
              "name" : "availability-endtime",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/availability-endtime",
              "type" : "string"
            },
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier",
              "type" : "token"
            },
            {
              "name" : "roletype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitionerrole-roletype",
              "type" : "string"
            },
            {
              "name" : "prn",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/ProfessionalRegistrationNumber",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Practitioner",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner",
          "documentation" : "This section defines the supported interactions for the [HC Practitioner](StructureDefinition-hc-practitioner.html) profile of the Practitioner resource type.",
          "interaction" : [
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchRevInclude" : ["PractitionerRole:practitioner", "Provenance:target"],
          "searchParam" : [
            {
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-identifier",
              "type" : "token"
            },
            {
              "name" : "regprof",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-regprof",
              "type" : "string"
            },
            {
              "name" : "rsg",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-rsg",
              "type" : "token"
            },
            {
              "name" : "gender-identity",
              "definition" : "http://hl7.org.au/fhir/SearchParameter/gender-identity",
              "type" : "token"
            },
            {
              "name" : "practitionername",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-officialname",
              "type" : "string"
            },
            {
              "name" : "practitionerpreferredname",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/practitioner-preferredname",
              "type" : "string"
            },
            {
              "name" : "prn",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/ProfessionalRegistrationNumber",
              "type" : "token"
            }
          ]
        },
        {
          "type" : "Endpoint",
          "profile" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint",
          "documentation" : "This section defines the supported interactions for the [HC Endpoint](StructureDefinition-hc-endpoint.html) profile of the Endpoint resource type. Each Endpoint resource conforming the [HC Endpoint](StructureDefinition-hc-endpoint.html) profile is a read-only proxy for a corresponding Endpoint resource managed by the HC portal.",
          "interaction" : [
            {
              "code" : "read"
            },
            {
              "code" : "search-type"
            }
          ],
          "versioning" : "versioned",
          "readHistory" : false,
          "updateCreate" : false,
          "conditionalCreate" : false,
          "conditionalRead" : "not-supported",
          "conditionalUpdate" : false,
          "conditionalDelete" : "not-supported",
          "searchRevInclude" : [
            "HealthcareService:endpoint",
            "Location:endpoint",
            "PractitionerRole:endpoint",
            "Provenance:target"
          ],
          "searchParam" : [
            {
              "name" : "epurl",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-url",
              "type" : "uri"
            },
            {
              "name" : "payloadmimetype",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-payloadmimetype",
              "type" : "token"
            },
            {
              "name" : "hcepi",
              "definition" : "http://ns.electronichealth.net.au/hc/SearchParameter/endpoint-hcepi",
              "type" : "string"
            },
            {
              "name" : "name",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-name",
              "type" : "string"
            },
            {
              "name" : "connection-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-connection-type",
              "type" : "token"
            },
            {
              "name" : "payload-type",
              "definition" : "http://hl7.org/fhir/SearchParameter/Endpoint-payload-type",
              "type" : "token"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "code" : "search-system",
          "documentation" : "**Definition**:\r\n    \n This operation is a RESTful *search* interaction (whole system interaction), across multiple resource types (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)). \r\n    \n\r\n    \n **Behaviour**:\r\n    \n This operation is used by a client system operated by a Health Connect reader to get resources that match the specified search parameters. .\r\n    \n\r\n    \n The following  search parameters are supported:\r\n    \n\r\n    \n * *_lastUpdated* is used to get the resources that have been added or changed since the requesting system last synchronised their local data store with Health Connect Reader.  This search parameter supports the ```gt``` and ```lt``` comparison prefixes.\r\n    \n * *_type* is used to filter the resources returned by their resource type. The available types are: \r\n    \n\r\n    \n   * ```HealthcareService``` (returns resources conforming to the [HC Healthcare Service](StructureDefinition-hc-healthcareservice.html) profile)\r\n    \n   * ```PractitionerRole``` (returns resources conforming to the [HC Practitioner Role](StructureDefinition-hc-practitionerrole.html) profile)\r\n    \n   * ```Organization``` (returns resources conforming to the [HC Organization](StructureDefinition-hc-organization.html) profile)\r\n    \n   * ```Location``` (returns resources conforming to the [HC Location](StructureDefinition-hc-location.html) profile)\r\n    \n   * ```Practitioner``` (returns resources conforming to the [HC Practitioner](StructureDefinition-hc-practitioner.html) profile)\r\n    \n   * ```Provenance``` (returns resources conforming to the [HC Provenance](StructureDefinition-hc-provenance.html) profile)\r\n    \n   \r\n    \n \r\n    \n All of the following query parameters are required in order to receive the complete set of resources that have been created, changed or published to all the subscriber organisation's partner services since *[last_synchronized]*:\r\n    \n\r\n    \n ``` _lastUpdated=[last_synchronized] ```\r\n    \n ```_type=HealthcareService,PractitionerRole,Practitioner,Organization,Location,Provenance ```\r\n    \n ```_include=Location:organization ```\r\n    \n ```_include=HealthcareService:organization ```\r\n    \n ```_include=HealthcareService:location ```\r\n    \n ```_include=PractitionerRole:organization ```\r\n    \n ```_include=PractitionerRole:location ```  \r\n    \n ```_include=PractitionerRole:service ```\r\n    \n ```_include=PractitionerRole:practitioner ``` \r\n    \n ```_include=Provenance:target ```   \r\n    \n ```_include:iterate=HealthcareService:organization  ```  \r\n    \n ```_include:iterate=HealthcareService:location ```\r\n    \n ```_include:iterate=PractitionerRole:organization ```\r\n    \n ```_include:iterate=PractitionerRole:location ```\r\n    \n ```_include:iterate=PractitionerRole:service ```\r\n    \n ```_include:iterate=PractitionerRole:practitioner ```\r\n    \n \r\n    \n As described above the resources returned in the Bundle exclude any *Identifiers* (e.g. HPI-Is) that cannot be disclosed to the subscriber.\r\n    \n \r\n    \n This operation supports 'paging' ([see FHIR specification](https://www.hl7.org/fhir/search.html#Paging)).  If there are too many resources to return in one ```Bundle```, the FHIR server adds a *next* link to the response ```Bundle```. The contents of the result ```Bundle``` therefore comprise all instances of the requested resource types whose *lastUpdated* timestamp is greater than the <lastSync> in the request query expression and less than or equal to <lastInBundle> where <lastInBundle> is the greatest *lastUpdated* value of all resources included in the result ```Bundle```. The Subscriber Agent FHIR server sets the *next* link to the filter expression that was used in the original request except that <lastSync> is replaced with <lastInBundle>. If the *next* link is not present in the Bundle, then there are no more service offerings available.    "
        }
      ],
      "searchParam" : [
        {
          "name" : "_lastUpdated",
          "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated",
          "type" : "date"
        },
        {
          "name" : "_type",
          "type" : "token"
        },
        {
          "name" : "_include",
          "type" : "special"
        },
        {
          "name" : "_resultId",
          "type" : "special"
        }
      ]
    }
  ]
}

```
