# Home - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect | *Version*:0.1.0-preview |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

# Health Connect FHIR ImplementationGuide

> This material is under active development and content may be added or updated on a regular basis.

ADHA review feedback

We welcome your feedback on this implementation guide.

To contribute directly to this implementation guide with code changes or documentation updates, please fork the repository and submit a pull request.

For technical FHIR-related comments, implementation feedback, or suggestions for profile improvements, you can create a GitHub issue.

For feedback concerning design considerations, business requirements, or broader implementation strategy, please [contact the Clininical Informatics team](mailto:informatics@digitalhealth.gov.au).

### Introduction

Health Connect Australia is a national health information exchange program designed to enable the sharing of health information between healthcare participants quickly and securely. By integrating advanced digital infrastructure, standards, privacy protections and enabling real-time data sharing, Health Connect Australia will support multidisciplinary collaboration across care settings. As a key enabler of the [National Digital Health Strategy 2023–2028](https://www.digitalhealth.gov.au/national-digital-health-strategy) and the [National Healthcare Interoperability Plan 2023-2028](https://www.digitalhealth.gov.au/about-us/strategies-and-plans/national-healthcare-interoperability-plan), it ensures secure, connected digital solutions that improve access, efficiency and care quality—paving the way for a smarter, more integrated future in digital health. The program is being delivered in phases, beginning with foundational capabilities and expanding to support secure communication, record discovery, and value-added services for both providers and consumers.

The Directory and Authorisation Service Project is the first initiative under the Foundations phase. It enables healthcare providers to discover accurate, up-to-date information about other providers and the services they offer, while establishing a trust framework to support consistent and secure access to health information. By connecting provider data from multiple primary sources through a single access point and ensuring near real-time updates, the project lays the groundwork for broader interoperability and trusted information exchange across the national health ecosystem.

One of the key objectives of the Directory and Authorisation Service Project is to enable interoperability through contemporary standards—such as FHIR APIs—to ensure seamless integration across clinical and administrative systems. To support this, the project is establishing a centralised directory hosted on a FHIR repository, where provider and organisation data will be structured using HL7® FHIR® and terminology standards. To guide consistent implementation and promote national alignment, the project is developing a FHIR Implementation Guide that defines how provider information should be represented and exchanged. This guide will build on existing standards, including the HL7 Australia Provider Directory FHIR IG, and provide a clear reference for integrators and system vendors to support secure, scalable, and standards-compliant access to directory data.

### How to read this guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for the implementation guide.
* [FHIR Artefacts](artifacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Profiles and Extensions](profiles-and-extensions.md): This page lists the FHIR profiles and extensions that are defined in this guide.
* [Terminology](terminology.md): This page lists the FHIR terminology that are defined in this guide.
* [Search Parameters](artifacts.md#behavior-search-parameters): This page lists the FHIR search parameters that are defined in this guide.
* [Capability Statements](capability-statements.md): This page defines the expected FHIR capabilities of Health Connect Reader.
* [Actor Definitions](actors.md): This page defines the Health Connect actors, Health Connect Reader.
 
* [Conformance](conformance.md): This page describes the set of rules to claim conformance to this guide including Capability Statements and Actor definitions.
* [Examples](examples.md): This page lists the sample instances of FHIR resources conforming to the FHIR profiles.
* [Disclaimers](disclaimers.md): This page lists the licensing, copyright, and disclaimers under which this guide is issued.
* [Downloads](downloads.md): This page provides links to downloadable artefacts including the Agency FHIR NPM package.

### Document purpose and scope

The primary aim of this implementation guide is to support implementers integrating with the Directory services using [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4). It provides the technical specifications, FHIR profiles, and terminology definitions required for healthcare provider data exchange through Health Connect APIs.

This document describes specific system behaviours such as obligations, API HTTP response codes, and search parameters. Other system behavioural requirements such as the presentation of information and user experience are managed separately and must be met before systems can be assessed for conformance and granted access to Health Connect APIs.

Reference has been made to International and Australian Standards, and to Standards from HL7. The following standards are referred to in the text in such a way that some or all of its content constitutes requirements for the purposes of this specification:

* [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4)
* [Australian Base Profiles Implementation Guide [HL7AUBIG]](#HL7AUBIG)
* [Australian Core Profiles Implementation Guide [HL7AUCIG]](#HL7AUCIG)

Wherever possible, material in this specification is based on existing standards. All efforts have been made to minimise divergence from the HL7 Australia profiles of HL7 International standards ([Australian Core Profiles Implementation Guide [HL7AUCIG]](#HL7AUCIG) and [Australian Base Profiles Implementation Guide [HL7AUBIG]](#HL7AUBIG)) to provide for system interoperability and compatibility with other profiles. Issues of an editorial nature in the source material (such as spelling or punctuation errors) are intentionally reproduced. For a list of known issues (see below).

### Intended audience

This implementation guide is aimed at software development teams, architects, and designers that integrate with the Health Connect service.

This implementation guide and related artefacts are technical in nature and the audience is expected to be familiar with the language of health data specifications and to have some familiarity with health information standards and specifications, such as FHIR.

### Relationships with other work

This implementation guide builds on other specifications, helping ensure a consistent approach to data sharing that should ease adoption. The specific guides used, and the portions relevant from each of them are as follows:

### Cross version analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (au.digitalhealth.r4.healthconnect.r4)](package.r4.tgz) and [R4B (au.digitalhealth.r4.healthconnect.r4b)](package.r4b.tgz) are available.

### Global profiles

*There are no Global profiles defined*

### Data model overview

The Health Connect Australia Provider Directory uses FHIR resources to represent healthcare providers, their roles, organisational affiliations, service locations, and the healthcare services they provide. The diagram below illustrates the key relationships between these FHIR resources:

* Practitioner - Individual healthcare providers with their professional qualifications and identifiers
* Organization - Healthcare organisations and facilities that employ or affiliate with practitioners
* HealthcareService - Specific services offered by organisations at locations
* Location - Physical or virtual locations where healthcare services are delivered
* Endpoint - Technical endpoints for digital service integration and communication

This model supports complex healthcare delivery scenarios while maintaining FHIR R4 compliance and enabling efficient provider directory searches and integrations.

### Intellectual property considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).This resource includes material that is based on Australian Institute of Health and Welfare material.All copies of this resource must include this copyright statement and all information contained in this statement.

* [Australian States and Territories](https://tx.ontoserver.csiro.au/fhir/ValueSet/australian-states-territories-1): [HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)](https://creativecommons.org/licenses/by/4.0/) 

* [HC Amenity CodeSystem](CodeSystem-HCAmenity-cs.md): [HCAmenity](StructureDefinition-hc-amenity.md), [HCAmenityVs](ValueSet-HCAmenityVs.md) and [Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)
* [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md): [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md), [HCEndpoint](StructureDefinition-hc-endpoint.md) and [Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* [HC IAR Levels of Care CodeSystem](CodeSystem-hc-iar-levels-of-care.md): [HcIarLevelsOfCareExtension](StructureDefinition-hc-iar-levels-of-care.md), [HcIarLevelsOfCareVs](ValueSet-hc-iar-levels-of-care-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md): [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md), [HCHSPOIdentifier](StructureDefinition-hc-hspo.md), [HcOrgClassVS](ValueSet-hc-org-classification-vs.md) and [HcOrgClassification](StructureDefinition-hc-org-classification.md)
* [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md): [HCEndpoint](StructureDefinition-hc-endpoint.md) and [HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).

* [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md) and [HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md)


* HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.

* [Location Type AU](http://hl7.org.au/fhir/6.0.0-ballot/CodeSystem-au-location-type.html): [HCLocation](StructureDefinition-hc-location.md), [HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md) and [Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)
* [Service Provision Conditions Australian Concepts](http://hl7.org.au/fhir/6.0.0-ballot/CodeSystem-service-provision-conditions.html): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [IdentifierType AU](http://hl7.org.au/fhir/6.0.0-ballot/CodeSystem-au-v2-0203.html): [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md), [HCHPIOIdentifier](StructureDefinition-hc-hpio.md)...Show 4 more,[Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md),[Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md),[PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md)and[Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AustralianEndpointPayloadTypesCodeSystem](CodeSystem-hc-endpoint-payload-type-cs.md), [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)...Show 57 more,[HCAcceptNewPatient](StructureDefinition-hc-accept-new-patient.md),[HCAmenity](StructureDefinition-hc-amenity.md),[HCAmenityCs](CodeSystem-HCAmenity-cs.md),[HCAmenityVs](ValueSet-HCAmenityVs.md),[HCEndpoint](StructureDefinition-hc-endpoint.md),[HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md),[HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md),[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[HCHealthcareService](StructureDefinition-hc-healthcareservice.md),[HCLocation](StructureDefinition-hc-location.md),[HCOrganization](StructureDefinition-hc-organization.md),[HCPractitioner](StructureDefinition-hc-practitioner.md),[HCPractitionerRole](StructureDefinition-hc-practitionerrole.md),[HCPreferredPostalAddress](StructureDefinition-hc-preferred-postal-address.md),[HCProfessionalRegistrationNumber](StructureDefinition-hc-prn.md),[HCProvenance](StructureDefinition-hc-provenance.md),[HCSMDTargetIdentifier](StructureDefinition-hc-smd-target-identifier.md),[HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md),[HCServiceEligibilityCodeSystem](CodeSystem-hc-service-eligibility-cs.md),[HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md),[HCServiceInterfaceCodeSystem](CodeSystem-hc-service-interfaces-cs.md),[HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md),[HCServiceProvisionCodeCodeSystem](CodeSystem-hc-service-provision-code-cs.md),[HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md),[HcActivePeriod](StructureDefinition-hc-active-period.md),[HcIarLevelsOfCareCs](CodeSystem-hc-iar-levels-of-care.md),[HcIarLevelsOfCareExtension](StructureDefinition-hc-iar-levels-of-care.md),[HcIarLevelsOfCareVs](ValueSet-hc-iar-levels-of-care-vs.md),[HcOrgClassCS](CodeSystem-hc-org-classification-cs.md),[HcOrgClassVS](ValueSet-hc-org-classification-vs.md),[HcOrgClassification](StructureDefinition-hc-org-classification.md),[HcPractitionerRoleCommunication](StructureDefinition-hc-practitioner-role-communication.md),[HcPreferredName](StructureDefinition-hc-preferred-name.md),[HcReferralInformationForReferrer](StructureDefinition-hc-referral-information-for-referrer.md),[HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md),[HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide](index.md),[HealthConnectReader](CapabilityStatement-health-connect-reader.md),[PCAHealthcareServiceIdentifier](StructureDefinition-pca-hsi.md),[ReaderActorHealthConnect](ActorDefinition-reader-actor-health-connect.md),[SearchParameterAvailabilityAllDay](SearchParameter-availability-allday.md),[SearchParameterAvailabilityDaysOfWeek](SearchParameter-availability-daysofweek.md),[SearchParameterAvailabilityEndTime](SearchParameter-availability-endtime.md),[SearchParameterAvailabilityStartTime](SearchParameter-availability-starttime.md),[SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md),[SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md),[SearchParameterEndpointUrl](SearchParameter-endpoint-url.md),[SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md),[SearchParameterLanguages](SearchParameter-languages.md),[SearchParameterLocationAmenities](SearchParameter-location-amenities.md),[SearchParameterLocationPostalAddress](SearchParameter-location-postalAddress.md),[SearchParameterPractitionerOfficialName](SearchParameter-practitioner-officialname.md),[SearchParameterPractitionerPreferredname](SearchParameter-practitioner-preferredname.md),[SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md),[SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md),[SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)and[SearchParameterProfessionalRegistrationNumber](SearchParameter-ProfessionalRegistrationNumber.md)


* This code system is a clone of the PCA Service Eligibility CodeSystem. Copyright © Australian Digital Health Agency.

* [HC Service Eligibility CodeSystem](CodeSystem-hc-service-eligibility-cs.md): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md), [Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md), [Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md) and [PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [UsageContextType](http://terminology.hl7.org/7.0.0/CodeSystem-usage-context-type.html): [AustralianEndpointPayloadTypesCodeSystem](CodeSystem-hc-endpoint-payload-type-cs.md), [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)...Show 57 more,[HCAcceptNewPatient](StructureDefinition-hc-accept-new-patient.md),[HCAmenity](StructureDefinition-hc-amenity.md),[HCAmenityCs](CodeSystem-HCAmenity-cs.md),[HCAmenityVs](ValueSet-HCAmenityVs.md),[HCEndpoint](StructureDefinition-hc-endpoint.md),[HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md),[HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md),[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[HCHealthcareService](StructureDefinition-hc-healthcareservice.md),[HCLocation](StructureDefinition-hc-location.md),[HCOrganization](StructureDefinition-hc-organization.md),[HCPractitioner](StructureDefinition-hc-practitioner.md),[HCPractitionerRole](StructureDefinition-hc-practitionerrole.md),[HCPreferredPostalAddress](StructureDefinition-hc-preferred-postal-address.md),[HCProfessionalRegistrationNumber](StructureDefinition-hc-prn.md),[HCProvenance](StructureDefinition-hc-provenance.md),[HCSMDTargetIdentifier](StructureDefinition-hc-smd-target-identifier.md),[HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md),[HCServiceEligibilityCodeSystem](CodeSystem-hc-service-eligibility-cs.md),[HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md),[HCServiceInterfaceCodeSystem](CodeSystem-hc-service-interfaces-cs.md),[HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md),[HCServiceProvisionCodeCodeSystem](CodeSystem-hc-service-provision-code-cs.md),[HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md),[HcActivePeriod](StructureDefinition-hc-active-period.md),[HcIarLevelsOfCareCs](CodeSystem-hc-iar-levels-of-care.md),[HcIarLevelsOfCareExtension](StructureDefinition-hc-iar-levels-of-care.md),[HcIarLevelsOfCareVs](ValueSet-hc-iar-levels-of-care-vs.md),[HcOrgClassCS](CodeSystem-hc-org-classification-cs.md),[HcOrgClassVS](ValueSet-hc-org-classification-vs.md),[HcOrgClassification](StructureDefinition-hc-org-classification.md),[HcPractitionerRoleCommunication](StructureDefinition-hc-practitioner-role-communication.md),[HcPreferredName](StructureDefinition-hc-preferred-name.md),[HcReferralInformationForReferrer](StructureDefinition-hc-referral-information-for-referrer.md),[HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md),[HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide](index.md),[HealthConnectReader](CapabilityStatement-health-connect-reader.md),[PCAHealthcareServiceIdentifier](StructureDefinition-pca-hsi.md),[ReaderActorHealthConnect](ActorDefinition-reader-actor-health-connect.md),[SearchParameterAvailabilityAllDay](SearchParameter-availability-allday.md),[SearchParameterAvailabilityDaysOfWeek](SearchParameter-availability-daysofweek.md),[SearchParameterAvailabilityEndTime](SearchParameter-availability-endtime.md),[SearchParameterAvailabilityStartTime](SearchParameter-availability-starttime.md),[SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md),[SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md),[SearchParameterEndpointUrl](SearchParameter-endpoint-url.md),[SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md),[SearchParameterLanguages](SearchParameter-languages.md),[SearchParameterLocationAmenities](SearchParameter-location-amenities.md),[SearchParameterLocationPostalAddress](SearchParameter-location-postalAddress.md),[SearchParameterPractitionerOfficialName](SearchParameter-practitioner-officialname.md),[SearchParameterPractitionerPreferredname](SearchParameter-practitioner-preferredname.md),[SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md),[SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md),[SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)and[SearchParameterProfessionalRegistrationNumber](SearchParameter-ProfessionalRegistrationNumber.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md), [HCHSPOIdentifier](StructureDefinition-hc-hspo.md)...Show 4 more,[HCProfessionalRegistrationNumber](StructureDefinition-hc-prn.md),[Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md),[Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md)and[Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [DataOperation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-DataOperation.html): [HCProvenance](StructureDefinition-hc-provenance.md), [Provenance/provenance-practitioner-name-update](Provenance-provenance-practitioner-name-update.md) and [Provenance/provenance-practitioner-phone-update](Provenance-provenance-practitioner-phone-update.md)
* [DocumentCompletion](http://terminology.hl7.org/7.0.0/CodeSystem-v3-DocumentCompletion.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md) and [HCPractitioner](StructureDefinition-hc-practitioner.md)
* [ParticipationType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationType.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [RoleCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-RoleCode.html): [HCLocation](StructureDefinition-hc-location.md), [HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md) and [Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)


### Known issues

This table lists known issues with this specification at the time of publishing. We are working on solutions to these issues and encourage comments to help us develop these solutions.

* Reference: Example system URI
  * Description: An inherited example system (e.g.`http://www.acme.com/identifiers/patient`) erroneously infers patient context. Implementers must use their own namespace URIs. The affected identifier profile is Endpoint (HC-EPI) — this profile includes the erroneous example `system` in their documentation.

### References

| | |
| :--- | :--- |
| [HL7AUBIG] | HL7 Australia, FHIR R4 standard for AU Base Implementation Guide, v6.0.0-ballot (Ballot) |
|   | [https://hl7.org.au/fhir/6.0.0-ballot/index.html](https://hl7.org.au/fhir/6.0.0-ballot/index.html) |

| | |
| :--- | :--- |
| [HL7FHIR4] | Health Level Seven, Inc., 30 October 2019, FHIR R4. |
|   | [http://hl7.org/fhir/R4/](http://hl7.org/fhir/R4/) |

| | |
| :--- | :--- |
| [HL7AUCIG] | HL7 Australia, FHIR R4 standard for AU Core Implementation Guide, v2.0.0-ballot - Ballot (Ballot) |
|   | [https://hl7.org.au/fhir/core/2.0.0-ballot/index.html](https://hl7.org.au/fhir/core/2.0.0-ballot/index.html) |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

