# HC Service Coverage Area - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Service Coverage Area**

## Resource Profile: HC Service Coverage Area 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-service-coverage-area | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCServiceCoverageArea |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. | |

 
This profile of Location represents an Australian geographic coverage area i.e. postcodes where this service is provided. For a healthcare service, that is provided through a physical location but have eligibility restrictions applicable in terms of only residents for certain postcodes/suburbs can receive this service, then the details of coverage area and eligibility should be provided here. 

No data is entered directly into Health Connect; all directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### Service coverage area in Health Connect

The address that defines the coverage area where the service is available is represented by this profile. The HC Service Coverage Area profile is applied to FHIR Location resources to describe an Australian geographic area (postcode, suburb, or region) in which a healthcare service is available.

This profile is referenced by the [HC HealthcareService](StructureDefinition-hc-healthcareservice.md) profile via the `coverageArea` element, allowing each healthcare service to specify one or more geographic areas where the service is offered. It may also be referenced by other profiles that need to describe service eligibility or restrictions based on geography.

### Usage notes

The coverage area that a service is intended for/available to can be represented as one or more instances of Location, where the address elements are populated depending on the type of coverage area to be defined.

To define an Australia-wide coverage area, only the following element shall be populated:

* address.country

To define a coverage area for a particular state, the following elements should be populated in addition to address.country:

* address.state

To define a coverage area for a particular suburb, the following elements should be populated in addition to address.country:

* address.city
* address.postalCode
* address.state

**Usages:**

* Refer to this Profile: [HC HealthcareService](StructureDefinition-hc-healthcareservice.md)
* Examples for this Profile: [Location/example-healthconnect-Location-service-coverage-area](Location-example-healthconnect-Location-service-coverage-area.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-service-coverage-area)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-service-coverage-area.csv), [Excel](StructureDefinition-hc-service-coverage-area.xlsx), [Schematron](StructureDefinition-hc-service-coverage-area.sch) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-service-coverage-area",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-service-coverage-area",
  "version" : "0.1.0-preview",
  "name" : "HCServiceCoverageArea",
  "title" : "HC Service Coverage Area",
  "status" : "draft",
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile of Location represents an Australian geographic coverage area i.e. postcodes where this service is provided.\nFor a healthcare service, that is provided through a physical location but have eligibility restrictions applicable in terms of only residents for certain postcodes/suburbs can receive this service, then the details of coverage area and eligibility should be provided here.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "short" : "Australian geographic area in which a service is available.",
        "constraint" : [
          {
            "key" : "hc-postal-code-4-digits",
            "severity" : "error",
            "human" : "If present, postalCode shall be 4 digits",
            "expression" : "address.postalCode.matches('^[0-9]{4}$')",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-service-coverage-area"
          }
        ]
      },
      {
        "id" : "Location.address",
        "path" : "Location.address",
        "short" : "The address that defines the coverage area where the service is available",
        "min" : 1
      },
      {
        "id" : "Location.address.city",
        "path" : "Location.address.city",
        "short" : "Australian city, town or suburb",
        "definition" : "An Australian city, town or suburb where the service is available.",
        "mustSupport" : true
      },
      {
        "id" : "Location.address.state",
        "path" : "Location.address.state",
        "short" : "Australian state or territory",
        "definition" : "An Australian state or territory where the service is available.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2"
        }
      },
      {
        "id" : "Location.address.postalCode",
        "path" : "Location.address.postalCode",
        "mustSupport" : true
      },
      {
        "id" : "Location.address.country",
        "path" : "Location.address.country",
        "short" : "Australia as a 2 digit ISO 3166 code",
        "definition" : "The 2 digit ISO 3166 code for Australia (AU).",
        "min" : 1,
        "patternString" : "AU",
        "mustSupport" : true
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization"
            ]
          }
        ]
      }
    ]
  }
}

```
