# HC Provenance - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Provenance**

## Resource Profile: HC Provenance 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCProvenance |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/. | |

 
This profile of Provenance is used to record an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record. 

**Note:** All elements defined within this profile are expected to be supported by implementing systems unless explicitly stated otherwise. The following sections provide additional guidance and exceptions for specific elements.

No data is entered directly into Health Connect; all directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### Extensions

Extensions introduced in this profile:

* Provenance.target: [Target path](http://hl7.org/fhir/extensions/StructureDefinition-targetPath.html)

### Usage notes

The guidance below is organised by system role to clarify the different responsibilities for systems that create provenance records versus those that consume them.

#### Provenance resource utilisation patterns

The HC Provenance profile supports two distinct patterns of use:

**Resource-level provenance** tracks changes to an entire FHIR resource. In this pattern:

* The `target` element references the complete resource that was created, updated, or verified (constrained to HC profile types: HCOrganization, HCPractitioner, etc.)
* The `activity` element categorizes the type of operation using codes from the Provenance Activity Type value set (CREATE, UPDATE, DELETE, VERIFY, etc.)
* The `recorded` element provides a timestamp indicating when the provenance event was recorded by the source system
* The `agent.who` element identifies the actor (organization, practitioner, or system) responsible for performing the activity
* The `entity` element, when present, references source records or systems that provided the data, with entity.role typically set to "source"

**Atomic element-level provenance** tracks changes to specific data elements within a resource. This more granular approach uses the [Target path](http://hl7.org/fhir/extensions/StructureDefinition-targetPath.html) extension (introduced in this profile) to enable precise tracking:

* The `target` element to reference the resource containing the changed elements
* The `target.extension[targetPath]` to specify exactly which data elements were affected using FHIRPath expressions, enabling atomic-level tracking
* Multiple targetPath extensions can be included to track changes to multiple elements in a single provenance record
* The same `activity`, `recorded`, `agent.who`, and `entity` elements as resource-level provenance

The atomic element-level approach is particularly valuable in Health Connect's context where directory data may be selectively updated from different authoritative sources. For example, a practitioner's contact details might be updated from one source while their qualifications are verified from another, with separate provenance records documenting each specific change.

#### Systems creating/updating Provenance resources (connecting systems)

* The `target` element MUST reference the HC FHIR resource that is the subject of the provenance activity (for example `HCPractitioner` or `HCOrganization`).
* The `agent.who` element MUST be populated to indicate the actor performing the activity (for example `HCOrganization`, `HCPractitioner` or `HCPractitionerRole`). When the source system records an action performed on behalf of a participating organisation, use `agent.who` = Reference(HCOrganization).
* The `activity` element SHOULD be populated with codes from `http://terminology.hl7.org/CodeSystem/v3-DataOperation` (for example `#UPDATE`, `#CREATE`, `#DELETE`). Use the most specific operation that matches the action taken.
* Implementing systems **must** ensure that the `recorded` element of the Provenance resource is populated with the date and time the update occurred.
* The system performing the update is responsible for accurately setting this value at the time of the update.
* This requirement supports traceability and auditability of changes within Health Connect implementations.
* The purpose of `target.extension[targetPath].valueString` is to hold a FHIRPath expression that identifies the exact data element within the target resource that was changed. It MUST contain a valid FHIRPath expression. Examples in this repository illustrate the expected format, for example: 
* `name[0].family` (tracks the practitioner's primary family name)
* `telecom.where(system='phone').value` (tracks the practitioner's phone number)
 
* It is the responsibility of the updating system to record and capture FHIRPath expressions for the changed data elements.

#### Systems consuming/auditing Provenance resources (searching systems)

* Systems that query or audit Provenance resources can use the FHIRPath expressions in `target.extension[targetPath].valueString` to identify the exact data elements that were changed.
* When building reconciliation tools or audit trails, these FHIRPath expressions reference the changed elements in the target resource. For example, if a provenance record contains `target.extension[targetPath].valueString` = "telecom.where(system='phone').value", the consuming system knows that the practitioner's phone number was updated, and can use this path to highlight the specific changed field in an audit report.
* Note that the FHIRPath identifies which field changed but does not contain the actual values (old or new)
* To see the current value, the consuming system would need to evaluate the FHIRPath against the current target resource.
* When processing audit trails, ensure that FHIRPath expressions are valid and can be successfully evaluated against the referenced target resource.

##### Search include parameters

This implementation supports the following `_include` parameters when searching for Provenance resources:

* `_include=Provenance:target` - Include the target resources (Organization, Location, HealthcareService, PractitionerRole, Practitioner, or Endpoint) that this Provenance resource tracks

##### Example usage

```
GET /Provenance?agent.who=Organization/12345&_include=Provenance:target

```

This query searches for all provenance records where Organization/12345 was the agent performing the activity, and includes the actual resources (practitioners, locations, etc.) whose changes are documented by these provenance records.

**Usages:**

* Examples for this Profile: [Provenance/provenance-practitioner-name-update](Provenance-provenance-practitioner-name-update.md) and [Provenance/provenance-practitioner-phone-update](Provenance-provenance-practitioner-phone-update.md)
* CapabilityStatements using this Profile: [Health Connect Reader](CapabilityStatement-health-connect-reader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-provenance)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-provenance.csv), [Excel](StructureDefinition-hc-provenance.xlsx), [Schematron](StructureDefinition-hc-provenance.sch) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-provenance",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance",
  "version" : "0.1.0-preview",
  "name" : "HCProvenance",
  "title" : "HC Provenance",
  "status" : "draft",
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile of Provenance is used to record an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See https://creativecommons.org/licenses/by/4.0/.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "fhirauditevent",
      "uri" : "http://hl7.org/fhir/auditevent",
      "name" : "FHIR AuditEvent Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Provenance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Provenance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Provenance",
        "path" : "Provenance",
        "short" : "Records an activity where specific data elements of a resource were retrieved/updated/verified from an external system of record",
        "definition" : "Records an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record."
      },
      {
        "id" : "Provenance.target",
        "path" : "Provenance.target",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.target.extension:targetPath",
        "path" : "Provenance.target.extension",
        "sliceName" : "targetPath",
        "short" : "FHIRPath of element(s) in the target resource affected by this provenance activity",
        "definition" : "Specifies one or more FHIRPath expressions pointing to the exact data element(s) within the referenced target resource that were sourced / updated / verified in this provenance event.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/targetPath"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.target.extension:targetPath.value[x]",
        "path" : "Provenance.target.extension.value[x]",
        "example" : [
          {
            "label" : "Example",
            "valueString" : "telecom.where(system='phone').value"
          }
        ]
      },
      {
        "id" : "Provenance.recorded",
        "path" : "Provenance.recorded",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.activity",
        "path" : "Provenance.activity",
        "short" : "Type of provenance activity (e.g. create, update, verify)",
        "definition" : "Categorises the provenance event. Required and bound to the Provenance Activity Type value set.",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/provenance-activity-type"
        }
      },
      {
        "id" : "Provenance.agent.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner",
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.entity",
        "path" : "Provenance.entity",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.entity.role",
        "path" : "Provenance.entity.role",
        "patternCode" : "source",
        "mustSupport" : true
      }
    ]
  }
}

```
