# HC Location - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Location**

## Resource Profile: HC Location 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCLocation |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This profile defines a healthcare location (can also be referred as 'location') reflects the place, a site of care i.e. a practice, clinic, hospital, or facility at which healthcare services are provided by the healthcare organisation. The healthcare location can be a physical, mobile, or virtual location. In certain cases, a healthcare location can also represent a site of care within the hospital or building premises such as consulting room, operating room, outpatient room, unit, ward (e.g. maternity ward), department (e.g. emergency department) etc. 

No data is entered directly into Health Connect; all directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

**Note:** All elements defined within this profile are expected to be supported by implementing systems unless explicitly stated otherwise. The following sections provide additional guidance and exceptions for specific elements.

### Extensions

Extensions introduced in this profile:

* Location: [HC Amenity](StructureDefinition-hc-amenity.md)
* Location: [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md)

### Usage notes

* The [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md) extension is used to carry a separate address that is different to the registered address for the location.

Publishing guidance:

A HC Location resource may also have additional identifiers specific to other business partners, and their identifier systems may or may not match other identifier slices defined in [AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html).

#### Type

The usage notes of the AU Base Location profile provide guidance for Locations that may form part of defining a mobile or remotely delivered service. The HC Location profile formalises this guidance as mandatory requirements (via invariants). The requirements are summarised below:

A HC Location for a mobile service **shall** have:

* type=’MOBL’ plus at least one of the following codes: 'PTRES', 'SCHOOL', 'WORK', 'COMM' or 'AMB', to further qualify where the mobile service is offered.

A HC Location for a virtually delivered service **shall** have:

* type=’VI’

##### PhysicalType

When a Location is to be represented as a physical type, the `physicalType` element is used to carry an applicable code from the [Location Type (Physical) - AU Extended ValueSet](https://hl7.org.au/fhir/6.0.0-ballot/ValueSet-au-location-physical-type-extended.html).

The `physicalType` element can be used to express more specific details about the physical nature of a Location (for example: ward, building, dwelling).

#### Organization reference

The **managingOrganization** element must contain a relative reference to an existing [HC Organization](StructureDefinition-hc-organization.md).

#### Invariants

##### Invariant: preferred-postal-address

Description: If the preferred postal address extension is present on an address then that address must be of type 'postal'.

Implementation note: The profile enforces this rule so that the `hc-preferred-postal-address` extension is only used to carry postal/mailing addresses (for example PO Boxes). Publishing systems SHOULD only set the extension on addresses whose `type` is `postal`.

##### Invariant: address-requirement

Description: If a location's `type` is `VI` or `MOBL` then an address does not need to be present. For all other location types an `address` MUST be present.

Implementation note: This invariant ensures that physical locations provide a postal/physical address, while virtual or mobile services (for example telehealth, mobile clinics, ambulance services) may omit a fixed address.

##### Invariant: mobl-requires-modifier

Description: If a location's `type` includes the `MOBL` code then it is recommended that an additional modifier coding is provided to describe the mobile service (either `PTRES`, `SCHOOL`, `WORK`, `COMM`, `AMB`) but not `VI`.

Implementation note: This rule is a **warning** — it does not block publishing but encourages publishers to provide additional context about where the mobile service operates. Implementers should supply a secondary `type.coding` entry when describing mobile services to improve discoverability.

##### Invariant: vi-should-not-have-modifier

Description: If a location's `type` includes the `VI` code then no additional modifier codings should be present.

Implementation note: This rule is a **warning** — virtual locations should be clearly identified as virtual-only and not include additional modifiers that suggest physical or mobile subtypes. If a virtual service also has a physical component, model those as separate Location resources.

##### Invariant: type-or-physicalType-present

Description: A Location resource MUST include either a `type` or a `physicalType` element.

Implementation note: This rule is enforced as an error — every Location must be classified either by `type` (logical role such as `MOBL`, `VI`, etc.) or by `physicalType` (when the Location represents a specific physical characteristic). Implementers MUST populate at least one of these elements when creating Location resources.

**Usages:**

* Refer to this Profile: [HC HealthcareService](StructureDefinition-hc-healthcareservice.md), [HC Location](StructureDefinition-hc-location.md), [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md) and [HC Provenance](StructureDefinition-hc-provenance.md)
* Examples for this Profile: [Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md) and [Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)
* CapabilityStatements using this Profile: [Health Connect Reader](CapabilityStatement-health-connect-reader.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-location.csv), [Excel](StructureDefinition-hc-location.xlsx), [Schematron](StructureDefinition-hc-location.sch) 

### Notes:

### Search parameters

This IG defines and introduces several search parameters in addition to those inherited from R4, that make it easier to find and filter `HC Location` resources in Health Connect implementations.

#### Search parameters defined in this IG

The following search parameters are **defined by this IG** and **SHALL** be supported:

* `postaladdress` (Location.extension where url = HC preferred postal address extension) - Search locations by the HC-preferred postal address stored in the location's HC-specific extension. - Example (string-only): `GET /Location?postaladdress=PO%20Box%20123`
* `locationamenities` (Location.extension where url = HC amenity extension)

#### Search parameters from R4

The following search parameters are **inherited from FHIR R4** and have been deemed useful for implementation within this IG. They **SHALL** be supported:

* `name` (Location.name and Location.alias) 
* Search for locations by name and alias (partial searches supported).
* Example: `GET /Location?name:contains=Telehealth`
 
* `address` (Location.address) 
* Search for locations by address (partial searches supported).
* Example: `GET /Location?address=147-153%20Castlereagh%20Street`
 
* `type` (Location.type.coding) 
* Search for locations by their type using coded values. Use token semantics for precise code matching.
* Available codes = MOBL, PTRES, SCHOOL, WORK, COMM, AMB, VI from the HC Service Delivery Location Role Type ValueSet
* Example (code only): `GET /Location?type=MOBL`
 

**Note:** Support for _id is mandatory for a responder and optional for a requester. Where the expectation for a search parameter differs between actors, the table below will reflect the stronger conformance requirement.

* Parameter(s): _id
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): name (R4)
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): address (R4)
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): postaladdress
  * Conformance: **SHOULD**
  * Type(s): `string`
  * Requirements (when used alone or in combination): 
* Parameter(s): locationamenities
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): type (R4)
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): name+type
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): name+locationamenities
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): address+type
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): address+locationamenities
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): postaladdress+type
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): postaladdress+locationamenities
  * Conformance: **SHOULD**
  * Type(s): `string`+`token`
  * Requirements (when used alone or in combination): 

### Search include parameters

This implementation supports the following `_include` parameters when searching for Location resources:

* `_include=Location:endpoint` - Include endpoint resources referenced by the `endpoint` element
* `_include=Location:managingOrganization` - Include organization resources referenced by the `managingOrganization` element

### Search reverse include parameters

This implementation supports the following `_revinclude` parameters when searching for Location resources:

* `_revinclude=HealthcareService:location` - Include HealthcareService resources that reference this Location
* `_revinclude=Provenance:target` - Include Provenance resources that track changes to this Location

#### Example usage

```
GET /Location/456?_include=Location:endpoint&_revinclude=HealthcareService:location

```

This query returns the Location resource, its associated Endpoints, and all HealthcareServices at this Location.

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-location",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location",
  "version" : "0.1.0-preview",
  "name" : "HCLocation",
  "title" : "HC Location",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile defines a healthcare location (can also be referred as 'location') reflects the place, a site of care i.e. a practice, clinic, hospital, or facility at which healthcare services are provided by the healthcare organisation. The healthcare location can be a physical, mobile, or virtual location. In certain cases, a healthcare location can also represent a site of care within the hospital or building premises such as consulting room, operating room, outpatient room, unit, ward (e.g. maternity ward), department (e.g. emergency department) etc.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location",
        "short" : "Australian Location Directory Entry",
        "constraint" : [
          {
            "key" : "preferred-postal-address",
            "severity" : "error",
            "human" : "If the preferred postal address extension is present on an address then that address must be of type 'postal'",
            "expression" : "address.exists() and address.extension.where(url='http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-postal-address').exists() implies address.where(type='postal').exists()",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
          },
          {
            "key" : "address-requirement",
            "severity" : "error",
            "human" : "If location type is VI or MOBL then an address does not need to be present. For all other location types an address must be present.",
            "expression" : "type.coding.where(code = 'VI' or code = 'MOBL').exists().not() implies address.exists()",
            "source" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
          }
        ]
      },
      {
        "id" : "Location.meta",
        "path" : "Location.meta",
        "short" : "Metadata on Location"
      },
      {
        "id" : "Location.extension",
        "path" : "Location.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Location.extension:HCAmenity",
        "path" : "Location.extension",
        "sliceName" : "HCAmenity",
        "short" : "Amenities or facilities available at or near the location.",
        "definition" : "Facilities or amenities available within, or in close proximity of, a location. Uses the Health Connect Amenity ValueSet (http://ns.electronichealth.net.au/hc/ValueSet/HCAmenityVs).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-amenity"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.extension:HCPreferredPostalAddress",
        "path" : "Location.extension",
        "sliceName" : "HCPreferredPostalAddress",
        "short" : "Preferred postal address",
        "definition" : "Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-preferred-postal-address"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "min" : 1
      },
      {
        "id" : "Location.alias",
        "path" : "Location.alias",
        "short" : "Alternative names for the location",
        "definition" : "Other names or aliases by which this location is known, such as abbreviations, former names, or local names.",
        "mustSupport" : true
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "short" : "Indicates whether the location is a virtual location or mobile service.",
        "definition" : "Indicates whether the location is a fixed physical place, virtual location or a mobile service. Used to identify the type of location that meets their patient's needs.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-service-delivery-location-role-type"
        }
      },
      {
        "id" : "Location.telecom",
        "path" : "Location.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "description" : "Slice based on telecom system: phone, email. Must have at least one of each.",
          "rules" : "open"
        },
        "min" : 2,
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom:phone",
        "path" : "Location.telecom",
        "sliceName" : "phone",
        "short" : "Phone number for the location.",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom:phone.system",
        "path" : "Location.telecom.system",
        "min" : 1,
        "patternCode" : "phone"
      },
      {
        "id" : "Location.telecom:email",
        "path" : "Location.telecom",
        "sliceName" : "email",
        "short" : "Email address for the location.",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Location.telecom:email.system",
        "path" : "Location.telecom.system",
        "min" : 1,
        "patternCode" : "email"
      },
      {
        "id" : "Location.address",
        "path" : "Location.address",
        "short" : "Address where the service or practitioner role is located. Virtual and mobile locations may not have a fixed address."
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "short" : "Reference to managing organisation with HPI-O.",
        "definition" : "A reference to the organisation that holds a HPI-O and manages or is responsible for this location entry in the provider directory.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization"
            ]
          }
        ]
      },
      {
        "id" : "Location.partOf",
        "path" : "Location.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
            ]
          }
        ]
      },
      {
        "id" : "Location.endpoint",
        "path" : "Location.endpoint",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
