# HC IAR Levels of Care - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC IAR Levels of Care**

## Extension: HC IAR Levels of Care 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-iar-levels-of-care | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HcIarLevelsOfCareExtension |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service. Patterned after PCA IAR Levels of Care extension.

Context of Use: HealthcareService

Codes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [HC HealthcareService](StructureDefinition-hc-healthcareservice.md)
* Examples for this Extension: [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-iar-levels-of-care)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-iar-levels-of-care.csv), [Excel](StructureDefinition-hc-iar-levels-of-care.xlsx), [Schematron](StructureDefinition-hc-iar-levels-of-care.sch) 

#### Terminology Bindings

#### Constraints

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-iar-levels-of-care",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-iar-levels-of-care",
  "version" : "0.1.0-preview",
  "name" : "HcIarLevelsOfCareExtension",
  "title" : "HC IAR Levels of Care",
  "status" : "draft",
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service. Patterned after PCA IAR Levels of Care extension.\n\nContext of Use: HealthcareService\n\nCodes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "HealthcareService"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "HC IAR Levels of Care",
        "definition" : "Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service. Patterned after PCA IAR Levels of Care extension.\n\nContext of Use: HealthcareService\n\nCodes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-iar-levels-of-care"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "IAR Levels of Care for the healthcare service.",
        "definition" : "The Initial Assessment and Referral (IAR) Levels of Care for the healthcare service.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://ns.electronichealth.net.au/hc/ValueSet/hc-iar-levels-of-care-vs"
        }
      }
    ]
  }
}

```
