# Health Connect - Example Virtual Telehealth Service - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect - Example Virtual Telehealth Service**

## Example Location: Health Connect - Example Virtual Telehealth Service

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-09-01 14:45:30+0000

Profile: [HC Location](StructureDefinition-hc-location.md)

**identifier**: LSPN/565656

**name**: Virtual Telehealth Service

**alias**: Ye Old Virtual Telehealth Service

**type**: Virtual

**telecom**: [+61 2 8000 0000](tel:+61280000000), [telehealth-support@mockhealth.au](mailto:telehealth-support@mockhealth.au), [https://telehealth.mockservice.au/session/virtual-123](https://telehealth.mockservice.au/session/virtual-123), [https://telehealth.mockservice.au/consult](https://telehealth.mockservice.au/consult)

**managingOrganization**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "example-healthconnect-virtual-telehealth-service-1",
  "meta" : {
    "lastUpdated" : "2025-09-01T14:45:30Z",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "LSPN",
            "display" : "Location Specific Practice Number"
          }
        ],
        "text" : "LSPN"
      },
      "system" : "http://ns.electronichealth.net.au/id/location-specific-practice-number",
      "value" : "565656"
    }
  ],
  "name" : "Virtual Telehealth Service",
  "alias" : ["Ye Old Virtual Telehealth Service"],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/location-type",
          "code" : "VI",
          "display" : "Virtual"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+61 2 8000 0000",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "telehealth-support@mockhealth.au",
      "use" : "work"
    },
    {
      "system" : "url",
      "value" : "https://telehealth.mockservice.au/session/virtual-123",
      "use" : "work"
    },
    {
      "system" : "url",
      "value" : "https://telehealth.mockservice.au/consult",
      "use" : "work"
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/example-healthconnect-organization-1"
  }
}

```
