# Terminology - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The [value sets](http://hl7.org/fhir/R4/valueset.html) and [code systems](http://hl7.org/fhir/R4/codesystem.html) listed below are defined as part of this implementation guide.

### Value sets

* [HC Amenity ValueSet](ValueSet-HCAmenityVs.md)

* [HC Gender Identity ValueSet](ValueSet-HCGenderIdentityVs.md)

* [HC Australian Endpoint Payload Types](ValueSet-hc-endpoint-payload-type-vs.md)

* [HC IAR Levels of Care ValueSet](ValueSet-hc-iar-levels-of-care-vs.md)

* [HC Organization Classification ValueSet](ValueSet-hc-org-classification-vs.md)

* [HC Service Delivery Location Role Type ValueSet](ValueSet-hc-service-delivery-location-role-type.md)

* [HC Service Eligibility ValueSet](ValueSet-hc-service-eligibility-vs.md)

* [HC Australian Service Interfaces](ValueSet-hc-service-interfaces-vs.md)

* [HC Service Provision Code](ValueSet-hc-service-provision-code-vs.md)

### Code systems

* [HC Amenity CodeSystem](CodeSystem-HCAmenity-cs.md)

* [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md)

* [HC IAR Levels of Care CodeSystem](CodeSystem-hc-iar-levels-of-care.md)

* [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md)

* [HC Service Eligibility CodeSystem](CodeSystem-hc-service-eligibility-cs.md)

* [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md)

* [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

