# Home - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect | *Version*:0.1.0-preview |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

# Health Connect FHIR ImplementationGuide

> This material is under active development and content may be added or updated on a regular basis.

ADHA review feedback

We welcome your feedback on this implementation guide.

To contribute directly to this implementation guide with code changes or documentation updates, please fork the repository and submit a pull request.

For technical FHIR-related comments, implementation feedback, or suggestions for profile improvements, you can create a GitHub issue.

For feedback concerning design considerations, business requirements, or broader implementation strategy, please [contact the Clininical Informatics team](mailto:informatics@digitalhealth.gov.au).

### Introduction

Health Connect Australia is a national health information exchange program designed to enable the sharing of health information between healthcare participants quickly and securely. By integrating advanced digital infrastructure, standards, privacy protections and enabling real-time data sharing, Health Connect Australia will support multidisciplinary collaboration across care settings. As a key enabler of the [National Digital Health Strategy 2023–2028](https://www.digitalhealth.gov.au/national-digital-health-strategy) and the [National Healthcare Interoperability Plan 2023-2028](https://www.digitalhealth.gov.au/about-us/strategies-and-plans/national-healthcare-interoperability-plan), it ensures secure, connected digital solutions that improve access, efficiency and care quality—paving the way for a smarter, more integrated future in digital health. The program is being delivered in phases, beginning with foundational capabilities and expanding to support secure communication, record discovery, and value-added services for both providers and consumers.

The Directory and Authorisation Service Project is the first initiative under the Foundations phase. It enables healthcare providers to discover accurate, up-to-date information about other providers and the services they offer, while establishing a trust framework to support consistent and secure access to health information. By connecting provider data from multiple primary sources through a single access point and ensuring near real-time updates, the project lays the groundwork for broader interoperability and trusted information exchange across the national health ecosystem.

One of the key objectives of the Directory and Authorisation Service Project is to enable interoperability through contemporary standards—such as FHIR APIs—to ensure seamless integration across clinical and administrative systems. To support this, the project is establishing a centralised directory hosted on a FHIR repository, where provider and organisation data will be structured using HL7® FHIR® and terminology standards. To guide consistent implementation and promote national alignment, the project is developing a FHIR Implementation Guide that defines how provider information should be represented and exchanged. This guide will build on existing standards, including the HL7 Australia Provider Directory FHIR IG, and provide a clear reference for integrators and system vendors to support secure, scalable, and standards-compliant access to directory data.

### How to read this guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for the implementation guide.
* [FHIR Artefacts](artifacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Profiles and Extensions](profiles-and-extensions.md): This page lists the FHIR profiles and extensions that are defined in this guide.
* [Terminology](terminology.md): This page lists the FHIR terminology that are defined in this guide.
* [Search Parameters](artifacts.md#behavior-search-parameters): This page lists the FHIR search parameters that are defined in this guide.
* [Capability Statements](capability-statements.md): This page defines the expected FHIR capabilities of Health Connect Reader.
* [Actor Definitions](actors.md): This page defines the Health Connect actors, Health Connect Reader.
 
* [Conformance](conformance.md): This page describes the set of rules to claim conformance to this guide including Capability Statements and Actor definitions.
* [Examples](examples.md): This page lists the sample instances of FHIR resources conforming to the FHIR profiles.
* [Disclaimers](disclaimers.md): This page lists the licensing, copyright, and disclaimers under which this guide is issued.
* [Downloads](downloads.md): This page provides links to downloadable artefacts including the Agency FHIR NPM package.

### Document purpose and scope

The primary aim of this implementation guide is to support implementers integrating with the Directory services using [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4). It provides the technical specifications, FHIR profiles, and terminology definitions required for healthcare provider data exchange through Health Connect APIs.

This document describes specific system behaviours such as obligations, API HTTP response codes, and search parameters. Other system behavioural requirements such as the presentation of information and user experience are managed separately and must be met before systems can be assessed for conformance and granted access to Health Connect APIs.

Reference has been made to International and Australian Standards, and to Standards from HL7. The following standards are referred to in the text in such a way that some or all of its content constitutes requirements for the purposes of this specification:

* [FHIR, Release 4 (v4.0.1) [HL7FHIR4]](#HL7FHIR4)
* [Australian Base Profiles Implementation Guide [HL7AUBIG]](#HL7AUBIG)
* [Australian Core Profiles Implementation Guide [HL7AUCIG]](#HL7AUCIG)

Wherever possible, material in this specification is based on existing standards. All efforts have been made to minimise divergence from the HL7 Australia profiles of HL7 International standards ([Australian Core Profiles Implementation Guide [HL7AUCIG]](#HL7AUCIG) and [Australian Base Profiles Implementation Guide [HL7AUBIG]](#HL7AUBIG)) to provide for system interoperability and compatibility with other profiles. Issues of an editorial nature in the source material (such as spelling or punctuation errors) are intentionally reproduced. For a list of known issues (see below).

### Intended audience

This implementation guide is aimed at software development teams, architects, and designers that integrate with the Health Connect service.

This implementation guide and related artefacts are technical in nature and the audience is expected to be familiar with the language of health data specifications and to have some familiarity with health information standards and specifications, such as FHIR.

### Relationships with other work

This implementation guide builds on other specifications, helping ensure a consistent approach to data sharing that should ease adoption. The specific guides used, and the portions relevant from each of them are as follows:

### Cross version analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (au.digitalhealth.r4.healthconnect.r4)](package.r4.tgz) and [R4B (au.digitalhealth.r4.healthconnect.r4b)](package.r4b.tgz) are available.

### Global profiles

*There are no Global profiles defined*

### Data model overview

The Health Connect Australia Provider Directory uses FHIR resources to represent healthcare providers, their roles, organisational affiliations, service locations, and the healthcare services they provide. The diagram below illustrates the key relationships between these FHIR resources:

* Practitioner - Individual healthcare providers with their professional qualifications and identifiers
* Organization - Healthcare organisations and facilities that employ or affiliate with practitioners
* HealthcareService - Specific services offered by organisations at locations
* Location - Physical or virtual locations where healthcare services are delivered
* Endpoint - Technical endpoints for digital service integration and communication

This model supports complex healthcare delivery scenarios while maintaining FHIR R4 compliance and enabling efficient provider directory searches and integrations.

### Intellectual property considerations

This implementation guide and the underlying FHIR specification are licensed as public domain under the [FHIR license](http://hl7.org/fhir/R4/license.html). The license page also describes rules for the use of the FHIR name and logo.

This publication includes IP covered under the following statements.

* Copyright © 2018 Australian Digital Health Agency - All rights reserved. Except for the material identified below, this content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).This resource includes material that is based on Australian Institute of Health and Welfare material.All copies of this resource must include this copyright statement and all information contained in this statement.

* [Australian States and Territories](https://tx.ontoserver.csiro.au/fhir/ValueSet/australian-states-territories-1): [HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)](https://creativecommons.org/licenses/by/4.0/) 

* [HC Amenity CodeSystem](CodeSystem-HCAmenity-cs.md): [HCAmenity](StructureDefinition-hc-amenity.md), [HCAmenityVs](ValueSet-HCAmenityVs.md) and [Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)
* [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md): [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md), [HCEndpoint](StructureDefinition-hc-endpoint.md) and [Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* [HC IAR Levels of Care CodeSystem](CodeSystem-hc-iar-levels-of-care.md): [HcIarLevelsOfCareExtension](StructureDefinition-hc-iar-levels-of-care.md), [HcIarLevelsOfCareVs](ValueSet-hc-iar-levels-of-care-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md): [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md), [HCHSPOIdentifier](StructureDefinition-hc-hspo.md), [HcOrgClassVS](ValueSet-hc-org-classification-vs.md) and [HcOrgClassification](StructureDefinition-hc-org-classification.md)
* [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md): [HCEndpoint](StructureDefinition-hc-endpoint.md) and [HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md)


* Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/).

* [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md) and [HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md)


* HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.

* [Location Type AU](http://hl7.org.au/fhir/6.0.0-ballot/CodeSystem-au-location-type.html): [HCLocation](StructureDefinition-hc-location.md), [HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md) and [Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)
* [Service Provision Conditions Australian Concepts](http://hl7.org.au/fhir/6.0.0-ballot/CodeSystem-service-provision-conditions.html): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)
* [IdentifierType AU](http://hl7.org.au/fhir/6.0.0-ballot/CodeSystem-au-v2-0203.html): [Example Aged Care Facility](Organization-example-healthconnect-organization-1.md), [HCHPIOIdentifier](StructureDefinition-hc-hpio.md)...Show 4 more,[Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md),[Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md),[PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md)and[Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AustralianEndpointPayloadTypesCodeSystem](CodeSystem-hc-endpoint-payload-type-cs.md), [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)...Show 57 more,[HCAcceptNewPatient](StructureDefinition-hc-accept-new-patient.md),[HCAmenity](StructureDefinition-hc-amenity.md),[HCAmenityCs](CodeSystem-HCAmenity-cs.md),[HCAmenityVs](ValueSet-HCAmenityVs.md),[HCEndpoint](StructureDefinition-hc-endpoint.md),[HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md),[HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md),[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[HCHealthcareService](StructureDefinition-hc-healthcareservice.md),[HCLocation](StructureDefinition-hc-location.md),[HCOrganization](StructureDefinition-hc-organization.md),[HCPractitioner](StructureDefinition-hc-practitioner.md),[HCPractitionerRole](StructureDefinition-hc-practitionerrole.md),[HCPreferredPostalAddress](StructureDefinition-hc-preferred-postal-address.md),[HCProfessionalRegistrationNumber](StructureDefinition-hc-prn.md),[HCProvenance](StructureDefinition-hc-provenance.md),[HCSMDTargetIdentifier](StructureDefinition-hc-smd-target-identifier.md),[HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md),[HCServiceEligibilityCodeSystem](CodeSystem-hc-service-eligibility-cs.md),[HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md),[HCServiceInterfaceCodeSystem](CodeSystem-hc-service-interfaces-cs.md),[HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md),[HCServiceProvisionCodeCodeSystem](CodeSystem-hc-service-provision-code-cs.md),[HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md),[HcActivePeriod](StructureDefinition-hc-active-period.md),[HcIarLevelsOfCareCs](CodeSystem-hc-iar-levels-of-care.md),[HcIarLevelsOfCareExtension](StructureDefinition-hc-iar-levels-of-care.md),[HcIarLevelsOfCareVs](ValueSet-hc-iar-levels-of-care-vs.md),[HcOrgClassCS](CodeSystem-hc-org-classification-cs.md),[HcOrgClassVS](ValueSet-hc-org-classification-vs.md),[HcOrgClassification](StructureDefinition-hc-org-classification.md),[HcPractitionerRoleCommunication](StructureDefinition-hc-practitioner-role-communication.md),[HcPreferredName](StructureDefinition-hc-preferred-name.md),[HcReferralInformationForReferrer](StructureDefinition-hc-referral-information-for-referrer.md),[HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md),[HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide](index.md),[HealthConnectReader](CapabilityStatement-health-connect-reader.md),[PCAHealthcareServiceIdentifier](StructureDefinition-pca-hsi.md),[ReaderActorHealthConnect](ActorDefinition-reader-actor-health-connect.md),[SearchParameterAvailabilityAllDay](SearchParameter-availability-allday.md),[SearchParameterAvailabilityDaysOfWeek](SearchParameter-availability-daysofweek.md),[SearchParameterAvailabilityEndTime](SearchParameter-availability-endtime.md),[SearchParameterAvailabilityStartTime](SearchParameter-availability-starttime.md),[SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md),[SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md),[SearchParameterEndpointUrl](SearchParameter-endpoint-url.md),[SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md),[SearchParameterLanguages](SearchParameter-languages.md),[SearchParameterLocationAmenities](SearchParameter-location-amenities.md),[SearchParameterLocationPostalAddress](SearchParameter-location-postalAddress.md),[SearchParameterPractitionerOfficialName](SearchParameter-practitioner-officialname.md),[SearchParameterPractitionerPreferredname](SearchParameter-practitioner-preferredname.md),[SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md),[SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md),[SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)and[SearchParameterProfessionalRegistrationNumber](SearchParameter-ProfessionalRegistrationNumber.md)


* This code system is a clone of the PCA Service Eligibility CodeSystem. Copyright © Australian Digital Health Agency.

* [HC Service Eligibility CodeSystem](CodeSystem-hc-service-eligibility-cs.md): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md) and [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [HCHealthcareService](StructureDefinition-hc-healthcareservice.md), [Healthcare service with Residential Aged Care service type](HealthcareService-example-healthconnect-healthcareservice-1.md), [Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md), [Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md) and [PractitionerRole/example-healthconnect-practitionerrole-1](PractitionerRole-example-healthconnect-practitionerrole-1.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [UsageContextType](http://terminology.hl7.org/7.0.0/CodeSystem-usage-context-type.html): [AustralianEndpointPayloadTypesCodeSystem](CodeSystem-hc-endpoint-payload-type-cs.md), [AustralianEndpointPayloadTypesValueSet](ValueSet-hc-endpoint-payload-type-vs.md)...Show 57 more,[HCAcceptNewPatient](StructureDefinition-hc-accept-new-patient.md),[HCAmenity](StructureDefinition-hc-amenity.md),[HCAmenityCs](CodeSystem-HCAmenity-cs.md),[HCAmenityVs](ValueSet-HCAmenityVs.md),[HCEndpoint](StructureDefinition-hc-endpoint.md),[HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md),[HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md),[HCHPIOIdentifier](StructureDefinition-hc-hpio.md),[HCHSPOIdentifier](StructureDefinition-hc-hspo.md),[HCHealthcareService](StructureDefinition-hc-healthcareservice.md),[HCLocation](StructureDefinition-hc-location.md),[HCOrganization](StructureDefinition-hc-organization.md),[HCPractitioner](StructureDefinition-hc-practitioner.md),[HCPractitionerRole](StructureDefinition-hc-practitionerrole.md),[HCPreferredPostalAddress](StructureDefinition-hc-preferred-postal-address.md),[HCProfessionalRegistrationNumber](StructureDefinition-hc-prn.md),[HCProvenance](StructureDefinition-hc-provenance.md),[HCSMDTargetIdentifier](StructureDefinition-hc-smd-target-identifier.md),[HCServiceCoverageArea](StructureDefinition-hc-service-coverage-area.md),[HCServiceEligibilityCodeSystem](CodeSystem-hc-service-eligibility-cs.md),[HCServiceEligibilityValueSet](ValueSet-hc-service-eligibility-vs.md),[HCServiceInterfaceCodeSystem](CodeSystem-hc-service-interfaces-cs.md),[HCServiceInterfacesValueSet](ValueSet-hc-service-interfaces-vs.md),[HCServiceProvisionCodeCodeSystem](CodeSystem-hc-service-provision-code-cs.md),[HCServiceProvisionCodeValueSet](ValueSet-hc-service-provision-code-vs.md),[HcActivePeriod](StructureDefinition-hc-active-period.md),[HcIarLevelsOfCareCs](CodeSystem-hc-iar-levels-of-care.md),[HcIarLevelsOfCareExtension](StructureDefinition-hc-iar-levels-of-care.md),[HcIarLevelsOfCareVs](ValueSet-hc-iar-levels-of-care-vs.md),[HcOrgClassCS](CodeSystem-hc-org-classification-cs.md),[HcOrgClassVS](ValueSet-hc-org-classification-vs.md),[HcOrgClassification](StructureDefinition-hc-org-classification.md),[HcPractitionerRoleCommunication](StructureDefinition-hc-practitioner-role-communication.md),[HcPreferredName](StructureDefinition-hc-preferred-name.md),[HcReferralInformationForReferrer](StructureDefinition-hc-referral-information-for-referrer.md),[HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md),[HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide](index.md),[HealthConnectReader](CapabilityStatement-health-connect-reader.md),[PCAHealthcareServiceIdentifier](StructureDefinition-pca-hsi.md),[ReaderActorHealthConnect](ActorDefinition-reader-actor-health-connect.md),[SearchParameterAvailabilityAllDay](SearchParameter-availability-allday.md),[SearchParameterAvailabilityDaysOfWeek](SearchParameter-availability-daysofweek.md),[SearchParameterAvailabilityEndTime](SearchParameter-availability-endtime.md),[SearchParameterAvailabilityStartTime](SearchParameter-availability-starttime.md),[SearchParameterEndpointIdentifierHC](SearchParameter-endpoint-hcepi.md),[SearchParameterEndpointPayloadMimeType](SearchParameter-endpoint-payloadmimetype.md),[SearchParameterEndpointUrl](SearchParameter-endpoint-url.md),[SearchParameterHealthcareServiceBilling](SearchParameter-healthcareservice-billing.md),[SearchParameterLanguages](SearchParameter-languages.md),[SearchParameterLocationAmenities](SearchParameter-location-amenities.md),[SearchParameterLocationPostalAddress](SearchParameter-location-postalAddress.md),[SearchParameterPractitionerOfficialName](SearchParameter-practitioner-officialname.md),[SearchParameterPractitionerPreferredname](SearchParameter-practitioner-preferredname.md),[SearchParameterPractitionerRSG](SearchParameter-practitioner-rsg.md),[SearchParameterPractitionerRegProf](SearchParameter-practitioner-regprof.md),[SearchParameterPractitionerRoleType](SearchParameter-practitionerrole-roletype.md)and[SearchParameterProfessionalRegistrationNumber](SearchParameter-ProfessionalRegistrationNumber.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [HCEndpointIdentifier](StructureDefinition-hc-endpoint-identifier.md), [HCHSPOIdentifier](StructureDefinition-hc-hspo.md)...Show 4 more,[HCProfessionalRegistrationNumber](StructureDefinition-hc-prn.md),[Practitioner/example-healthconnect-practitioner-1](Practitioner-example-healthconnect-practitioner-1.md),[Practitioner/external-hc-practitioner-record](Practitioner-external-hc-practitioner-record.md)and[Sydney General Hospital SMD Endpoint](Endpoint-example-hc-endpoint-smd.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [DataOperation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-DataOperation.html): [HCProvenance](StructureDefinition-hc-provenance.md), [Provenance/provenance-practitioner-name-update](Provenance-provenance-practitioner-name-update.md) and [Provenance/provenance-practitioner-phone-update](Provenance-provenance-practitioner-phone-update.md)
* [DocumentCompletion](http://terminology.hl7.org/7.0.0/CodeSystem-v3-DocumentCompletion.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [HCGenderIdentityVs](ValueSet-HCGenderIdentityVs.md) and [HCPractitioner](StructureDefinition-hc-practitioner.md)
* [ParticipationType](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationType.html): [HCProvenance](StructureDefinition-hc-provenance.md)
* [RoleCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-RoleCode.html): [HCLocation](StructureDefinition-hc-location.md), [HcServiceDeliveryLocationRoleType](ValueSet-hc-service-delivery-location-role-type.md) and [Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md)


### Known issues

This table lists known issues with this specification at the time of publishing. We are working on solutions to these issues and encourage comments to help us develop these solutions.

* Reference: Example system URI
  * Description: An inherited example system (e.g.`http://www.acme.com/identifiers/patient`) erroneously infers patient context. Implementers must use their own namespace URIs. The affected identifier profile is Endpoint (HC-EPI) — this profile includes the erroneous example `system` in their documentation.

### References

| | |
| :--- | :--- |
| [HL7AUBIG] | HL7 Australia, FHIR R4 standard for AU Base Implementation Guide, v6.0.0-ballot (Ballot) |
|   | [https://hl7.org.au/fhir/6.0.0-ballot/index.html](https://hl7.org.au/fhir/6.0.0-ballot/index.html) |

| | |
| :--- | :--- |
| [HL7FHIR4] | Health Level Seven, Inc., 30 October 2019, FHIR R4. |
|   | [http://hl7.org/fhir/R4/](http://hl7.org/fhir/R4/) |

| | |
| :--- | :--- |
| [HL7AUCIG] | HL7 Australia, FHIR R4 standard for AU Core Implementation Guide, v2.0.0-ballot - Ballot (Ballot) |
|   | [https://hl7.org.au/fhir/core/2.0.0-ballot/index.html](https://hl7.org.au/fhir/core/2.0.0-ballot/index.html) |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "au.digitalhealth.r4.healthconnect",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect",
  "version" : "0.1.0-preview",
  "name" : "HealthConnectAustraliaProviderDirectoryFHIRImplementationGuide",
  "title" : "Health Connect Australia Provider Directory FHIR Implementation Guide",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This Implementation Guide defines an Health Connect Australia Provider Directory within Australian context.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "packageId" : "au.digitalhealth.r4.healthconnect",
  "license" : "Apache-2.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_au_core",
      "uri" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core",
      "packageId" : "hl7.fhir.au.core",
      "version" : "2.0.0-ballot"
    },
    {
      "id" : "hl7_fhir_au_base",
      "uri" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base",
      "packageId" : "hl7.fhir.au.base",
      "version" : "6.0.0-ballot"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Preview"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludexml"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludejson"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "tx"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "generate"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "init"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ns.electronichealth.net.au/hc/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Preview"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludexml"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludejson"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "tx"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "generate"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "init"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ns.electronichealth.net.au/hc/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/availability-allday"
        },
        "name" : "All Day Availability Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by whether they are available all day.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/availability-endtime"
        },
        "name" : "Availability End Time Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by availability end time.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/availability-starttime"
        },
        "name" : "Availability Start Time Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by availability start time.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/availability-daysofweek"
        },
        "name" : "Days of Week Availability Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by days of week availability. Supports multiple days using OR logic.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endpoint-payloadmimetype"
        },
        "name" : "Endpoint Payload Mime Type Search Parameter",
        "description" : "Search for Endpoint resources by payloadMimeType.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endpoint-url"
        },
        "name" : "Endpoint URL Search Parameter",
        "description" : "Search for Endpoint resources by address (URL).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-accept-new-patient"
        },
        "name" : "HC Accept New Patient",
        "description" : "Indicates whether the healthcare service is accepting new patients. Patterned after PCA New Patient Availability extension.\n\nContext of Use: HealthcareService",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-active-period"
        },
        "name" : "HC Active Period",
        "description" : "The period during which the HealthcareService is considered active in the Health Connect directory. Patterned after PCA Active Period.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-amenity"
        },
        "name" : "HC Amenity",
        "description" : "Physical features or amenities available within, or in close proximity of, a location. Patterned after PCA Amenity.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/HCAmenity-cs"
        },
        "name" : "HC Amenity CodeSystem",
        "description" : "A code system for amenities or facilities relevant to Health Connect (HC) locations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/HCAmenityVs"
        },
        "name" : "HC Amenity ValueSet",
        "description" : "A value set of amenities or facilities available at or near Health Connect locations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-endpoint-payload-type-vs"
        },
        "name" : "HC Australian Endpoint Payload Types",
        "description" : "The Australian Endpoint Payload Types value set enumerates well known endpoint payload types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-endpoint-payload-type-cs"
        },
        "name" : "HC Australian Endpoint Payload Types",
        "description" : "The Endpoint Payload Types code system defines concepts that identify well known endpoint payload types.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-service-interfaces-vs"
        },
        "name" : "HC Australian Service Interfaces",
        "description" : "The Health Connect Australian Service Interfaces value set enumerates well known service interfaces that can be used for specifying a connection type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-service-interfaces-cs"
        },
        "name" : "HC Australian Service Interfaces",
        "description" : "The Australian Secure Message Service Interfaces code system defines concepts that identify service interfaces for secure message delivery.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-endpoint"
        },
        "name" : "HC Endpoint",
        "description" : "This profile defines content for describing details of an endpoint.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Endpoint"
          }
        ],
        "reference" : {
          "reference" : "Endpoint/example-hc-endpoint-smd"
        },
        "name" : "HC Endpoint - SMD Target Example",
        "description" : "Example of a Health Connect endpoint with SMD target identifier for secure messaging.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-endpoint-identifier"
        },
        "name" : "HC Endpoint Identifier (HC-EPI)",
        "description" : "This identifier profile defines a unique identifier allocated to a healthcare endpoint, in a Health Connect provider directory context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/endpoint-hcepi"
        },
        "name" : "HC Endpoint Identifier Search Parameter",
        "description" : "Search an Endpoint record by its HC identifier.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/HCGenderIdentityVs"
        },
        "name" : "HC Gender Identity ValueSet",
        "description" : "A value set of gender identities recognised by Health Connect.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-healthcareservice"
        },
        "name" : "HC HealthcareService",
        "description" : "This profile of HealthcareService represents a particular type of health or health related service offered by a healthcare organisation at a particular location i.e. a practice, clinic, facility, or hospital. The authoritative source for healthcare services is the healthcare provider organisation that provides the service(s).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-hpio"
        },
        "name" : "HC HPI-O",
        "description" : "This identifier profile extends the AU HPI-O profile to include an organization classification extension to indicate whether the organization is a 'seed' or 'network' type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-hspo"
        },
        "name" : "HC HSP-O",
        "description" : "This identifier profile defines a Healthcare Support Service Provider Organisation in an Australian context. An HSP-O is assigned under the HI Service to a service (in-home care support and personal care services) where healthcare is provided. A HSP-O can only be of 'seed' type. An Organization cannot be assigned both an HPI-O and an HSP-O; only one identifier is assigned by the HI Service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-iar-levels-of-care"
        },
        "name" : "HC IAR Levels of Care",
        "description" : "Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service. Patterned after PCA IAR Levels of Care extension.\n\nContext of Use: HealthcareService\n\nCodes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-iar-levels-of-care"
        },
        "name" : "HC IAR Levels of Care CodeSystem",
        "description" : "The Health Connect IAR Levels of care code system defines concepts for the levels of care that the service provides, as defined by the National Initial Assessment and Referral (IAR) for Mental Healthcare Guidance (IAR Guidance) and IAR Decision Support Tool.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-iar-levels-of-care-vs"
        },
        "name" : "HC IAR Levels of Care ValueSet",
        "description" : "All codes from the Health Connect IAR Levels of Care CodeSystem are for use in the context of the hc-iar-levels-of-care extension.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-location"
        },
        "name" : "HC Location",
        "description" : "This profile defines a healthcare location (can also be referred as 'location') reflects the place, a site of care i.e. a practice, clinic, hospital, or facility at which healthcare services are provided by the healthcare organisation. The healthcare location can be a physical, mobile, or virtual location. In certain cases, a healthcare location can also represent a site of care within the hospital or building premises such as consulting room, operating room, outpatient room, unit, ward (e.g. maternity ward), department (e.g. emergency department) etc.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-organization"
        },
        "name" : "HC Organization",
        "description" : "This profile defines a provider directory entry for an organisation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-org-classification"
        },
        "name" : "HC Organization Classification",
        "description" : "Extension to record whether an organisation's HPIO is a 'seed' or 'network' type in the HI service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-org-classification-cs"
        },
        "name" : "HC Organization Classification CodeSystem",
        "description" : "Internal code system that describes whether an organisation is a 'seed' or 'network' type used by Health Connect.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-org-classification-vs"
        },
        "name" : "HC Organization Classification ValueSet",
        "description" : "The Health Connect ValueSet referencing the HC Organization Classification CodeSystem (seed, network).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/pca-hsi"
        },
        "name" : "HC PCA Healthcare Service Identifier (PCA-HSI)",
        "description" : "Identifier for a healthcare service as allocated by PCA.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-practitioner"
        },
        "name" : "HC Practitioner",
        "description" : "This profile defines Healthcare Provider Individual details who is delivering health related services.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-practitioner-role-communication"
        },
        "name" : "HC Practitioner Role Communication",
        "description" : "Health Connect Practitioner Role Communication. This extension captures communication preferences and capabilities for a practitioner in a given role.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-practitionerrole"
        },
        "name" : "HC PractitionerRole",
        "description" : "This profile defines a practitioner in role for an organisation at a location providing a healthcare service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-preferred-name"
        },
        "name" : "HC Preferred Name",
        "description" : "This extension applies to PractitionerRole, and represents a name by which a practitioner chooses to be known in the context of the delivery of a specific healthcare service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-preferred-postal-address"
        },
        "name" : "HC Preferred Postal Address",
        "description" : "Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-prn"
        },
        "name" : "HC Professional Registration Number (HC-PRN)",
        "description" : "This identifier profile defines a professional registration number allocated to a healthcare practitioner, in a Health Connect provider directory context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-provenance"
        },
        "name" : "HC Provenance",
        "description" : "This profile of Provenance is used to record an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-referral-information-for-referrer"
        },
        "name" : "HC Referral Information for Referrer",
        "description" : "Referral instructions and information for healthcare service providers that may wish to refer patients / clients to the healthcare service. Modeled after PCA but for Health Connect context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-service-coverage-area"
        },
        "name" : "HC Service Coverage Area",
        "description" : "This profile of Location represents an Australian geographic coverage area i.e. postcodes where this service is provided.\nFor a healthcare service, that is provided through a physical location but have eligibility restrictions applicable in terms of only residents for certain postcodes/suburbs can receive this service, then the details of coverage area and eligibility should be provided here.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-service-delivery-location-role-type"
        },
        "name" : "HC Service Delivery Location Role Type ValueSet",
        "description" : "The Health Connect value set for service delivery location role types, based on PCA's ValueSet but with HC context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-service-eligibility-cs"
        },
        "name" : "HC Service Eligibility CodeSystem",
        "description" : "Health Connect code system for service eligibility, modeled after PCA's eligibility code system. Codes represent eligibility requirements for healthcare services.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-service-eligibility-vs"
        },
        "name" : "HC Service Eligibility ValueSet",
        "description" : "The Health Connect value set for service eligibility, modeled after PCA's eligibility value set. Codes represent eligibility requirements for healthcare services.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/hc-service-provision-code-vs"
        },
        "name" : "HC Service Provision Code",
        "description" : "The HC Service Provision Code value set includes values that may be used to identify the service provision condition of a healthcare service in HC.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/hc-service-provision-code-cs"
        },
        "name" : "HC Service Provision Code",
        "description" : "The HC Service Provision Code code system defines a concept (in addition to those defined in [Service Provision Conditions Australian Concepts](https://hl7.org.au/fhir/4.1.0/CodeSystem-service-provision-conditions.html) that may be used to identify the service provision condition of a healthcare service in HC.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/hc-smd-target-identifier"
        },
        "name" : "HC SMD Target Identifier (HC-SMDTI)",
        "description" : "This identifier profile defines a SMD target identifier allocated to a healthcare practitioner, in a Health Connect provider directory context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/example-healthconnect-organization-1"
        },
        "name" : "Health Connect - Example Aged Care Facility",
        "description" : "An example Aged Care Facility that conforms to [Health Connect Organization - Organization](StructureDefinition-hc-organization.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-Location-service-coverage-area"
        },
        "name" : "Health Connect - Example Location Service Coverage Area",
        "description" : "An example of Location that conforms to [Health Connect Location - Service Coverage Area](StructureDefinition-hc-service-coverage-area.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-service-coverage-area"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-Physical-location-with-wheelchair-access-1"
        },
        "name" : "Health Connect - Example Physical location with wheelchair access",
        "description" : "An example of Location that conforms to [Health Connect Location - location](StructureDefinition-hc-location.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example-healthconnect-virtual-telehealth-service-1"
        },
        "name" : "Health Connect - Example Virtual Telehealth Service",
        "description" : "An example of a virtual Location (telehealth service) that conforms to the Health Connect Location profile. This is a virtual/telehealth service and therefore does not include a physical address that conforms to [HealthConnect Location - location](StructureDefinition-hc-location.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/external-hc-practitioner-record"
        },
        "name" : "Health Connect - External HC Practitioner Record",
        "description" : "Example of a practitioner record with PRN type identifier from the HC (Health Connect) system that serves as the source for provenance tracking that conforms to [Health Connect Practitioner - Practitioner](StructureDefinition-hc-practitioner.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "HealthcareService"
          }
        ],
        "reference" : {
          "reference" : "HealthcareService/example-healthconnect-healthcareservice-1"
        },
        "name" : "Health Connect - HealthcareService example",
        "description" : "An example of a HealthcareService with Medicare provider number that conforms [Health Connect HealthcareService - HealthcareService](StructureDefinition-hc-healthcareservice.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-healthcareservice"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/example-healthconnect-practitioner-1"
        },
        "name" : "Health Connect - Helen Mayo",
        "description" : "An example of practitioner Helen Mayo at Down under hospital that conforms to [Health Connect Practitioner - Practitioner](StructureDefinition-hc-practitioner.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/example-healthconnect-practitionerrole-1"
        },
        "name" : "Health Connect - PractitionerRole example",
        "description" : "An example of a practitionerrole with Medicare provider number that conforms [Health Connect PractitionerRole - PractitionerRole](StructureDefinition-hc-practitionerrole.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/provenance-practitioner-name-update"
        },
        "name" : "Health Connect Provenance - Track Practitioner Name Amendment",
        "description" : "Example showing provenance tracking when a practitioner's family name is updated in the Health Connect directory from an external source system. This demonstrates how specific data elements can be tracked for audit and compliance purposes that conforms to [Health Connect Provenance - Provenance](StructureDefinition-hc-provenance.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/provenance-practitioner-phone-update"
        },
        "name" : "Health Connect Provenance - Track Practitioner Phone Amendment",
        "description" : "Example demonstrating provenance tracking when a practitioner's phone number is updated in the Health Connect directory from an external source system. This shows how telecom data elements can be precisely tracked using FHIRPath expressions for granular audit trails that conforms to [HealthConnect Provenance - Provenance](StructureDefinition-hc-provenance.html) profile.",
        "exampleCanonical" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/health-connect-reader"
        },
        "name" : "Health Connect Reader",
        "description" : "This [CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html) resource defines the expected capabilities \nof the [Health Connect Reader actor](ActorDefinition-reader-actor-health-connect.html) when conforming to this implementation guide. The complete \nlist of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Reader actor are defined in this CapabilityStatement. \nThe requirements of the HealthConnect Reader actor may also be impacted by the rules of local jurisdictions or other contextual requirements.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/reader-actor-health-connect"
        },
        "name" : "Health Connect Reader Actor",
        "description" : "The Health Connect Reader actor represents a system that is requesting an **Health Connect Directory details** for a particular practitioner from the \nHealth Connect system.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/healthcareservice-billing"
        },
        "name" : "Healthcare Service Billing Search Parameter",
        "description" : "Search for Healthcare Service resources by billing information.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/languages"
        },
        "name" : "Languages Search Parameter",
        "description" : "Search HealthcareServices or PractitionerRoles by supported languages/communication methods. Shared across HealthcareService and PractitionerRole.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/location-amenities"
        },
        "name" : "Location Amenities Search Parameter",
        "description" : "Search for Location resources by amenities.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/location-postalAddress"
        },
        "name" : "Location Postal Address Search Parameter",
        "description" : "Search for Location resources by postal address components.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-officialname"
        },
        "name" : "Practitioner's Official Name Search Parameter",
        "description" : "Search a Practitioner record by their official name.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-preferredname"
        },
        "name" : "Practitioner's Preferred Name Search Parameter",
        "description" : "Search a Practitioner record by their preferred name.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-rsg"
        },
        "name" : "Practitioner's Recorded Sex or Gender Search Parameter",
        "description" : "Search a Practitioner record by their recorded sex or gender.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitioner-regprof"
        },
        "name" : "Practitioner's Registered Profession Search Parameter",
        "description" : "Search a Practitioner record by their registered profession using string values.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/practitionerrole-roletype"
        },
        "name" : "Practitioner's Role Type Search Parameter",
        "description" : "Search a PractitionerRole record by their role type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ProfessionalRegistrationNumber"
        },
        "name" : "Professional Registration Number Search Parameter",
        "description" : "Search a Practitioner record by their Professional Registration Number.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "guidance.html"
            }
          ],
          "nameUrl" : "guidance.html",
          "title" : "Guidance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles-and-extensions.html"
            }
          ],
          "nameUrl" : "profiles-and-extensions.html",
          "title" : "Profiles and Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "conformance.html"
            }
          ],
          "nameUrl" : "conformance.html",
          "title" : "Conformance Overview",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology.html"
            }
          ],
          "nameUrl" : "terminology.html",
          "title" : "Terminology",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artefacts.html"
            }
          ],
          "nameUrl" : "artefacts.html",
          "title" : "Artefacts Summary",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "disclaimers.html"
            }
          ],
          "nameUrl" : "disclaimers.html",
          "title" : "Disclaimers",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capability-statements.html"
            }
          ],
          "nameUrl" : "capability-statements.html",
          "title" : "Capability Statements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "actors.html"
            }
          ],
          "nameUrl" : "actors.html",
          "title" : "Actor Definitions",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "input/pagecontent"
      },
      {
        "code" : "path-pages",
        "value" : "input/intro-notes"
      },
      {
        "code" : "path-pages",
        "value" : "fsh-generated/includes"
      },
      {
        "code" : "path-pages",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
