# Artifacts Summary - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [Health Connect Reader Actor](ActorDefinition-reader-actor-health-connect.md) | The Health Connect Reader actor represents a system that is requesting an**Health Connect Directory details**for a particular practitioner from the Health Connect system. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [Health Connect Reader](CapabilityStatement-health-connect-reader.md) | This[CapabilityStatement](https://hl7.org/fhir/R4/capabilitystatement.html)resource defines the expected capabilities of the[Health Connect Reader actor](ActorDefinition-reader-actor-health-connect.md)when conforming to this implementation guide. The complete list of FHIR profiles, RESTful operations, and search parameters supported by Health Connect Reader actor are defined in this CapabilityStatement. The requirements of the HealthConnect Reader actor may also be impacted by the rules of local jurisdictions or other contextual requirements. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [All Day Availability Search Parameter](SearchParameter-availability-allday.md) | Search HealthcareServices or PractitionerRoles by whether they are available all day. |
| [Availability End Time Search Parameter](SearchParameter-availability-endtime.md) | Search HealthcareServices or PractitionerRoles by availability end time. |
| [Availability Start Time Search Parameter](SearchParameter-availability-starttime.md) | Search HealthcareServices or PractitionerRoles by availability start time. |
| [Days of Week Availability Search Parameter](SearchParameter-availability-daysofweek.md) | Search HealthcareServices or PractitionerRoles by days of week availability. Supports multiple days using OR logic. |
| [Endpoint Payload Mime Type Search Parameter](SearchParameter-endpoint-payloadmimetype.md) | Search for Endpoint resources by payloadMimeType. |
| [Endpoint URL Search Parameter](SearchParameter-endpoint-url.md) | Search for Endpoint resources by address (URL). |
| [HC Endpoint Identifier Search Parameter](SearchParameter-endpoint-hcepi.md) | Search an Endpoint record by its HC identifier. |
| [Healthcare Service Billing Search Parameter](SearchParameter-healthcareservice-billing.md) | Search for Healthcare Service resources by billing information. |
| [Languages Search Parameter](SearchParameter-languages.md) | Search HealthcareServices or PractitionerRoles by supported languages/communication methods. Shared across HealthcareService and PractitionerRole. |
| [Location Amenities Search Parameter](SearchParameter-location-amenities.md) | Search for Location resources by amenities. |
| [Location Postal Address Search Parameter](SearchParameter-location-postalAddress.md) | Search for Location resources by postal address components. |
| [Practitioner's Official Name Search Parameter](SearchParameter-practitioner-officialname.md) | Search a Practitioner record by their official name. |
| [Practitioner's Preferred Name Search Parameter](SearchParameter-practitioner-preferredname.md) | Search a Practitioner record by their preferred name. |
| [Practitioner's Recorded Sex or Gender Search Parameter](SearchParameter-practitioner-rsg.md) | Search a Practitioner record by their recorded sex or gender. |
| [Practitioner's Registered Profession Search Parameter](SearchParameter-practitioner-regprof.md) | Search a Practitioner record by their registered profession using string values. |
| [Practitioner's Role Type Search Parameter](SearchParameter-practitionerrole-roletype.md) | Search a PractitionerRole record by their role type. |
| [Professional Registration Number Search Parameter](SearchParameter-ProfessionalRegistrationNumber.md) | Search a Practitioner record by their Professional Registration Number. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Endpoint](StructureDefinition-hc-endpoint.md) | This profile defines content for describing details of an endpoint. |
| [HC HealthcareService](StructureDefinition-hc-healthcareservice.md) | This profile of HealthcareService represents a particular type of health or health related service offered by a healthcare organisation at a particular location i.e. a practice, clinic, facility, or hospital. The authoritative source for healthcare services is the healthcare provider organisation that provides the service(s). |
| [HC Location](StructureDefinition-hc-location.md) | This profile defines a healthcare location (can also be referred as 'location') reflects the place, a site of care i.e. a practice, clinic, hospital, or facility at which healthcare services are provided by the healthcare organisation. The healthcare location can be a physical, mobile, or virtual location. In certain cases, a healthcare location can also represent a site of care within the hospital or building premises such as consulting room, operating room, outpatient room, unit, ward (e.g. maternity ward), department (e.g. emergency department) etc. |
| [HC Organization](StructureDefinition-hc-organization.md) | This profile defines a provider directory entry for an organisation. |
| [HC Practitioner](StructureDefinition-hc-practitioner.md) | This profile defines Healthcare Provider Individual details who is delivering health related services. |
| [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md) | This profile defines a practitioner in role for an organisation at a location providing a healthcare service. |
| [HC Provenance](StructureDefinition-hc-provenance.md) | This profile of Provenance is used to record an activity performed by the HC service (conditionally on behalf of a participating organisation when the target element references a HC Organization resource) whereby specific data elements of a HC Organization or HC Practitioner resource have been initially retrieved, updated or verified from an external system of record. |
| [HC Service Coverage Area](StructureDefinition-hc-service-coverage-area.md) | This profile of Location represents an Australian geographic coverage area i.e. postcodes where this service is provided. For a healthcare service, that is provided through a physical location but have eligibility restrictions applicable in terms of only residents for certain postcodes/suburbs can receive this service, then the details of coverage area and eligibility should be provided here. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Endpoint Identifier (HC-EPI)](StructureDefinition-hc-endpoint-identifier.md) | This identifier profile defines a unique identifier allocated to a healthcare endpoint, in a Health Connect provider directory context. |
| [HC HPI-O](StructureDefinition-hc-hpio.md) | This identifier profile extends the AU HPI-O profile to include an organization classification extension to indicate whether the organization is a 'seed' or 'network' type. |
| [HC HSP-O](StructureDefinition-hc-hspo.md) | This identifier profile defines a Healthcare Support Service Provider Organisation in an Australian context. An HSP-O is assigned under the HI Service to a service (in-home care support and personal care services) where healthcare is provided. A HSP-O can only be of 'seed' type. An Organization cannot be assigned both an HPI-O and an HSP-O; only one identifier is assigned by the HI Service. |
| [HC PCA Healthcare Service Identifier (PCA-HSI)](StructureDefinition-pca-hsi.md) | Identifier for a healthcare service as allocated by PCA. |
| [HC Professional Registration Number (HC-PRN)](StructureDefinition-hc-prn.md) | This identifier profile defines a professional registration number allocated to a healthcare practitioner, in a Health Connect provider directory context. |
| [HC SMD Target Identifier (HC-SMDTI)](StructureDefinition-hc-smd-target-identifier.md) | This identifier profile defines a SMD target identifier allocated to a healthcare practitioner, in a Health Connect provider directory context. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Accept New Patient](StructureDefinition-hc-accept-new-patient.md) | Indicates whether the healthcare service is accepting new patients. Patterned after PCA New Patient Availability extension.Context of Use: HealthcareService |
| [HC Active Period](StructureDefinition-hc-active-period.md) | The period during which the HealthcareService is considered active in the Health Connect directory. Patterned after PCA Active Period. |
| [HC Amenity](StructureDefinition-hc-amenity.md) | Physical features or amenities available within, or in close proximity of, a location. Patterned after PCA Amenity. |
| [HC IAR Levels of Care](StructureDefinition-hc-iar-levels-of-care.md) | Indicates the IAR (Initial Assessment and Referral) Levels of Care for a healthcare service. Patterned after PCA IAR Levels of Care extension.Context of Use: HealthcareServiceCodes from: http://ns.electronichealth.net.au/hc/CodeSystem/hc-iar-levels-of-care |
| [HC Organization Classification](StructureDefinition-hc-org-classification.md) | Extension to record whether an organisation's HPIO is a 'seed' or 'network' type in the HI service. |
| [HC Practitioner Role Communication](StructureDefinition-hc-practitioner-role-communication.md) | Health Connect Practitioner Role Communication. This extension captures communication preferences and capabilities for a practitioner in a given role. |
| [HC Preferred Name](StructureDefinition-hc-preferred-name.md) | This extension applies to PractitionerRole, and represents a name by which a practitioner chooses to be known in the context of the delivery of a specific healthcare service. |
| [HC Preferred Postal Address](StructureDefinition-hc-preferred-postal-address.md) | Preferred postal/mailing address for correspondence (PO Box or mailing address) that is distinct from the registered physical address. |
| [HC Referral Information for Referrer](StructureDefinition-hc-referral-information-for-referrer.md) | Referral instructions and information for healthcare service providers that may wish to refer patients / clients to the healthcare service. Modeled after PCA but for Health Connect context. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Amenity ValueSet](ValueSet-HCAmenityVs.md) | A value set of amenities or facilities available at or near Health Connect locations. |
| [HC Australian Endpoint Payload Types](ValueSet-hc-endpoint-payload-type-vs.md) | The Australian Endpoint Payload Types value set enumerates well known endpoint payload types. |
| [HC Australian Service Interfaces](ValueSet-hc-service-interfaces-vs.md) | The Health Connect Australian Service Interfaces value set enumerates well known service interfaces that can be used for specifying a connection type. |
| [HC Gender Identity ValueSet](ValueSet-HCGenderIdentityVs.md) | A value set of gender identities recognised by Health Connect. |
| [HC IAR Levels of Care ValueSet](ValueSet-hc-iar-levels-of-care-vs.md) | All codes from the Health Connect IAR Levels of Care CodeSystem are for use in the context of the hc-iar-levels-of-care extension. |
| [HC Organization Classification ValueSet](ValueSet-hc-org-classification-vs.md) | The Health Connect ValueSet referencing the HC Organization Classification CodeSystem (seed, network). |
| [HC Service Delivery Location Role Type ValueSet](ValueSet-hc-service-delivery-location-role-type.md) | The Health Connect value set for service delivery location role types, based on PCA's ValueSet but with HC context. |
| [HC Service Eligibility ValueSet](ValueSet-hc-service-eligibility-vs.md) | The Health Connect value set for service eligibility, modeled after PCA's eligibility value set. Codes represent eligibility requirements for healthcare services. |
| [HC Service Provision Code](ValueSet-hc-service-provision-code-vs.md) | The HC Service Provision Code value set includes values that may be used to identify the service provision condition of a healthcare service in HC. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [HC Amenity CodeSystem](CodeSystem-HCAmenity-cs.md) | A code system for amenities or facilities relevant to Health Connect (HC) locations. |
| [HC Australian Endpoint Payload Types](CodeSystem-hc-endpoint-payload-type-cs.md) | The Endpoint Payload Types code system defines concepts that identify well known endpoint payload types. |
| [HC Australian Service Interfaces](CodeSystem-hc-service-interfaces-cs.md) | The Australian Secure Message Service Interfaces code system defines concepts that identify service interfaces for secure message delivery. |
| [HC IAR Levels of Care CodeSystem](CodeSystem-hc-iar-levels-of-care.md) | The Health Connect IAR Levels of care code system defines concepts for the levels of care that the service provides, as defined by the National Initial Assessment and Referral (IAR) for Mental Healthcare Guidance (IAR Guidance) and IAR Decision Support Tool. |
| [HC Organization Classification CodeSystem](CodeSystem-hc-org-classification-cs.md) | Internal code system that describes whether an organisation is a 'seed' or 'network' type used by Health Connect. |
| [HC Service Eligibility CodeSystem](CodeSystem-hc-service-eligibility-cs.md) | Health Connect code system for service eligibility, modeled after PCA's eligibility code system. Codes represent eligibility requirements for healthcare services. |
| [HC Service Provision Code](CodeSystem-hc-service-provision-code-cs.md) | The HC Service Provision Code code system defines a concept (in addition to those defined in[Service Provision Conditions Australian Concepts](https://hl7.org.au/fhir/4.1.0/CodeSystem-service-provision-conditions.html)that may be used to identify the service provision condition of a healthcare service in HC. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [HC Endpoint - SMD Target Example](Endpoint-example-hc-endpoint-smd.md) | Example of a Health Connect endpoint with SMD target identifier for secure messaging. |
| [Health Connect - Example Aged Care Facility](Organization-example-healthconnect-organization-1.md) | An example Aged Care Facility that conforms to[Health Connect Organization - Organization](StructureDefinition-hc-organization.md)profile. |
| [Health Connect - Example Location Service Coverage Area](Location-example-healthconnect-Location-service-coverage-area.md) | An example of Location that conforms to[Health Connect Location - Service Coverage Area](StructureDefinition-hc-service-coverage-area.md)profile. |
| [Health Connect - Example Physical location with wheelchair access](Location-example-healthconnect-Physical-location-with-wheelchair-access-1.md) | An example of Location that conforms to[Health Connect Location - location](StructureDefinition-hc-location.md)profile. |
| [Health Connect - Example Virtual Telehealth Service](Location-example-healthconnect-virtual-telehealth-service-1.md) | An example of a virtual Location (telehealth service) that conforms to the Health Connect Location profile. This is a virtual/telehealth service and therefore does not include a physical address that conforms to[HealthConnect Location - location](StructureDefinition-hc-location.md)profile. |
| [Health Connect - External HC Practitioner Record](Practitioner-external-hc-practitioner-record.md) | Example of a practitioner record with PRN type identifier from the HC (Health Connect) system that serves as the source for provenance tracking that conforms to[Health Connect Practitioner - Practitioner](StructureDefinition-hc-practitioner.md)profile. |
| [Health Connect - HealthcareService example](HealthcareService-example-healthconnect-healthcareservice-1.md) | An example of a HealthcareService with Medicare provider number that conforms[Health Connect HealthcareService - HealthcareService](StructureDefinition-hc-healthcareservice.md)profile. |
| [Health Connect - Helen Mayo](Practitioner-example-healthconnect-practitioner-1.md) | An example of practitioner Helen Mayo at Down under hospital that conforms to[Health Connect Practitioner - Practitioner](StructureDefinition-hc-practitioner.md)profile. |
| [Health Connect - PractitionerRole example](PractitionerRole-example-healthconnect-practitionerrole-1.md) | An example of a practitionerrole with Medicare provider number that conforms[Health Connect PractitionerRole - PractitionerRole](StructureDefinition-hc-practitionerrole.md)profile. |
| [Health Connect Provenance - Track Practitioner Name Amendment](Provenance-provenance-practitioner-name-update.md) | Example showing provenance tracking when a practitioner's family name is updated in the Health Connect directory from an external source system. This demonstrates how specific data elements can be tracked for audit and compliance purposes that conforms to[Health Connect Provenance - Provenance](StructureDefinition-hc-provenance.md)profile. |
| [Health Connect Provenance - Track Practitioner Phone Amendment](Provenance-provenance-practitioner-phone-update.md) | Example demonstrating provenance tracking when a practitioner's phone number is updated in the Health Connect directory from an external source system. This shows how telecom data elements can be precisely tracked using FHIRPath expressions for granular audit trails that conforms to[HealthConnect Provenance - Provenance](StructureDefinition-hc-provenance.md)profile. |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

