# HC PCA Healthcare Service Identifier (PCA-HSI) - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC PCA Healthcare Service Identifier (PCA-HSI)**

## Data Type Profile: HC PCA Healthcare Service Identifier (PCA-HSI) 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/pca-hsi | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:PCAHealthcareServiceIdentifier |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
Identifier for a healthcare service as allocated by PCA. 

No data is entered directly into Health Connect; all directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### PCA healthcare service identifier extension

The PCA Healthcare Service Identifier (PCA-HSI) extension defines an identifier for a healthcare service as allocated by the Provider Connect Australia (PCA) system. This extension is used to capture the PCA-allocated identifier for a HealthcareService resource within the Health Connect directory.

**Usage context:**

* The extension is applied to the `identifier` element of HealthcareService resources, specifically to represent the PCA-allocated identifier alongside other identifiers (such as the Health Connect Healthcare Service Identifier).
* It is referenced by the [`HC HealthcareService`](StructureDefinition-hc-healthcareservice.md) profile, which supports multiple identifiers for a healthcare service, including those issued by PCA and Health Connect.
* The extension ensures that the PCA identifier is preserved and available for reconciliation, traceability, and interoperability between Health Connect and PCA systems.

**Key requirements:**

* The `system` element is fixed to the PCA identifier system URL: `http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-healthcare-service-identifier`.
* The `value` element is required and holds the PCA-allocated identifier value for the healthcare service.

**Usage notes:**

* Use this extension when a healthcare service listed in Health Connect has a corresponding record in PCA and a PCA-allocated identifier is available.
* The PCA-HSI should not be confused with the Health Connect Healthcare Service Identifier (HC-HSI), which is issued by Health Connect itself.
* Both identifiers may be present on a HealthcareService resource to support cross-system reconciliation and data integrity.

Implementers must ensure that the PCA Healthcare Service Identifier extension is used only for PCA-issued identifiers and that the system and value are populated according to the extension definition. This supports accurate mapping and interoperability between Health Connect and PCA directories.

**Usages:**

* This DataType Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/pca-hsi)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-pca-hsi.csv), [Excel](StructureDefinition-pca-hsi.xlsx), [Schematron](StructureDefinition-pca-hsi.sch) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "pca-hsi",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/pca-hsi",
  "version" : "0.1.0-preview",
  "name" : "PCAHealthcareServiceIdentifier",
  "title" : "HC PCA Healthcare Service Identifier (PCA-HSI)",
  "status" : "draft",
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Identifier for a healthcare service as allocated by PCA.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "short" : "PCA-allocated identifier system for healthcare service.",
        "min" : 1,
        "fixedUri" : "http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-healthcare-service-identifier"
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "short" : "PCA-allocated identifier value for healthcare service.",
        "min" : 1
      }
    ]
  }
}

```
