# HC Professional Registration Number (HC-PRN) - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Professional Registration Number (HC-PRN)**

## Data Type Profile: HC Professional Registration Number (HC-PRN) 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/StructureDefinition/hc-prn | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:HCProfessionalRegistrationNumber |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
This identifier profile defines a professional registration number allocated to a healthcare practitioner, in a Health Connect provider directory context. 

No data is entered directly into Health Connect; all directory content is sourced from authoritative systems including [PCA](https://developer.digitalhealth.gov.au/fhir/provider-connect-australia/current/index.html?src=/), HI-Service, and NHSD.

### HC Professional Registration Number (PRN)

The HC Professional Registration Number (PRN) profile defines an identifier for a healthcare practitioner’s professional registration, as recorded in the Health Connect provider directory context. This identifier is used to capture the registration number assigned by a professional association or peak body, particularly for practitioners who are not Ahpra-registered, and is recorded against the HPI-I record.

### Usage notes

* This is a profile of the `identifier` element on [HC Practitioner](https://healthconnect-ig.example.org/StructureDefinition-hc-practitioner) and [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md).
* Use this profile when a practitioner's professional registration number is issued by a non-Ahpra professional association or peak body.
* **Cardinality differences**: HC Practitioner allows 0 to many PRN identifiers (`0..*`), while HC PractitionerRole allows only 0 to 1 PRN identifier (`0..1`).
* The PRN should be used in addition to, or instead of, an Ahpra registration number, depending on the practitioner’s registration status.
* Ensure that the system and value are populated according to the assigning authority’s requirements for accurate identification and interoperability.
* The PRN enables implementers to distinguish between different types of practitioner registration numbers and to support directory queries, reconciliation, and validation.

#### Key requirements

* The profile fixes the `type` element to the v2 identifier code `PRN` (Provider number) from the v2-0203 code system (this is implemented in the profile as `type = $v2-0203-int#PRN`). Implementations SHOULD use the following coding when constructing the `type` element: 

```
  {
      "coding": [
          {
              "system": "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code": "PRN",
              "display": "Provider number"
          }
      ]
  }

```

 
* The `system` element is mandatory (cardinality 1.. in the profile) and is constrained to `http://ns.electronichealth.net.au/hc/id/prn`. Publishers MUST use this URI as the system value for all PRN instances.
* The `value` element is mandatory (cardinality 1..) and holds the practitioner’s registration number as assigned by the authority (for example `1234567`).
* The `assigner` element is not constrained by this profile (it may be populated to reference the issuing organisation where available, but it is not required). Implementers are encouraged to populate `assigner` to improve provenance and traceability when the issuing Organization resource is available.
* Ensure all required elements (`type`, `system`, `value`) are populated according to the assigning authority’s rules to support interoperability and accurate identification.

Implementers must ensure that the HC Professional Registration Number is used only for valid, assigned registration numbers and that all required elements are present and correct. This supports accurate practitioner identification and data integrity across the Health Connect directory.

**Usages:**

* Use this DataType Profile: [HC Practitioner](StructureDefinition-hc-practitioner.md) and [HC PractitionerRole](StructureDefinition-hc-practitionerrole.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/au.digitalhealth.r4.healthconnect|current/StructureDefinition/hc-prn)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-hc-prn.csv), [Excel](StructureDefinition-hc-prn.xlsx), [Schematron](StructureDefinition-hc-prn.sch) 

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hc-prn",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://ns.electronichealth.net.au/hc/ImplementationGuide/au.digitalhealth.r4.healthconnect"
          }
        ]
      }
    }
  ],
  "url" : "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-prn",
  "version" : "0.1.0-preview",
  "name" : "HCProfessionalRegistrationNumber",
  "title" : "HC Professional Registration Number (HC-PRN)",
  "status" : "draft",
  "date" : "2025-11-20T03:42:16+00:00",
  "publisher" : "Australian Digital Health Agency",
  "contact" : [
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://example.org/example-publisher"
        },
        {
          "system" : "email",
          "value" : "help@digitalhealth.gov.au"
        }
      ]
    },
    {
      "name" : "Australian Digital Health Agency",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:help@digitalhealth.gov.au",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This identifier profile defines a professional registration number allocated to a healthcare practitioner, in a Health Connect provider directory context.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "jurisdiction"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:iso:std:iso:3166",
            "code" : "AU",
            "display" : "Australia"
          }
        ]
      }
    }
  ],
  "copyright" : "Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See [https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/)",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier",
        "short" : "Professional Registration Number",
        "definition" : "Professional Registration Number that the practitioner has with Professional association / Peak body association (for non-Ahpra registered practitioners), as recorded against the HPI-I record."
      },
      {
        "id" : "Identifier.type",
        "path" : "Identifier.type",
        "short" : "Coded identifier type for professional registration number",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "PRN"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "short" : "Professional registration number system.",
        "definition" : "Namespace for the professional registration number.",
        "mustSupport" : true
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "short" : "Professional registration number value.",
        "definition" : "Professional registration number value.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Identifier.assigner",
        "path" : "Identifier.assigner",
        "mustSupport" : true
      },
      {
        "id" : "Identifier.assigner.display",
        "path" : "Identifier.assigner.display",
        "short" : "Text alternative for the Organization",
        "mustSupport" : true
      }
    ]
  }
}

```
