# Health Connect Provenance - Track Practitioner Name Amendment - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect Provenance - Track Practitioner Name Amendment**

## Example Provenance: Health Connect Provenance - Track Practitioner Name Amendment

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [HC Provenance](StructureDefinition-hc-provenance.md)

Provenance for [Practitioner Helen Mayo (official)](Practitioner-example-healthconnect-practitioner-1.md)

Summary

| | |
| :--- | :--- |
| Recorded | 2025-09-15 14:30:15+1000 |
| Activity | revise |

**Agents**

* **who**: [Organization Example Aged Care Facility](Organization-example-healthconnect-organization-1.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Provenance",
  "id" : "provenance-practitioner-name-update",
  "meta" : {
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-provenance"
    ]
  },
  "target" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/targetPath",
          "valueString" : "name[0].family"
        }
      ],
      "reference" : "Practitioner/example-healthconnect-practitioner-1"
    }
  ],
  "recorded" : "2025-09-15T14:30:15.123+10:00",
  "activity" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-DataOperation",
        "code" : "UPDATE"
      }
    ]
  },
  "agent" : [
    {
      "who" : {
        "reference" : "Organization/example-healthconnect-organization-1"
      }
    }
  ],
  "entity" : [
    {
      "role" : "source",
      "what" : {
        "reference" : "Practitioner/external-hc-practitioner-record"
      }
    }
  ]
}

```
