# Health Connect - External HC Practitioner Record - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect - External HC Practitioner Record**

## Example Practitioner: Health Connect - External HC Practitioner Record

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [HC Practitioner](StructureDefinition-hc-practitioner.md)

> **Person Recorded Sex Or Gender**
* value: Male

> **Individual Gender Identity**
* value: Male gender identity

**identifier**: National provider identifier/8003616566719020

**name**: John Fryer (Official), John Fryer 

**telecom**: [+61 2 8555 0199](tel:+61285550199), [+61 2 7777 0199](tel:+61277770199)

### Qualifications

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Identifier** | **Code** | **Issuer** |
| * | Professional Registration Number (PRN)/PRN-123456 (use: official, ) | Pathologist | RCPA |

**communication**: Italian

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "external-hc-practitioner-record",
  "meta" : {
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/administrative-gender",
                "code" : "male",
                "display" : "Male"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "446151000124109",
                "display" : "Male gender identity"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NPI"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpii/1.0",
      "value" : "8003616566719020"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Fryer",
      "given" : ["John"],
      "prefix" : ["Dr"]
    },
    {
      "use" : "usual",
      "family" : "Fryer",
      "given" : ["John"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+61 2 8555 0199",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "+61 2 7777 0199",
      "use" : "home"
    }
  ],
  "qualification" : [
    {
      "identifier" : [
        {
          "use" : "official",
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                "code" : "PRN"
              }
            ],
            "text" : "Professional Registration Number (PRN)"
          },
          "system" : "http://ns.electronichealth.net.au/hc/id/prn",
          "value" : "PRN-123456"
        }
      ],
      "code" : {
        "text" : "Pathologist"
      },
      "issuer" : {
        "display" : "RCPA"
      }
    }
  ],
  "communication" : [
    {
      "coding" : [
        {
          "system" : "urn:ietf:bcp:47",
          "code" : "it",
          "display" : "Italian"
        }
      ]
    }
  ]
}

```
