# Health Connect - Helen Mayo - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect - Helen Mayo**

## Example Practitioner: Health Connect - Helen Mayo

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Last updated: 2025-08-25 14:30:00+1000

Profile: [HC Practitioner](StructureDefinition-hc-practitioner.md)

> **Person Recorded Sex Or Gender**
* value: Female

> **Individual Gender Identity**
* value: Female gender identity

**identifier**: National provider identifier/8003616566719020

**name**: Helen Mayo (Official), Helen Mayo 

**telecom**: [+61412345678](tel:+61412345678), [helen.mayo@example.com](mailto:helen.mayo@example.com)

### Qualifications

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Identifier** | **Code** | **Issuer** |
| * | Australian Health Practitioner Regulation Agency Registration Number/MED0000932945 | Medical Practitioner | Ahpra |

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "example-healthconnect-practitioner-1",
  "meta" : {
    "lastUpdated" : "2025-08-25T14:30:00+10:00",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-practitioner"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/administrative-gender",
                "code" : "female",
                "display" : "Female"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender"
    },
    {
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "446141000124107",
                "display" : "Female gender identity"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity"
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NPI"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpii/1.0",
      "value" : "8003616566719020"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Mayo",
      "given" : ["Helen"],
      "prefix" : ["Dr"]
    },
    {
      "use" : "usual",
      "family" : "Mayo",
      "given" : ["Helen"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+61412345678",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "helen.mayo@example.com",
      "use" : "home"
    }
  ],
  "qualification" : [
    {
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
                "code" : "AHPRA"
              }
            ]
          },
          "system" : "http://hl7.org.au/id/ahpra-registration-number",
          "value" : "MED0000932945"
        }
      ],
      "code" : {
        "text" : "Medical Practitioner"
      },
      "issuer" : {
        "display" : "Ahpra"
      }
    }
  ]
}

```
