# HC Endpoint - SMD Target Example - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **HC Endpoint - SMD Target Example**

## Example Endpoint: HC Endpoint - SMD Target Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Information Source: [http://ns.electronichealth.net.au/id/source/pca](http://ns.electronichealth.net.au/id/source/pca)

Profile: [HC Endpoint](StructureDefinition-hc-endpoint.md)

**Encryption Certificate PEM X509**: LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSURYVENDQWtXZ0F3SUJBZ0lKQU1mK0R6UjBWV...

**identifier**: `http://ns.electronichealth.net.au/smd/target`/SMD001234567890, Resource Identifier/EP001234567890

**status**: Active

**connectionType**: endpoint-connection-type: secure-messaging (Secure Messaging)

**name**: Sydney General Hospital SMD Endpoint

**contact**: [smd-support@sydneyhospital.org.au](mailto:smd-support@sydneyhospital.org.au)

**payloadType**: HL7 V2.4 REF message (Level 2)

**payloadMimeType**: application/pdf, application/fhir+xml, application/fhir+json

**address**: [https://smd.sydneyhospital.org.au/secure-messaging/endpoint](https://smd.sydneyhospital.org.au/secure-messaging/endpoint)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "example-hc-endpoint-smd",
  "meta" : {
    "source" : "http://ns.electronichealth.net.au/id/source/pca",
    "profile" : [
      "http://ns.electronichealth.net.au/hc/StructureDefinition/hc-endpoint"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/encryption-certificate-pem-x509",
      "valueString" : "LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSURYVENDQWtXZ0F3SUJBZ0lKQU1mK0R6UjBWV..."
    }
  ],
  "identifier" : [
    {
      "system" : "http://ns.electronichealth.net.au/smd/target",
      "value" : "SMD001234567890"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RI",
            "display" : "Resource Identifier"
          }
        ]
      },
      "system" : "http://example.org/fhir/identifier/endpoint",
      "value" : "EP001234567890"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org.au/CodeSystem/endpoint-connection-type",
    "code" : "secure-messaging",
    "display" : "Secure Messaging"
  },
  "name" : "Sydney General Hospital SMD Endpoint",
  "contact" : [
    {
      "system" : "email",
      "value" : "smd-support@sydneyhospital.org.au",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://ns.electronichealth.net.au/hc/CodeSystem/hc-endpoint-payload-type-cs",
          "code" : "http://ns.hl7.org.au/hl7v2/profiles/HL7AU-OO-REF-SIMPLIFIED-201706",
          "display" : "HL7 V2.4 REF message (Level 2)"
        }
      ]
    }
  ],
  "payloadMimeType" : [
    "application/pdf",
    "application/fhir+xml",
    "application/fhir+json"
  ],
  "address" : "https://smd.sydneyhospital.org.au/secure-messaging/endpoint"
}

```
