# Health Connect Reader Actor - Health Connect Australia Provider Directory FHIR Implementation Guide v0.1.0-preview

![](assets/images/adha-logo-light.svg)

# Health Connect Australia Provider Directory FHIR Implementation Guide

0.1.0-preview - Preview

*  [FHIR IGs](https://developer.digitalhealth.gov.au/fhir) 
*  [Developer Portal](https://developer.digitalhealth.gov.au) 
*  [Agency site](https://www.digitalhealth.gov.au) 

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Connect Reader Actor**

## ActorDefinition: Health Connect Reader Actor 

| | |
| :--- | :--- |
| *Official URL*:http://ns.electronichealth.net.au/hc/ActorDefinition/reader-actor-health-connect | *Version*:0.1.0-preview |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | *Computable Name*:ReaderActorHealthConnect |
| **Usage:**Jurisdiction: Australia | |
| **Copyright/Legal**: Copyright © 2025 Australian Digital Health Agency - All rights reserved. This content is licensed under a Creative Commons Attribution 4.0 International License. See[https://creativecommons.org/licenses/by/4.0/](https://creativecommons.org/licenses/by/4.0/) | |

 
The Health Connect Reader actor represents a system that is requesting an**Health Connect Directory details**for a particular practitioner from the Health Connect system. 

* **Actor: ReaderActorHealthConnect**: * **SHALL** implement the [mandatory](conformance.md) requirements for the elements defined as such in this implementation guide.
* **SHALL** implement the required REST API interactions and search parameters as defined in the HealthConnect Reader Capability Statement.

* **Actor: ReaderActorHealthConnect**: Capabilities:
  * Health Connect Reader Actor: [Health Connect Reader](CapabilityStatement-health-connect-reader.md)

![](assets/images/adha-logo-light.svg)

IG © 2025+ [Australian Digital Health Agency](http://example.org/example-publisher). Package au.digitalhealth.r4.healthconnect#0.1.0-preview based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-11-20

Links: [Table of Contents](toc.md) | [QA Report](qa.md) | [Version History](https://fhir.digitalhealth.gov.au/dh/history.html) | [Report an issue or propose a change](mailto:help@digitalhealth.gov.au) 

Publisher: [Australian Digital Health Agency](https://www.digitalhealth.gov.au) | ABN: 84 425 496 912, Level 25, 175 Liverpool Street, Sydney, NSW 2000 | Phone: [1300 901 001](tel:1300901001) | Email: [help@digitalhealth.gov.au](mailto:help@digitalhealth.gov.au) | [https://www.digitalhealth.gov.au](https://www.digitalhealth.gov.au) | [Privacy policy](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/privacy-policy) | [Terms of Use](https://www.digitalhealth.gov.au/about-us/policies-privacy-and-reporting/terms-of-use)

![](cc0.png)
The Australian Digital Health Agency acknowledges the Traditional Custodians of Country throughout Australia, and their continuing connection to land, sea and community. We pay our respects to them and their cultures, and to Elders, past and present.

