# silfhirprofileig#0.1.0: SGHI FHIR Profile Implementation Guide

## Pages

* [Home](index.md)
* [Artifacts Summary](artifacts.md)

## Resources

### CodeSystems

* [International Classification for Diseases version 10, WHO](CodeSystem-ICD-10-WHO.md)
* [International Classification for Diseases version 11, WHO](CodeSystem-ICD-11-WHO.md)
* [KNC4Drugs](CodeSystem-KNC4Drugs.md)
* [KNC4Investigations](CodeSystem-KNC4Investigations.md)
* [SGHIConditionSeverityCodeSystem](CodeSystem-SGHIConditionSeverityCodeSystem.md)
* [SGHIDefaultIdentifierCodeSystem](CodeSystem-SGHIDefaultIdentifierCodeSystem.md)
* [SGHIOrganisationIdentifierCodeSystem](CodeSystem-SGHIOrganisationIdentifierCodeSystem.md)
* [SGHIPersonIdentifierCodeSystem](CodeSystem-SGHIPersonIdentifierCodeSystem.md)
* [SGHI Identifier Code System](CodeSystem-identifier-codesystem.md)
* [Legacy Identifier Types (Deprecated)](CodeSystem-legacy-identifier-types.md)
* [SGHI LOINC Code System](CodeSystem-loinc-codesystem.md)
* [Retired CIEL Codes](CodeSystem-retired-ciel-codes.md)
* [Retired FHIR R4 Codes](CodeSystem-retired-fhrr4-codes.md)
* [SGHI Service Request CodeSystem](CodeSystem-service-request-cs.md)
* [SGHI Specialty Code System](CodeSystem-specialtycodesystem.md)

### ValueSets

* [Dose Form](ValueSet-DoseForm.md)
* [All ICD-11 codes](ValueSet-ICD11Codes.md)
* [All ICHI codes](ValueSet-ICHICodes.md)
* [Route Of Administration](ValueSet-RouteOfAdministration.md)
* [All LOINC Codes](ValueSet-all-loinc-codes.md)
* [SGHI Bed Status](ValueSet-bed-status.md)
* [Behaviour Value Sets](ValueSet-behaviour.md)
* [Blood Pressure Units](ValueSet-blood-pressure-units.md)
* [SGHI Body Site Value Set](ValueSet-body-site-value-set.md)
* [Cancer Stages Value Sets](ValueSet-cancer-stages.md)
* [condition-severity](ValueSet-condition-severity.md)
* [SGHI Contact Point Use](ValueSet-contact-point-use.md)
* [SGHI Contact Relationship Types](ValueSet-contact-relationship.md)
* [SGHI Contact System](ValueSet-contact-system.md)
* [SGHI Default Code Value Sets](ValueSet-default-code.md)
* [SGHI Default Identifier Types](ValueSet-default-identifier-types.md)
* [SGHI Diagnostic Conclusion ICD-11](ValueSet-diagnostic-conclusion-icd11.md)
* [Distance Metastatis Value Sets](ValueSet-distance-metastatis.md)
* [SGHI Drugs Identifier Types](ValueSet-drugs-identifier-type.md)
* [SGHI Encounter Priority](ValueSet-encounter-act-priority.md)
* [Encounter Class Value Sets](ValueSet-encounter-class.md)
* [Grade Value Sets](ValueSet-grade.md)
* [Hormone Receptor Status](ValueSet-hormone-receptor-status.md)
* [SGHI Investigation Codes](ValueSet-investigation-codes.md)
* [Investigations](ValueSet-investigations.md)
* [Laterality Value Sets](ValueSet-laterality.md)
* [SGHI Location Form](ValueSet-location-form.md)
* [SGHI Location Mode](ValueSet-location-mode.md)
* [SGHI Medication Codes](ValueSet-medication-codes.md)
* [SGHI Medication Form Codes](ValueSet-medication-form-codes.md)
* [SGHI Method Of Medication Administration](ValueSet-method-of-administration.md)
* [Molecular Markers Value Sets](ValueSet-molecular-Markers.md)
* [SGHI Organization Identifier Types](ValueSet-organization-identifier-types.md)
* [SGHI Person Identifier Types](ValueSet-patient-identifier-types.md)
* [SGHI Practitioner Value Set](ValueSet-practitioner-role-value-set.md)
* [SGHI Practitioner Value Set](ValueSet-practitioner-specialty-value-set.md)
* [SGHI Procedure Category value set](ValueSet-procedure-category.md)
* [SGHI Procedure follow up codes](ValueSet-procedure-follow-up-codes.md)
* [SGHI Procedure outcome value set](ValueSet-procedure-outcome.md)
* [SGHI Procedure status value set](ValueSet-procedure-status.md)
* [Route Of Administration](ValueSet-route-of-administration.md)
* [Service Request Categories](ValueSet-service-request-category.md)
* [speciality](ValueSet-speciality.md)
* [Specimen Type Value Sets](ValueSet-specimentype.md)
* [SGHI Substance Codes](ValueSet-substance-codes.md)
* [Type Of Test Value Sets](ValueSet-typeoftest.md)

### Complex-type Profiles

* [SGHI Annotation](StructureDefinition-annotation.md)
* [SGHI Attachment](StructureDefinition-attachment.md)
* [SGHI CodeableReference](StructureDefinition-codeable-reference.md)
* [SGHI CodeableConcept](StructureDefinition-codeableconcept.md)
* [SGHI ContactPoint](StructureDefinition-contact-point.md)
* [SGHI Dosage](StructureDefinition-dosage.md)
* [SGHI HumanName](StructureDefinition-human-name.md)
* [SGHI Reference](StructureDefinition-reference.md)

### Resource Profiles

* [SGHI Activity Defintion Profile](StructureDefinition-activitydefinition.md)
* [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md)
* [SGHI Appointment Profile](StructureDefinition-appointment.md)
* [SGHI Care Plan](StructureDefinition-careplan.md)
* [SGHI Composition](StructureDefinition-composition.md)
* [SGHI Condition](StructureDefinition-condition.md)
* [SGHI Consent](StructureDefinition-consent.md)
* [SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md)
* [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md)
* [SGHI Encounter](StructureDefinition-encounter.md)
* [SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md)
* [SGHI Location](StructureDefinition-fhir-location.md)
* [SGHI Medication](StructureDefinition-medication.md)
* [SGHI Medication Dispense](StructureDefinition-medicationdispense.md)
* [SGHI MedicationRequest](StructureDefinition-medicationrequest.md)
* [SGHI Observation](StructureDefinition-observation.md)
* [SGHI Organization](StructureDefinition-organization.md)
* [SGHI Patient](StructureDefinition-patient.md)
* [SGHI Plan Definition Profile](StructureDefinition-plandefinition.md)
* [SGHI Practitioner](StructureDefinition-practitioner.md)
* [SGHI PractitionerRole](StructureDefinition-practitionerrole.md)
* [SGHI Procedure](StructureDefinition-procedure.md)
* [SGHI RiskAssessment](StructureDefinition-riskassessment.md)
* [SGHI ServiceRequest](StructureDefinition-servicerequest.md)
* [SGHI Specimen](StructureDefinition-specimen.md)
* [SGHI Substance](StructureDefinition-substance.md)
* [SGHI Task](StructureDefinition-task.md)

### ConceptMaps

* [R4 to R5 Category Map](ConceptMap-CIELtoFHIRCategoryCodeBindingsMap.md)
* [CIEL to FHIR Code Map](ConceptMap-CIELtoFHIRRiskAssessmentMap.md)
* [CIEL → ICD-11 Condition Map (generated 2025-07-09)](ConceptMap-CIELtoICD11Condition.md)
* [CIEL to LOINC Observation Code Map](ConceptMap-CIELtoLOINCObservationMap.md)
* [CIEL to LOINC ServiceRequest Code Map](ConceptMap-CIELtoLOINCServiceRequestMap.md)
* [CIEL → LOINC DiagnosticReport .code Map (breast-imaging + chest US)](ConceptMap-CIELtoLoincDiagnosticReportMap.md)
* [R4 to R5 ClinicalStatus Map](ConceptMap-FHIRClinicalStatusMap.md)
* [R4 to R5 Category Map](ConceptMap-FHIRCodeCategoryMap.md)
* [Legacy → SGHI Identifier Types](ConceptMap-LegacyIdentifierToSGHI.md)

### ImplementationGuides

* [SGHI FHIR Profile Implementation Guide](index.md)

### StructureMaps

* [Encounter Transforms: R4 → SGHI R5](StructureMap-AllergyIntoleranceSGHI5.md)
* [Appointment Transforms: R4 → SGHI R5](StructureMap-AppointmentSGHI5.md)
* [Composition Transforms: R4 to SGHI R5](StructureMap-Composition4toSGHI5.md)
* [Condition Transforms: R4 → SGHI R5](StructureMap-ConditionSGHI5.md)
* [Consent Transforms: R4 → SGHI R5](StructureMap-ConsenttoSGHI5.md)
* [DiagnosticReport Transforms: R4 → SGHI R5](StructureMap-DiagnosticReportSGHI5.md)
* [DocumentReference Transforms: R4 to SGHI R5](StructureMap-DocumentReferenceSGHI5.md)
* [Encounter Transforms: R4 → SGHI R5](StructureMap-Encounter4toSGHI5.md)
* [EpisodeOfCare Transforms: R4 → SGHI R5](StructureMap-EpisodeOfCare4toSGHI5.md)
* [ExtractVitalSigns](StructureMap-ExtractVitalSigns.md)
* [Glasgow Coma Scale Extraction](StructureMap-GlasgowCommaScaleExtract.md)
* [MedicationRequest Transforms: R4 → SGHI R5](StructureMap-MedicationRequestSGHI5.md)
* [Observation Transforms: R4 to SGHI R5](StructureMap-Observation4toSGHI5.md)
* [Organization Transforms: R4 → SGHI R5](StructureMap-Organization4toSGHI5.md)
* [Patient Transforms: R4 → SGHI R5](StructureMap-Patient4toSGHI5.md)
* [RiskAssessment Transforms: R4 → SGHI R5](StructureMap-RiskAssessmentR4toSGHIR5.md)
* [ServiceRequest Transforms: R4 → SGHI R5](StructureMap-ServiceRequestSGHI5.md)
* [Task Transforms: R4 → SGHI R5](StructureMap-Task4toSGHI5.md)

### Examples

* [Example ActivityDefinition Title (ActivityDefinition)](ActivityDefinition-ExampleActivityDefintion.md)
* [ExampleSGHIAllergyIntolerance (AllergyIntolerance)](AllergyIntolerance-ExampleSGHIAllergyIntolerance.md)
* [ExampleSGHIAppointment (Appointment)](Appointment-ExampleSGHIAppointment.md)
* [Example CarePlan (CarePlan)](CarePlan-ExampleSGHICarePlan.md)
* [SGHI Discharge Summary for John Doe (Composition)](Composition-ExampleSGHIComposition.md)
* [ExampleSGHICondition (Condition)](Condition-ExampleSGHICondition.md)
* [ExampleSGHIConsent (Consent)](Consent-ExampleSGHIConsent.md)
* [ExampleSGHIDiagnosticReport (DiagnosticReport)](DiagnosticReport-ExampleSGHIDiagnosticReport.md)
* [ExampleSGHIDocumentReference (DocumentReference)](DocumentReference-ExampleSGHIDocumentReference.md)
* [ExampleSGHIEncounter (Encounter)](Encounter-ExampleSGHIEncounter.md)
* [ExampleSGHIEpisodeOfCare (EpisodeOfCare)](EpisodeOfCare-ExampleSGHIEpisodeOfCare.md)
* [SGHI Location (Location)](Location-ExampleSGHILocation.md)
* [ExampleSGHIMedication (Medication)](Medication-ExampleSGHIMedication.md)
* [ExampleSGHIMedicationDispense (MedicationDispense)](MedicationDispense-ExampleSGHIMedicationDispense.md)
* [ExampleSGHIMedicationRequest (MedicationRequest)](MedicationRequest-ExampleSGHIMedicationRequest.md)
* [ExampleSGHIObservation (Observation)](Observation-ExampleSGHIObservation.md)
* [SGHI Healthcare Organization (Organization)](Organization-ExampleSGHIOrganization.md)
* [ExampleSGHIPatient (Patient)](Patient-ExampleSGHIPatient.md)
* [PlanDefinition Title (PlanDefinition)](PlanDefinition-ExampleSGHIPlanDefinition.md)
* [ExampleSGHIPractitioner (Practitioner)](Practitioner-ExampleSGHIPractitioner.md)
* [ExampleSGHIPractitionerRole (PractitionerRole)](PractitionerRole-ExampleSGHIPractitionerRole.md)
* [ExampleSGHIProcedure (Procedure)](Procedure-ExampleSGHIProcedure.md)
* [ExampleSGHIRiskAssessment (RiskAssessment)](RiskAssessment-ExampleSGHIRiskAssessment.md)
* [ExampleSGHIServiceRequest (ServiceRequest)](ServiceRequest-ExampleSGHIServiceRequest.md)
* [ExampleSGHISpecimen (Specimen)](Specimen-ExampleSGHISpecimen.md)
* [ExampleSGHISubstance (Substance)](Substance-ExampleSGHISubstance.md)
* [ExampleSGHITask (Task)](Task-ExampleSGHITask.md)
