# Artifacts Summary - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [SGHI Activity Defintion Profile](StructureDefinition-activitydefinition.md) | This resouce allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context. |
| [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md) | Risk of harmful or undesirable physiological response which is specific to an individual and associated with exposure to a substance. |
| [SGHI Appointment Profile](StructureDefinition-appointment.md) | A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s). |
| [SGHI Care Plan](StructureDefinition-careplan.md) | A profile on the R5 CarePlan resource to represent a patient's treatment or management plan, such as a chemotherapy regimen. |
| [SGHI Composition](StructureDefinition-composition.md) | A set of healthcare-related information that is assembled together into a single logical package that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. A Composition defines the structure and narrative content necessary for a document. However, a Composition alone does not constitute a document. Rather, the Composition must be the first entry in a Bundle where Bundle.type=document, and any other resources referenced from Composition must be included as subsequent entries in the Bundle (for example Patient, Practitioner, Encounter, etc.). |
| [SGHI Condition](StructureDefinition-condition.md) | A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern. |
| [SGHI Consent](StructureDefinition-consent.md) | A record of a healthcare consumer’s choices or choices made on their behalf by a third party, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time. |
| [SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md) | SGHI's profile for DiagnosticReport |
| [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md) | A reference to a document of any kind for any purpose. |
| [SGHI Encounter](StructureDefinition-encounter.md) | An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient. Encounter is primarily used to record information about the actual activities that occurred, where Appointment is used to record planned activities. |
| [SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md) | An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time. |
| [SGHI Location](StructureDefinition-fhir-location.md) | SGHI profile for location |
| [SGHI Medication](StructureDefinition-medication.md) | SGHI's Medication profile for Medication resource |
| [SGHI Medication Dispense](StructureDefinition-medicationdispense.md) | SGHI's profile for Medication Dispense resource |
| [SGHI MedicationRequest](StructureDefinition-medicationrequest.md) | An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called 'MedicationRequest' rather than 'MedicationPrescription' or 'MedicationOrder' to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns. |
| [SGHI Observation](StructureDefinition-observation.md) | Measurements and simple assertions made about a patient, device or other subject. |
| [SGHI Organization](StructureDefinition-organization.md) | SGHI's profile for Organization |
| [SGHI Patient](StructureDefinition-patient.md) | Demographics and other administrative information about an individual or animal receiving care or other health-related services. |
| [SGHI Plan Definition Profile](StructureDefinition-plandefinition.md) | This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. |
| [SGHI Practitioner](StructureDefinition-practitioner.md) | SGHI's Practitioner used in SGHI systems |
| [SGHI PractitionerRole](StructureDefinition-practitionerrole.md) | PractitionerRole describes the types of services that practitioners provide to SGHI Organization at specific location(s). The profile a specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time. |
| [SGHI Procedure](StructureDefinition-procedure.md) | This resource is used to record the details of current and historical procedures performed on, with, or for a patient, practitioner, device, organization, or location. Examples include surgical procedures, diagnostic procedures, endoscopic procedures, biopsies, counseling, physiotherapy, personal support services, adult day care services, non-emergency transportation, home modification, exercise, verification of enrollment qualifications for a social program etc. Procedures may be performed by a healthcare professional, a service provider, a friend or relative or in some cases by the patient themselves. |
| [SGHI RiskAssessment](StructureDefinition-riskassessment.md) | An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome. |
| [SGHI ServiceRequest](StructureDefinition-servicerequest.md) | ServiceRequest represents an order or proposal or plan, as distinguished by ServiceRequest.intent to perform a diagnostic or other service on or for a patient. ServiceRequest represents a proposal or plan or order for a service to be performed that would result in a Procedure or DiagnosticReport, which in turn may reference one or more Observations, which summarize the performance of the procedures and associated documentation such as observations, images, findings that are relevant to the treatment/management of the subject. This resource may be used to share relevant information required to support a referral or a transfer of care request from one practitioner or organization to another when a patient is required to be referred to another provider for a consultation /second opinion and/or for short term or longer term management of one or more health issues or problems. |
| [SGHI Specimen](StructureDefinition-specimen.md) | A sample to be used for analysis. |
| [SGHI Substance](StructureDefinition-substance.md) | Profile for representing substances in the SGHI context |
| [SGHI Task](StructureDefinition-task.md) | SGHI's profile for Task |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [SGHI Annotation](StructureDefinition-annotation.md) | A text note which also contains information about who made the statement and when. |
| [SGHI Attachment](StructureDefinition-attachment.md) | A custom document used for capturing the source of consent |
| [SGHI CodeableConcept](StructureDefinition-codeableconcept.md) | A CodeableConcept represents a value that is usually supplied by providing a reference to one or more terminologies or ontologies but may also be defined by the provision of text. This is a common pattern in healthcare data. |
| [SGHI CodeableReference](StructureDefinition-codeable-reference.md) | A reusable CodeableReference within SGHI systems |
| [SGHI ContactPoint](StructureDefinition-contact-point.md) | A custom contact point with stricter cardinality |
| [SGHI Dosage](StructureDefinition-dosage.md) | A comprehensive Dosage profile for SGHI prescriptions, ensuring structured routes, methods, timing, and dose details. |
| [SGHI HumanName](StructureDefinition-human-name.md) | A specialized human name data type with stricter cardinalities. |
| [SGHI Reference](StructureDefinition-reference.md) | SGHI Reference |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [All ICD-11 codes](ValueSet-ICD11Codes.md) | All codes from ICD-11 |
| [All ICHI codes](ValueSet-ICHICodes.md) | All codes from ICHI |
| [All LOINC Codes](ValueSet-all-loinc-codes.md) | A ValueSet that includes all codes from the LOINC code system. |
| [Behaviour Value Sets](ValueSet-behaviour.md) | Behaviour Value Sets |
| [Blood Pressure Units](ValueSet-blood-pressure-units.md) | Units used for measuring blood pressure. |
| [Cancer Stages Value Sets](ValueSet-cancer-stages.md) | Cancer Stages Value Sets |
| [Distance Metastatis Value Sets](ValueSet-distance-metastatis.md) | Distance Metastatis Value Sets |
| [Dose Form](ValueSet-DoseForm.md) | Version 1 |
| [Encounter Class Value Sets](ValueSet-encounter-class.md) |  |
| [Grade Value Sets](ValueSet-grade.md) | Grade Value Sets |
| [Hormone Receptor Status](ValueSet-hormone-receptor-status.md) | Hormone Receptor Status |
| [Investigations](ValueSet-investigations.md) | First Version |
| [Laterality Value Sets](ValueSet-laterality.md) | Laterality Value Sets |
| [Molecular Markers Value Sets](ValueSet-molecular-Markers.md) | Molecular Markers Value Sets |
| [Route Of Administration](ValueSet-RouteOfAdministration.md) | Version 1 |
| [Route Of Administration](ValueSet-route-of-administration.md) | A ValueSet defining the possible routes of drug administration. |
| [SGHI Bed Status](ValueSet-bed-status.md) | Codes that can be used to indicate the operating status of an organization's location |
| [SGHI Body Site Value Set](ValueSet-body-site-value-set.md) | Custom body site value set |
| [SGHI Contact Point Use](ValueSet-contact-point-use.md) | Code used to indicate contact use |
| [SGHI Contact Relationship Types](ValueSet-contact-relationship.md) | Contact relationship types used in SGHI systems |
| [SGHI Contact System](ValueSet-contact-system.md) | Code used to indicate what communications system is required to make use of the contact. |
| [SGHI Default Code Value Sets](ValueSet-default-code.md) | SGHI Default Code Value Sets |
| [SGHI Default Identifier Types](ValueSet-default-identifier-types.md) | Default identifier types used in SGHI's systems |
| [SGHI Diagnostic Conclusion ICD-11](ValueSet-diagnostic-conclusion-icd11.md) | ICD-11 codes used for diagnostic conclusions in SGHI |
| [SGHI Drugs Identifier Types](ValueSet-drugs-identifier-type.md) | Identifier types used across dm+d hierarchy |
| [SGHI Encounter Priority](ValueSet-encounter-act-priority.md) | Urgency of an encounter |
| [SGHI Investigation Codes](ValueSet-investigation-codes.md) | ValueSet containing SGHI investigation codes |
| [SGHI Location Form](ValueSet-location-form.md) | Physical form of the location, e.g. building, room, vehicle, road, virtual. |
| [SGHI Location Mode](ValueSet-location-mode.md) | Codes that can be used to indicate the mode of a location |
| [SGHI Medication Codes](ValueSet-medication-codes.md) | ValueSet containing SGHI medication codes |
| [SGHI Medication Form Codes](ValueSet-medication-form-codes.md) | ValueSet containing SGHI medication form codes |
| [SGHI Method Of Medication Administration](ValueSet-method-of-administration.md) | Custom methods of administering medication |
| [SGHI Organization Identifier Types](ValueSet-organization-identifier-types.md) | Identifier types used to identify an organization across in SIL's systems |
| [SGHI Person Identifier Types](ValueSet-patient-identifier-types.md) | Identifier types used to identify patient, practitioner, animal or a live actor in the healthcare context in SGHI's systems |
| [SGHI Practitioner Value Set](ValueSet-practitioner-role-value-set.md) | Custom practioner role value set |
| [SGHI Practitioner Value Set](ValueSet-practitioner-specialty-value-set.md) | Custom practioner specialty value set |
| [SGHI Procedure Category value set](ValueSet-procedure-category.md) | A value set for categorizing procedures, using LOINC codes where applicable. |
| [SGHI Procedure follow up codes](ValueSet-procedure-follow-up-codes.md) | Custom follow up procedure codes |
| [SGHI Procedure outcome value set](ValueSet-procedure-outcome.md) | The outcome of the procedure - did it resolve the reasons for the procedure being performed? |
| [SGHI Procedure status value set](ValueSet-procedure-status.md) | A value set for the status of a procedure, based on the FHIR ProcedureStatus codes. |
| [SGHI Substance Codes](ValueSet-substance-codes.md) | ValueSet containing SGHI substance codes |
| [Service Request Categories](ValueSet-service-request-category.md) | A ValueSet categorizing different types of service requests. |
| [Specimen Type Value Sets](ValueSet-specimentype.md) | Specimen Type Value Sets |
| [Type Of Test Value Sets](ValueSet-typeoftest.md) | Type Of Test Value Sets |
| [condition-severity](ValueSet-condition-severity.md) | Condition severity |
| [speciality](ValueSet-speciality.md) | Speciality |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [International Classification for Diseases version 10, WHO](CodeSystem-ICD-10-WHO.md) | Based on ICD102019-covid |
| [International Classification for Diseases version 11, WHO](CodeSystem-ICD-11-WHO.md) | This version contains the latest version of ICD-11 (2024) |
| [KNC4Drugs](CodeSystem-KNC4Drugs.md) | First Version |
| [KNC4Investigations](CodeSystem-KNC4Investigations.md) | First Version |
| [Legacy Identifier Types (Deprecated)](CodeSystem-legacy-identifier-types.md) | Obsolete identifier-type codes encountered in R4 data. |
| [Retired CIEL Codes](CodeSystem-retired-ciel-codes.md) | A collection of CIEL codes formerly in use for clinical observations. |
| [Retired FHIR R4 Codes](CodeSystem-retired-fhrr4-codes.md) | A collection of FHIR R 4 codes formerly in used in R4 |
| [SGHI Identifier Code System](CodeSystem-identifier-codesystem.md) | A single code system enumerating the many local identifier types used across SGHI's environment. |
| [SGHI LOINC Code System](CodeSystem-loinc-codesystem.md) | A a subset of LOINC codes used across SGHI's environment. |
| [SGHI Service Request CodeSystem](CodeSystem-service-request-cs.md) | A custom CodeSystem defining different elements of service requests. |
| [SGHI Specialty Code System](CodeSystem-specialtycodesystem.md) | A Specialty Code System to be used in SGHI's environment. |
| [SGHIConditionSeverityCodeSystem](CodeSystem-SGHIConditionSeverityCodeSystem.md) | A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem. |
| [SGHIDefaultIdentifierCodeSystem](CodeSystem-SGHIDefaultIdentifierCodeSystem.md) | A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem. |
| [SGHIOrganisationIdentifierCodeSystem](CodeSystem-SGHIOrganisationIdentifierCodeSystem.md) | A single code system enumerating the identifier types used identify organisations across SIL's environment. |
| [SGHIPersonIdentifierCodeSystem](CodeSystem-SGHIPersonIdentifierCodeSystem.md) | A code system different identifiers used to identify an animal, patient, practitioner or any other live actior in the healthcare context |

### Terminology: Structure Maps 

These define transformations to convert between data structures used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Appointment Transforms: R4 → SGHI R5](StructureMap-AppointmentSGHI5.md) | AppointmentTransformsR4SGHIR5 |
| [Composition Transforms: R4 to SGHI R5](StructureMap-Composition4toSGHI5.md) | CompositionTransformsR4toSGHIR5 |
| [Condition Transforms: R4 → SGHI R5](StructureMap-ConditionSGHI5.md) | ConditionTransformsR4SGHIR5 |
| [Consent Transforms: R4 → SGHI R5](StructureMap-ConsenttoSGHI5.md) | ConsentTransformsR4SGHIR5 |
| [DiagnosticReport Transforms: R4 → SGHI R5](StructureMap-DiagnosticReportSGHI5.md) | DiagnosticReportTransformsR4SGHIR5 |
| [DocumentReference Transforms: R4 to SGHI R5](StructureMap-DocumentReferenceSGHI5.md) | DocumentReferenceTransformsR4toSGHIR5 |
| [Encounter Transforms: R4 → SGHI R5](StructureMap-AllergyIntoleranceSGHI5.md) | EncounterTransformsR4SGHIR5 |
| [Encounter Transforms: R4 → SGHI R5](StructureMap-Encounter4toSGHI5.md) | EncounterTransformsR4SGHIR5 |
| [EpisodeOfCare Transforms: R4 → SGHI R5](StructureMap-EpisodeOfCare4toSGHI5.md) | EpisodeOfCareTransformsR4SGHIR5 |
| [ExtractVitalSigns](StructureMap-ExtractVitalSigns.md) |  |
| [Glasgow Coma Scale Extraction](StructureMap-GlasgowCommaScaleExtract.md) | Extracts three Observation resources, one per GCS subscore, from a QuestionnaireResponse to the GCS questionnaire. |
| [MedicationRequest Transforms: R4 → SGHI R5](StructureMap-MedicationRequestSGHI5.md) | MedicationRequestTransformsR4SGHIR5 |
| [Observation Transforms: R4 to SGHI R5](StructureMap-Observation4toSGHI5.md) | ObservationTransformsR4toSGHIR5 |
| [Organization Transforms: R4 → SGHI R5](StructureMap-Organization4toSGHI5.md) | OrganizationTransformsR4SGHIR5 |
| [Patient Transforms: R4 → SGHI R5](StructureMap-Patient4toSGHI5.md) | PatientTransformsR4SGHIR5 |
| [RiskAssessment Transforms: R4 → SGHI R5](StructureMap-RiskAssessmentR4toSGHIR5.md) | RiskAssessmentTransformsR4SGHIR5 |
| [ServiceRequest Transforms: R4 → SGHI R5](StructureMap-ServiceRequestSGHI5.md) | ServiceRequestTransformsR4SGHIR5 |
| [Task Transforms: R4 → SGHI R5](StructureMap-Task4toSGHI5.md) | TaskTransformsR4SGHIR5 |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CIEL to FHIR Code Map](ConceptMap-CIELtoFHIRRiskAssessmentMap.md) |  |
| [CIEL to LOINC Observation Code Map](ConceptMap-CIELtoLOINCObservationMap.md) |  |
| [CIEL to LOINC ServiceRequest Code Map](ConceptMap-CIELtoLOINCServiceRequestMap.md) |  |
| [CIEL → ICD-11 Condition Map (generated 2025-07-09)](ConceptMap-CIELtoICD11Condition.md) |  |
| [CIEL → LOINC DiagnosticReport .code Map (breast-imaging + chest US)](ConceptMap-CIELtoLoincDiagnosticReportMap.md) |  |
| [Legacy → SGHI Identifier Types](ConceptMap-LegacyIdentifierToSGHI.md) | Maps obsolete identifier-type codes to the SGHI canonical codes. |
| [R4 to R5 Category Map](ConceptMap-CIELtoFHIRCategoryCodeBindingsMap.md) |  |
| [R4 to R5 Category Map](ConceptMap-FHIRCodeCategoryMap.md) |  |
| [R4 to R5 ClinicalStatus Map](ConceptMap-FHIRClinicalStatusMap.md) |  |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Example ActivityDefinition Title](ActivityDefinition-ExampleActivityDefintion.md) | An example of SGHIActivityDefinition resource |
| [Example CarePlan](CarePlan-ExampleSGHICarePlan.md) | SGHI CarePlan demonstration. |
| [Example SGHI Consent](Consent-ExampleSGHIConsent.md) | An example of consent conforming to the SGHIConsent profile. |
| [Example SGHI Episode of Care](EpisodeOfCare-ExampleSGHIEpisodeOfCare.md) | An example of an episode of care conforming to the SGHIEpisodeOfCare profile. |
| [Example SGHI Organization](Organization-ExampleSGHIOrganization.md) | An example Organization resource conforming to the SGHIOrganization profile. |
| [ExampleSGHIAllergyIntolerance](AllergyIntolerance-ExampleSGHIAllergyIntolerance.md) | An example of an AllergyIntolerance resource conforming to the SGHI AllergyIntolerance profile. |
| [ExampleSGHIAppointment](Appointment-ExampleSGHIAppointment.md) | An example of an Appointment resource conforming to the SGHI Appointment profile. |
| [ExampleSGHICondition](Condition-ExampleSGHICondition.md) | An example of a Condition resource conforming to the SGHI Condition profile. |
| [ExampleSGHIDiagnosticReport](DiagnosticReport-ExampleSGHIDiagnosticReport.md) | An example of an DiagnosticReport resource conforming to the SGHI DiagnostiReport profile. |
| [ExampleSGHIDocumentReference](DocumentReference-ExampleSGHIDocumentReference.md) | An example of an DocumentReference resource conforming to the SGHI SGHIDocumentReference profile. |
| [ExampleSGHIEncounter](Encounter-ExampleSGHIEncounter.md) | An example of an Encounter resource conforming to the SGHI Encounter profile. |
| [ExampleSGHILocation](Location-ExampleSGHILocation.md) | An example of an Location resource conforming to the SGHI Location profile. |
| [ExampleSGHIMedicationRequest](MedicationRequest-ExampleSGHIMedicationRequest.md) | An example of a MedicationRequest resource conforming to the SGHI MedicationRequest profile. |
| [ExampleSGHIObservation](Observation-ExampleSGHIObservation.md) | An example of an Observation resource conforming to the SGHI Observation profile |
| [ExampleSGHIPatient](Patient-ExampleSGHIPatient.md) | An example of a patient profile. |
| [ExampleSGHIPractitioner](Practitioner-ExampleSGHIPractitioner.md) | An example of a Practitioner resource conforming to the SGHI Practitioner profile |
| [ExampleSGHIPractitionerRole](PractitionerRole-ExampleSGHIPractitionerRole.md) | An example of a PractitionerRole resource conforming to the SGHI PractitionerRole profile. |
| [ExampleSGHIProcedure](Procedure-ExampleSGHIProcedure.md) | An example of a Procedure resource conforming to the SGHI Procedure profile. |
| [ExampleSGHIRiskAssessment](RiskAssessment-ExampleSGHIRiskAssessment.md) | An example of a RiskAssessment resource conforming to the SGHI RiskAssessment profile. |
| [ExampleSGHIServiceRequest](ServiceRequest-ExampleSGHIServiceRequest.md) | An example of a ServiceRequest resource conforming to the SGHI ServiceRequest profile. |
| [ExampleSGHISpecimen](Specimen-ExampleSGHISpecimen.md) | An example of Specimen resource that conforms to SGHI Specimen profile |
| [ExampleSGHISubstance](Substance-ExampleSGHISubstance.md) | An example of a substance profile |
| [ExampleSGHITask](Task-ExampleSGHITask.md) | An example of a Task resource conforming to the SGHI Task profile. |
| [PlanDefinition Title](PlanDefinition-ExampleSGHIPlanDefinition.md) | An example of an PlanDefintion resource conforming to the SGHI PlanDefinition profile. |
| [SGHI Discharge Summary for John Doe](Composition-ExampleSGHIComposition.md) | An expanded Composition demonstration. |
| [SGHI Medication Dispense](MedicationDispense-ExampleSGHIMedicationDispense.md) | An example of a Medication Dispense resource adhering to SGHI's Medication Dispense |
| [SGHI Medication resource example](Medication-ExampleSGHIMedication.md) | An example of SGHI Medication resource Example |

