# SGHI Default Identifier Types - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Default Identifier Types**

## ValueSet: SGHI Default Identifier Types 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIDefaultIdentifierTypes |

 
Default identifier types used in SGHI's systems 

 **References** 

* [SGHI Activity Defintion Profile](StructureDefinition-activitydefinition.md)
* [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md)
* [SGHI Appointment Profile](StructureDefinition-appointment.md)
* [SGHI Care Plan](StructureDefinition-careplan.md)
* [SGHI Composition](StructureDefinition-composition.md)
* [SGHI Condition](StructureDefinition-condition.md)
* [SGHI Consent](StructureDefinition-consent.md)
* [SGHI DiagnosticReport](StructureDefinition-diagnosticreport.md)
* [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md)
* [SGHI Encounter](StructureDefinition-encounter.md)
* [SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md)
* [SGHI Location](StructureDefinition-fhir-location.md)
* [SGHI Medication](StructureDefinition-medication.md)
* [SGHI Medication Dispense](StructureDefinition-medicationdispense.md)
* [SGHI MedicationRequest](StructureDefinition-medicationrequest.md)
* [SGHI Observation](StructureDefinition-observation.md)
* [SGHI Plan Definition Profile](StructureDefinition-plandefinition.md)
* [SGHI PractitionerRole](StructureDefinition-practitionerrole.md)
* [SGHI Procedure](StructureDefinition-procedure.md)
* [SGHI RiskAssessment](StructureDefinition-riskassessment.md)
* [SGHI ServiceRequest](StructureDefinition-servicerequest.md)
* [SGHI Specimen](StructureDefinition-specimen.md)
* [SGHI Substance](StructureDefinition-substance.md)
* [SGHI Task](StructureDefinition-task.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "default-identifier-types",
  "url" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types",
  "version" : "0.1.0",
  "name" : "SGHIDefaultIdentifierTypes",
  "title" : "SGHI Default Identifier Types",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Default identifier types used in SGHI's systems",
  "compose" : {
    "include" : [
      {
        "system" : "https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIDefaultIdentifierCodeSystem"
      }
    ]
  }
}

```
