# SGHI Body Site Value Set - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Body Site Value Set**

## ValueSet: SGHI Body Site Value Set 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/ValueSet/body-site-value-set | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIBodySiteValueSet |

 
Custom body site value set 

 **References** 

* [SGHI Dosage](StructureDefinition-dosage.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "body-site-value-set",
  "url" : "https://fhir.slade360.co.ke/fhir/ValueSet/body-site-value-set",
  "version" : "0.1.0",
  "name" : "SGHIBodySiteValueSet",
  "title" : "SGHI Body Site Value Set",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Custom body site value set",
  "compose" : {
    "include" : [
      {
        "system" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem",
        "concept" : [
          {
            "code" : "111002",
            "display" : "Parathyroid gland"
          }
        ]
      }
    ]
  }
}

```
