# Blood Pressure Units - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Blood Pressure Units**

## ValueSet: Blood Pressure Units 

| | |
| :--- | :--- |
| *Official URL*:https://ocl-testing-api.savannahghi.org/fhir/ValueSet/blood-pressure-units | *Version*:0.1.0 |
| Active as of 2024-11-26 | *Computable Name*:BloodPressureUnits |
| *Other Identifiers:*Accession ID: /orgs/SIL/ValueSet/blood-pressure-units/ | |

 
Units used for measuring blood pressure. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R5/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "blood-pressure-units",
  "meta" : {
    "lastUpdated" : "2024-11-26T09:29:28.203939Z"
  },
  "url" : "https://ocl-testing-api.savannahghi.org/fhir/ValueSet/blood-pressure-units",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/v2/0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ],
        "text" : "Accession ID"
      },
      "system" : "https://ocl-testing-api.savannahghi.org",
      "value" : "/orgs/SIL/ValueSet/blood-pressure-units/"
    }
  ],
  "version" : "0.1.0",
  "name" : "BloodPressureUnits",
  "title" : "Blood Pressure Units",
  "status" : "active",
  "date" : "2024-11-26T09:29:27.572922Z",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Units used for measuring blood pressure.",
  "compose" : {
    "include" : [
      {
        "system" : "http://unitsofmeasure.org",
        "concept" : [
          {
            "code" : "mm[Hg]"
          },
          {
            "code" : "kPa"
          }
        ]
      }
    ]
  }
}

```
