# ExampleSGHISubstance - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHISubstance**

## Example Substance: ExampleSGHISubstance

Profiles: [SGHI Substance](StructureDefinition-substance.md), `{{HAPI_FHIR_BASE_URL}}/StructureDefinition/substance`

**identifier**: National Drug Code/SUBST001

**instance**: true

**status**: Active

**category**: Chemical

### Codes

| | |
| :--- | :--- |
| - | **Concept** |
| * | Paracetamol |

**description**: 

Paracetamol 500mg tablets

**expiry**: 2024-12-31

**quantity**: 100 milligram(Details: UCUM codemg = 'mg')

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Quantity** | **Substance[x]** |
| * | 500 mg(Details: UCUM codemg = 'mg')/1 TAB(Details: UCUM codeTAB = 'TAB') | Paracetamol |



## Resource Content

```json
{
  "resourceType" : "Substance",
  "id" : "ExampleSGHISubstance",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/substance",
      "{{HAPI_FHIR_BASE_URL}}/StructureDefinition/substance"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NDC",
            "display" : "National Drug Code"
          }
        ]
      },
      "system" : "http://example.org/substances",
      "value" : "SUBST001",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "instance" : true,
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/substance-category",
          "code" : "chemical",
          "display" : "Chemical"
        }
      ]
    }
  ],
  "code" : {
    "concept" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "387458008",
          "display" : "Paracetamol"
        }
      ]
    }
  },
  "description" : "Paracetamol 500mg tablets",
  "expiry" : "2024-12-31",
  "quantity" : {
    "value" : 100,
    "unit" : "milligram",
    "system" : "http://unitsofmeasure.org",
    "code" : "mg"
  },
  "ingredient" : [
    {
      "quantity" : {
        "numerator" : {
          "value" : 500,
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 1,
          "system" : "http://unitsofmeasure.org",
          "code" : "TAB"
        }
      },
      "substanceCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "387458008",
            "display" : "Paracetamol"
          }
        ]
      }
    }
  ]
}

```
