# ServiceRequest Transforms: R4 → SGHI R5 - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest Transforms: R4 → SGHI R5**

## StructureMap: ServiceRequest Transforms: R4 → SGHI R5 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureMap/ServiceRequestSGHI5 | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:ServiceRequestSGHI5 |

 
ServiceRequestTransformsR4SGHIR5 



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "ServiceRequestSGHI5",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureMap/ServiceRequestSGHI5",
  "version" : "0.1.0",
  "name" : "ServiceRequestSGHI5",
  "title" : "ServiceRequest Transforms: R4 → SGHI R5",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "ServiceRequestTransformsR4SGHIR5",
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/4.0/StructureDefinition/ServiceRequest",
      "mode" : "source",
      "alias" : "ServiceRequestR4"
    },
    {
      "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/servicerequest",
      "mode" : "target",
      "alias" : "SGHIServiceRequest"
    }
  ],
  "group" : [
    {
      "name" : "SGHIServiceRequest",
      "typeMode" : "type-and-types",
      "input" : [
        {
          "name" : "src",
          "type" : "ServiceRequestR4",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "type" : "SGHIServiceRequest",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "uuid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "uuid"
                }
              ]
            }
          ]
        },
        {
          "name" : "active",
          "source" : [
            {
              "context" : "src",
              "element" : "active"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "active",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "true"
                }
              ]
            }
          ]
        },
        {
          "name" : "language",
          "source" : [
            {
              "context" : "src",
              "element" : "language",
              "variable" : "sl"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "language",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sl"
                }
              ]
            }
          ]
        },
        {
          "name" : "authoredOn",
          "source" : [
            {
              "context" : "src",
              "element" : "authoredOn",
              "variable" : "sa"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "authoredOn",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sa"
                }
              ]
            }
          ]
        },
        {
          "name" : "createhardcodedtext",
          "source" : [
            {
              "context" : "src",
              "condition" : "text.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "tgt_n",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "settextstatus",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "generated"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settextdiv",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "tgt_n",
                  "element" : "div",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><h1>Generated text</h1></div>"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting text",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "text",
              "variable" : "ttt",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Narrative"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "text",
              "source" : [
                {
                  "context" : "src",
                  "element" : "text",
                  "variable" : "st"
                }
              ],
              "rule" : [
                {
                  "name" : "status",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "status",
                      "variable" : "s"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "status",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueId" : "s"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "wraptextinhtml",
                  "source" : [
                    {
                      "context" : "st",
                      "element" : "div",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "ttt",
                      "element" : "div",
                      "transform" : "evaluate",
                      "parameter" : [
                        {
                          "valueString" : "'<div xmlns=\\\"http://www.w3.org/1999/xhtml\\\"><p>' + d + '</p></div>'"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "addfhirididentifier",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "s_id"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "identifier",
              "variable" : "t_ident",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Identifier"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "copyid",
              "source" : [
                {
                  "context" : "s_id",
                  "variable" : "uuid"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "value",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "uuid"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setuse",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "use",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "official"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setsystem",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "inittype",
              "source" : [
                {
                  "context" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "t_ident",
                  "element" : "type",
                  "variable" : "t_type",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "initcoding",
                  "source" : [
                    {
                      "context" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_type",
                      "element" : "coding",
                      "variable" : "t_code",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Coding"
                        }
                      ]
                    }
                  ],
                  "rule" : [
                    {
                      "name" : "typesystem",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "system",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "https://fhir.slade360.co.ke/fhir/CodeSystem/identifier-codesystem"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typecode",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "code",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "fhir-id"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "name" : "typedisplay",
                      "source" : [
                        {
                          "context" : "src"
                        }
                      ],
                      "target" : [
                        {
                          "context" : "t_code",
                          "element" : "display",
                          "transform" : "copy",
                          "parameter" : [
                            {
                              "valueString" : "FHIR Id"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setting owner",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "st"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "t_ident",
                      "element" : "assigner",
                      "variable" : "ta",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "st"
                        },
                        {
                          "valueId" : "ta"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ],
          "documentation" : "Create identifier"
        },
        {
          "name" : "set profile in meta",
          "source" : [
            {
              "context" : "src",
              "element" : "meta",
              "variable" : "s_meta"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "meta",
              "variable" : "t_meta"
            }
          ],
          "rule" : [
            {
              "name" : "lastUpdated",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "lastUpdated",
                  "variable" : "sl"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "lastUpdated",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sl"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "language",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "language",
                  "variable" : "sl"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "language",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sl"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "tags",
              "source" : [
                {
                  "context" : "s_meta",
                  "element" : "tags",
                  "variable" : "st"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "tags",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "st"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "setprofileinmeta",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sp",
                  "condition" : "profile.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "t_meta",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/servicerequest"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coppying status",
          "source" : [
            {
              "context" : "src",
              "condition" : "status != 'finished'"
            }
          ],
          "rule" : [
            {
              "name" : "status",
              "source" : [
                {
                  "context" : "src",
                  "element" : "status",
                  "variable" : "sd"
                }
              ],
              "target" : [
                {
                  "context" : "tgt",
                  "element" : "status",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "sd"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "settingR5status",
          "source" : [
            {
              "context" : "src",
              "condition" : "status = 'finished'"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "status",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "completed"
                }
              ]
            }
          ]
        },
        {
          "name" : "dateTime",
          "source" : [
            {
              "context" : "src",
              "element" : "dateTime",
              "variable" : "sd"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "date",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sd"
                }
              ]
            }
          ]
        },
        {
          "name" : "basedOn",
          "source" : [
            {
              "context" : "src",
              "element" : "basedOn",
              "variable" : "sb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "basedOn",
              "variable" : "tb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sb"
                },
                {
                  "valueId" : "tb"
                }
              ]
            }
          ]
        },
        {
          "name" : "category",
          "source" : [
            {
              "context" : "src",
              "element" : "category",
              "variable" : "scat"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "category",
              "variable" : "tcat"
            }
          ],
          "rule" : [
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "scat",
                  "element" : "coding",
                  "variable" : "d",
                  "condition" : "d.system.exists().not()"
                }
              ],
              "target" : [
                {
                  "context" : "tcat",
                  "element" : "coding",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                    },
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "coding",
              "source" : [
                {
                  "context" : "scat",
                  "element" : "coding",
                  "variable" : "d",
                  "condition" : "d.system.exists()"
                }
              ],
              "target" : [
                {
                  "context" : "tcat",
                  "element" : "coding",
                  "variable" : "tcoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "code",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "code"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "system",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "system"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcoding",
                      "element" : "display",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "code",
                  "source" : [
                    {
                      "context" : "d",
                      "element" : "code",
                      "variable" : "d"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tcat",
                      "element" : "text",
                      "transform" : "translate",
                      "parameter" : [
                        {
                          "valueId" : "d"
                        },
                        {
                          "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoFHIRCategoryCodeBindingsMap"
                        },
                        {
                          "valueString" : "display"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "encounter",
          "source" : [
            {
              "context" : "src",
              "element" : "encounter",
              "variable" : "se"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "encounter",
              "variable" : "te"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "se"
                },
                {
                  "valueId" : "te"
                }
              ]
            }
          ]
        },
        {
          "name" : "requester",
          "source" : [
            {
              "context" : "src",
              "element" : "requester",
              "variable" : "sr"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "requester",
              "variable" : "tr"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sr"
                },
                {
                  "valueId" : "tr"
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "sbb"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "subject",
              "variable" : "tbb"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sbb"
                },
                {
                  "valueId" : "tbb"
                }
              ]
            }
          ]
        },
        {
          "name" : "performer",
          "source" : [
            {
              "context" : "src",
              "element" : "performer",
              "variable" : "sp"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "performer",
              "variable" : "tp"
            }
          ],
          "dependent" : [
            {
              "name" : "TransformReference",
              "parameter" : [
                {
                  "valueId" : "sp"
                },
                {
                  "valueId" : "tp"
                }
              ]
            }
          ]
        },
        {
          "name" : "settingperformer",
          "source" : [
            {
              "context" : "src",
              "condition" : "performer.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "setting performer",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "sp"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tgt",
                      "element" : "performer",
                      "variable" : "tp",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "sp"
                        },
                        {
                          "valueId" : "tp"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "settingrequester",
          "source" : [
            {
              "context" : "src",
              "condition" : "requester.exists().not()"
            }
          ],
          "rule" : [
            {
              "name" : "setting requester",
              "source" : [
                {
                  "context" : "src",
                  "element" : "meta",
                  "variable" : "sm"
                }
              ],
              "rule" : [
                {
                  "name" : "tag",
                  "source" : [
                    {
                      "context" : "sm",
                      "element" : "tag",
                      "listMode" : "last",
                      "variable" : "sr"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "tgt",
                      "element" : "requester",
                      "variable" : "tr",
                      "transform" : "create",
                      "parameter" : [
                        {
                          "valueString" : "Reference"
                        }
                      ]
                    }
                  ],
                  "dependent" : [
                    {
                      "name" : "TransformAssigner",
                      "parameter" : [
                        {
                          "valueId" : "sr"
                        },
                        {
                          "valueId" : "tr"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "priority",
          "source" : [
            {
              "context" : "src",
              "element" : "priority",
              "variable" : "sp"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "priority",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sp"
                }
              ]
            }
          ]
        },
        {
          "name" : "intent",
          "source" : [
            {
              "context" : "src",
              "element" : "intent",
              "variable" : "sti"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "intent",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sti"
                }
              ]
            }
          ]
        },
        {
          "name" : "translate codeableConcept to CodeableReference in R5",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "code",
              "variable" : "trf",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableReference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "code",
              "source" : [
                {
                  "context" : "src",
                  "element" : "code",
                  "variable" : "scc"
                }
              ],
              "target" : [
                {
                  "context" : "trf",
                  "element" : "concept",
                  "variable" : "tcc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TranslateCoding",
                  "parameter" : [
                    {
                      "valueId" : "scc"
                    },
                    {
                      "valueId" : "tcc"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "setting reason",
          "source" : [
            {
              "context" : "src"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reason",
              "variable" : "tr",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableReference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "code",
              "source" : [
                {
                  "context" : "src",
                  "element" : "code",
                  "variable" : "scc"
                }
              ],
              "target" : [
                {
                  "context" : "tr",
                  "element" : "concept",
                  "variable" : "tcc",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "CodeableConcept"
                    }
                  ]
                }
              ],
              "dependent" : [
                {
                  "name" : "TranslateCoding",
                  "parameter" : [
                    {
                      "valueId" : "scc"
                    },
                    {
                      "valueId" : "tcc"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformAssigner",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "code"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "Organization/"
                },
                {
                  "valueId" : "code"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting default display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "d"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "d"
                }
              ]
            }
          ]
        },
        {
          "name" : "code",
          "source" : [
            {
              "context" : "src",
              "element" : "code",
              "variable" : "dc"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "dc"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformReference",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "src",
          "mode" : "source"
        },
        {
          "name" : "tgt",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "src",
              "element" : "id",
              "variable" : "sid"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sid"
                }
              ]
            }
          ]
        },
        {
          "name" : "reference",
          "source" : [
            {
              "context" : "src",
              "element" : "reference",
              "variable" : "sf"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "reference",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sf"
                }
              ]
            }
          ]
        },
        {
          "name" : "display",
          "source" : [
            {
              "context" : "src",
              "element" : "display",
              "variable" : "sd"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "sd"
                }
              ]
            }
          ]
        },
        {
          "name" : "setting display",
          "source" : [
            {
              "context" : "src",
              "condition" : "display.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tgt",
              "element" : "display",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "Unknown display"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TranslateCoding",
      "typeMode" : "types",
      "input" : [
        {
          "name" : "scc",
          "mode" : "source"
        },
        {
          "name" : "tcc",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "d",
              "condition" : "d.system.exists().not()"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "transform" : "translate",
              "parameter" : [
                {
                  "valueId" : "d"
                },
                {
                  "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCServiceRequestMap"
                },
                {
                  "valueString" : "Coding"
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'Pap smear/cytology')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "LA16047-5"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "scode",
                  "element" : "display",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'HPV')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "LP14836-8"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settinghpvdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Human papilloma virus"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'Mammogram')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "LA16046-7"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "scode",
                  "element" : "display",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'VIA')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "LP404404-8"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Screening techniques | Cervix or Vagina | Cytology"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'Biopsy')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "LA15393-4"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Biopsy"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'Ultrasound')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "24630-6"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "US Chest"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'MRI')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "30794-2"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "MR Breast"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'Prostate Specific Antigen - Serum')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "32465-7"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Physical findings of Prostate"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "scode",
              "condition" : "(scode.code = '1271').exists() and (scode.display = 'Prostate Specific Antigen - Whole Blood')"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcode"
            }
          ],
          "rule" : [
            {
              "name" : "override code",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "code",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "LP15247-7"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "settingdisplay",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Whole Blood"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "overriedsystem",
              "source" : [
                {
                  "context" : "scode"
                }
              ],
              "target" : [
                {
                  "context" : "tcode",
                  "element" : "system",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://loinc.org"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "coding",
          "source" : [
            {
              "context" : "scc",
              "element" : "coding",
              "variable" : "d",
              "condition" : "d.system.exists()"
            }
          ],
          "target" : [
            {
              "context" : "tcc",
              "element" : "coding",
              "variable" : "tcoding",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Coding"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "code",
              "source" : [
                {
                  "context" : "d",
                  "element" : "code",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tcoding",
                  "element" : "code",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCServiceRequestMap"
                    },
                    {
                      "valueString" : "code"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "code",
              "source" : [
                {
                  "context" : "d",
                  "element" : "code",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tcoding",
                  "element" : "system",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCServiceRequestMap"
                    },
                    {
                      "valueString" : "system"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "code",
              "source" : [
                {
                  "context" : "d",
                  "element" : "code",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tcoding",
                  "element" : "display",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCServiceRequestMap"
                    },
                    {
                      "valueString" : "display"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "code",
              "source" : [
                {
                  "context" : "d",
                  "element" : "code",
                  "variable" : "d"
                }
              ],
              "target" : [
                {
                  "context" : "tcoding",
                  "element" : "text",
                  "transform" : "translate",
                  "parameter" : [
                    {
                      "valueId" : "d"
                    },
                    {
                      "valueString" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCServiceRequestMap"
                    },
                    {
                      "valueString" : "display"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
